/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft;

import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.minecraft.HolderSetImpl;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import java.util.function.Function;

public interface HolderSet {
    public static HolderSet of(String tagKey) {
        return new HolderSetImpl.Tag(tagKey);
    }

    public static HolderSet of(int[] ids) {
        return new HolderSetImpl.Ids(ids);
    }

    public static HolderSet fromTag(Tag tag, Function<String, Integer> mappingFunction) {
        if (tag instanceof StringTag) {
            StringTag stringTag = (StringTag)tag;
            if (stringTag.getValue().startsWith("#")) {
                return HolderSet.of(stringTag.getValue().substring(1));
            }
            int id = mappingFunction.apply(stringTag.getValue());
            return HolderSet.of(new int[]{id});
        }
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            int[] ids = new int[listTag.size()];
            for (int i = 0; i < listTag.size(); ++i) {
                String value = ((StringTag)listTag.get(i)).getValue();
                ids[i] = mappingFunction.apply(value);
            }
            return HolderSet.of(ids);
        }
        throw new IllegalArgumentException();
    }

    public String tagKey();

    public boolean hasTagKey();

    public int[] ids();

    public boolean hasIds();

    public HolderSet rewrite(Int2IntFunction var1);
}

