/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.codec;

import com.viaversion.viaversion.api.data.FullMappings;
import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.minecraft.codec.CodecContext;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.rewriter.RegistryDataRewriter;
import com.viaversion.viaversion.util.Key;
import com.viaversion.viaversion.util.KeyMappings;
import org.checkerframework.checker.nullness.qual.Nullable;

final class RegistryAccessImpl
implements CodecContext.RegistryAccess {
    private final RegistryDataRewriter registryDataRewriter;
    private final MappingData mappingData;
    private final boolean mapped;

    RegistryAccessImpl(Protocol<?, ?, ?, ?> protocol) {
        this.mappingData = protocol.getMappingData();
        this.registryDataRewriter = protocol.getRegistryDataRewriter();
        this.mapped = false;
    }

    private RegistryAccessImpl(MappingData mappingData, RegistryDataRewriter registryDataRewriter, boolean mapped) {
        this.mappingData = mappingData;
        this.registryDataRewriter = registryDataRewriter;
        this.mapped = mapped;
    }

    @Override
    public Key item(int id) {
        return this.key(this.mappingData.getFullItemMappings(), id);
    }

    @Override
    public Key attributeModifier(int id) {
        return this.key(this.mappingData.getAttributeMappings(), id);
    }

    @Override
    public Key dataComponentType(int id) {
        return this.key(this.mappingData.getDataComponentSerializerMappings(), id);
    }

    @Override
    public Key entity(int id) {
        return this.key(this.mappingData.getEntityMappings(), id);
    }

    @Override
    public Key blockEntity(int id) {
        return this.key(this.mappingData.getBlockEntityMappings(), id);
    }

    @Override
    public Key sound(int id) {
        return this.key(this.mappingData.getFullSoundMappings(), id);
    }

    @Override
    public Key key(MappingData.MappingType mappingType, int id) {
        return this.key(this.mappingData.getFullMappings(mappingType), id);
    }

    @Override
    public int id(MappingData.MappingType mappingType, String identifier) {
        FullMappings mappings = this.mappingData.getFullMappings(mappingType);
        return this.mapped ? mappings.mappedId(identifier) : mappings.id(identifier);
    }

    @Override
    public Key registryKey(String registry, int id) {
        KeyMappings mappings = this.registryDataRewriter.getMappings(registry);
        String identifier = id >= 0 && id < mappings.size() ? mappings.idToKey(id) : null;
        return this.key(identifier, id);
    }

    private Key key(FullMappings mappings, int id) {
        String identifier = this.mapped ? mappings.mappedIdentifier(id) : mappings.identifier(id);
        return this.key(identifier, id);
    }

    private Key key(@Nullable String identifier, int id) {
        return identifier != null ? Key.of(identifier) : Key.of("viaversion", "unknown/" + id);
    }

    @Override
    public CodecContext.RegistryAccess withMapped(boolean mapped) {
        return this.mapped == mapped ? this : new RegistryAccessImpl(this.mappingData, this.registryDataRewriter, mapped);
    }
}

