/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft;

import com.viaversion.viaversion.api.minecraft.RegistryKey;
import com.viaversion.viaversion.util.Key;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum RegistryType implements RegistryKey
{
    BLOCK("block"),
    ITEM("item"),
    FLUID("fluid"),
    ENTITY("entity_type"),
    GAME_EVENT("game_event"),
    ENCHANTMENT("enchantment");

    private static final Map<String, RegistryType> MAP;
    private static final RegistryType[] VALUES;
    private final String identifier;

    public static RegistryType[] getValues() {
        return VALUES;
    }

    public static @Nullable RegistryType getByKey(String identifier) {
        return MAP.get(identifier);
    }

    private RegistryType(String identifier) {
        this.identifier = identifier;
    }

    public String identifier() {
        return this.identifier;
    }

    @Override
    public Key key() {
        return Key.of(this.identifier);
    }

    static {
        MAP = new HashMap<String, RegistryType>();
        VALUES = RegistryType.values();
        for (RegistryType type : RegistryType.getValues()) {
            MAP.put(type.identifier, type);
        }
    }
}

