/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.anthropophagy.common.component.entity;

import java.util.ArrayList;
import java.util.List;
import moriyashiine.anthropophagy.common.Anthropophagy;
import moriyashiine.anthropophagy.common.init.ModEntityComponents;
import moriyashiine.strawberrylib.api.event.PreventEquipmentUsageEvent;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

public class CannibalLevelComponent
implements AutoSyncedComponent {
    public static final int MAX_LEVEL = 120;
    public static final int MIN_FUNCTIONAL_LEVEL = 30;
    private static final float MAX_FUNCTIONAL_LEVEL = 90.0f;
    private static final class_2960 ATTACK_DAMAGE_ID = Anthropophagy.id("attack_damage");
    private static final class_2960 ARMOR_ID = Anthropophagy.id("armor");
    private static final class_2960 KNOCKBACK_RESISTANCE_ID = Anthropophagy.id("knockback_resistance");
    private static final class_2960 MOVEMENT_SPEED_ID = Anthropophagy.id("movement_speed");
    private static final class_2960 SAFE_FALL_DISTANCE_ID = Anthropophagy.id("safe_fall_distance");
    private static final class_2960 STEP_HEIGHT_ID = Anthropophagy.id("step_height");
    private final class_1657 obj;
    private int cannibalLevel = 0;

    public CannibalLevelComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.cannibalLevel = readView.method_71424("CannibalLevel", 0);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71465("CannibalLevel", this.cannibalLevel);
    }

    public void sync() {
        ModEntityComponents.CANNIBAL_LEVEL.sync((Object)this.obj);
    }

    public int getCannibalLevel() {
        return this.cannibalLevel;
    }

    public void setCannibalLevel(int cannibalLevel) {
        this.cannibalLevel = cannibalLevel;
    }

    public boolean cannotEquip(class_1799 stack) {
        if (((class_9285)stack.method_58695(class_9334.field_49636, (Object)class_9285.field_49326)).comp_2393().stream().anyMatch(entry -> entry.comp_2395() == class_5134.field_23724) || stack.method_57826(class_9334.field_54197)) {
            class_1304 slot = this.obj.method_32326(stack);
            if (this.cannibalLevel >= 30 && slot == class_1304.field_6172) {
                return true;
            }
            if (this.cannibalLevel >= 50 && slot == class_1304.field_6169) {
                return true;
            }
            if (this.cannibalLevel >= 70 && slot == class_1304.field_6166) {
                return true;
            }
            return this.cannibalLevel >= 90 && slot == class_1304.field_6174;
        }
        return false;
    }

    public void updateAttributes() {
        if (!this.obj.method_73183().method_8608()) {
            PreventEquipmentUsageEvent.triggerEquipmentCheck((class_1309)this.obj);
            this.obj.method_5996(class_5134.field_23721).method_6200(ATTACK_DAMAGE_ID);
            this.obj.method_5996(class_5134.field_23724).method_6200(ARMOR_ID);
            this.obj.method_5996(class_5134.field_23718).method_6200(KNOCKBACK_RESISTANCE_ID);
            this.obj.method_5996(class_5134.field_23719).method_6200(MOVEMENT_SPEED_ID);
            this.obj.method_5996(class_5134.field_49079).method_6200(SAFE_FALL_DISTANCE_ID);
            this.obj.method_5996(class_5134.field_47761).method_6200(STEP_HEIGHT_ID);
            CannibalLevelComponent.getModifiersForLevel(this.cannibalLevel).attributes().forEach(pair -> this.obj.method_5996((class_6880)pair.method_15442()).method_26837((class_1322)pair.method_15441()));
        }
    }

    public float getJumpBoost() {
        if (CannibalLevelComponent.compareLevel(this.obj, 90, 121)) {
            return 0.3f;
        }
        if (CannibalLevelComponent.compareLevel(this.obj, 70, 90)) {
            return 0.23f;
        }
        if (CannibalLevelComponent.compareLevel(this.obj, 50, 70)) {
            return 0.16f;
        }
        if (CannibalLevelComponent.compareLevel(this.obj, 30, 50)) {
            return 0.09f;
        }
        return 0.0f;
    }

    private static AttributeModifierSet getModifiersForLevel(int level) {
        AttributeModifierSet attributes = new AttributeModifierSet(new ArrayList<class_3545<class_6880<class_1320>, class_1322>>());
        if (level > 30) {
            attributes.addModifier((class_6880<class_1320>)class_5134.field_23721, new class_1322(ATTACK_DAMAGE_ID, (double)CannibalLevelComponent.lerp(level, 6), class_1322.class_1323.field_6328));
            attributes.addModifier((class_6880<class_1320>)class_5134.field_23724, new class_1322(ARMOR_ID, (double)CannibalLevelComponent.lerp(level, 14), class_1322.class_1323.field_6328));
            attributes.addModifier((class_6880<class_1320>)class_5134.field_23718, new class_1322(KNOCKBACK_RESISTANCE_ID, (double)CannibalLevelComponent.lerp(level, 0.2f), class_1322.class_1323.field_6328));
            attributes.addModifier((class_6880<class_1320>)class_5134.field_23719, new class_1322(MOVEMENT_SPEED_ID, (double)CannibalLevelComponent.lerp(level, 0.5f), class_1322.class_1323.field_6331));
            attributes.addModifier((class_6880<class_1320>)class_5134.field_49079, new class_1322(SAFE_FALL_DISTANCE_ID, (double)CannibalLevelComponent.lerp(level, 4), class_1322.class_1323.field_6328));
            if (level >= 60) {
                attributes.addModifier((class_6880<class_1320>)class_5134.field_47761, new class_1322(STEP_HEIGHT_ID, 1.0, class_1322.class_1323.field_6328));
            }
        }
        attributes.attributes().removeIf(pair -> ((class_1322)pair.method_15441()).comp_2449() == 0.0);
        return attributes;
    }

    private static float lerp(int level, float end) {
        return class_3532.method_16439((float)Math.min(1.0f, (float)(level - 30) / 60.0f), (float)0.0f, (float)end);
    }

    private static int lerp(int level, int end) {
        return class_3532.method_48781((float)Math.min(1.0f, (float)(level - 30) / 60.0f), (int)0, (int)end);
    }

    private static boolean compareLevel(class_1657 player, int minInc, int maxExc) {
        int level = ((CannibalLevelComponent)ModEntityComponents.CANNIBAL_LEVEL.get((Object)player)).getCannibalLevel();
        return level >= minInc && level < maxExc;
    }

    private record AttributeModifierSet(List<class_3545<class_6880<class_1320>, class_1322>> attributes) {
        void addModifier(class_6880<class_1320> attribute, class_1322 modifier) {
            this.attributes().add((class_3545<class_6880<class_1320>, class_1322>)new class_3545(attribute, (Object)modifier));
        }
    }
}

