/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.anthropophagy.common.entity;

import moriyashiine.anthropophagy.common.entity.ai.goal.EatFleshGoal;
import moriyashiine.anthropophagy.common.entity.ai.goal.FleeGoal;
import moriyashiine.anthropophagy.common.entity.ai.goal.PigluttonMeleeAttackGoal;
import moriyashiine.anthropophagy.common.entity.ai.goal.PigluttonWanderAroundFarGoal;
import moriyashiine.anthropophagy.common.entity.ai.goal.StalkGoal;
import moriyashiine.anthropophagy.common.entity.ai.pathing.BetterMobNavigation;
import moriyashiine.anthropophagy.common.init.ModEntityTypes;
import moriyashiine.anthropophagy.common.init.ModSoundEvents;
import moriyashiine.anthropophagy.common.tag.ModBlockTags;
import moriyashiine.anthropophagy.common.tag.ModEntityTypeTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;

public class PigluttonEntity
extends class_1588 {
    private static final int DAMAGE_THRESHOLD = 20;
    private static final class_2940<Boolean> EATING = class_2945.method_12791(PigluttonEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ATTACK_INDEX = class_2945.method_12791(PigluttonEntity.class, (class_2941)class_2943.field_13327);
    public boolean canAttack = false;
    public int overhealAmount = 0;
    public int stalkTicks = 0;
    private float damageTaken = 0.0f;
    private int fleeingTicks = 0;
    private int attackTicks = 0;
    private int eatingTicks = 0;
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 attackLeftAnimationState = new class_7094();
    public final class_7094 attackRightAnimationState = new class_7094();
    public final class_7094 attackTusksAnimationState = new class_7094();
    public final class_7094 eatAnimationState = new class_7094();

    public PigluttonEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6189 = new BetterMobNavigation((class_1314)this, this.method_73183(), 3);
        this.field_6194 = 30;
        this.method_5941(class_7.field_6, 0.0f);
        this.method_5941(class_7.field_18, -1.0f);
    }

    public static class_5132.class_5133 buildAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 80.0).method_26868(class_5134.field_23724, 14.0).method_26868(class_5134.field_23721, 32.0).method_26868(class_5134.field_23719, 0.6).method_26868(class_5134.field_23718, 0.8).method_26868(class_5134.field_23717, 64.0).method_26868(class_5134.field_47761, 1.0);
    }

    public static boolean canSpawn(class_1299<PigluttonEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return random.method_43048(8) == 0 && class_1588.method_20680(type, (class_5425)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random);
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.setEating(view.method_71433("Eating", false));
        this.setAttackIndex(view.method_71424("AttackIndex", 0));
        this.canAttack = view.method_71433("CanAttack", false);
        this.damageTaken = view.method_71423("DamageTaken", 0.0f);
        this.overhealAmount = view.method_71424("OverhealAmount", 0);
        this.stalkTicks = view.method_71424("StalkTicks", 0);
        this.fleeingTicks = view.method_71424("FleeingTicks", 0);
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71472("Eating", this.isEating());
        view.method_71465("AttackIndex", this.getAttackIndex());
        view.method_71472("CanAttack", this.canAttack);
        view.method_71464("DamageTaken", this.damageTaken);
        view.method_71465("OverhealAmount", this.overhealAmount);
        view.method_71465("StalkTicks", this.stalkTicks);
        view.method_71465("FleeingTicks", this.fleeingTicks);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(EATING, (Object)false);
        builder.method_56912(ATTACK_INDEX, (Object)0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new EatFleshGoal(this));
        this.field_6201.method_6277(2, (class_1352)new StalkGoal(this));
        this.field_6201.method_6277(2, (class_1352)new FleeGoal(this));
        this.field_6201.method_6277(3, (class_1352)new PigluttonMeleeAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(4, (class_1352)new PigluttonWanderAroundFarGoal(this, 0.1666666716337204));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 16.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, false, (target, world) -> !this.isBusy() && target.method_5864().method_20210(ModEntityTypeTags.PIGLUTTON_TARGETS)));
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_73183().method_8608()) {
            this.idleAnimationState.method_41324(this.field_6012);
            int index = this.getAttackIndex();
            this.attackLeftAnimationState.method_45317(this.attackTicks > 0 && index == 0, this.field_6012);
            this.attackRightAnimationState.method_45317(this.attackTicks > 0 && index == 1, this.field_6012);
            this.attackTusksAnimationState.method_45317(this.attackTicks > 0 && index == 2, this.field_6012);
            this.eatAnimationState.method_45317(this.eatingTicks > 0, this.field_6012);
        }
    }

    protected void method_5958(class_3218 world) {
        super.method_5958(world);
        if (this.fleeingTicks > 0 && --this.fleeingTicks % 20 == 0) {
            this.method_73183().method_8396(null, this.method_24515(), ModSoundEvents.ENTITY_PIGLUTTON_FLEE, this.method_5634(), this.method_6107() * 4.0f, this.method_6017());
        }
        if (this.attackTicks > 0 && --this.attackTicks == 0 && this.method_5968() != null && (double)this.method_5739((class_1297)this.method_5968()) < 4.5 * (double)this.method_55693()) {
            this.method_6121(world, (class_1297)this.method_5968());
        }
        if (this.eatingTicks > 0) {
            --this.eatingTicks;
            if (this.eatingTicks <= 35 && this.eatingTicks >= 15 && this.eatingTicks % 5 == 0) {
                EatFleshGoal.playEffects(this, this.method_6047(), this.method_33571().method_1019(this.method_5720().method_1021(2.0).method_1021((double)this.method_55693())));
            }
            if (this.eatingTicks == 15) {
                EatFleshGoal.heal(world, this, this.method_6047(), !this.method_16914());
            }
            if (this.eatingTicks == 14) {
                this.method_6047().method_7934(1);
            }
            if (this.eatingTicks == 0) {
                this.setEating(false);
            }
        }
    }

    public void method_6007() {
        super.method_6007();
        class_1937 class_19372 = this.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            if ((this.field_5976 || this.field_5992 && !this.field_36331) && world.method_64395().method_8355(class_1928.field_19388)) {
                class_238 box = this.method_5829().method_1014(0.2);
                for (class_2338 pos : class_2338.method_10094((int)class_3532.method_15357((double)box.field_1323), (int)class_3532.method_15357((double)box.field_1322), (int)class_3532.method_15357((double)box.field_1321), (int)class_3532.method_15357((double)box.field_1320), (int)class_3532.method_15357((double)box.field_1325), (int)class_3532.method_15357((double)box.field_1324))) {
                    class_2680 state = world.method_8320(pos);
                    float hardness = state.method_26214((class_1922)world, pos);
                    if (!(hardness >= 0.0f) || !(hardness < 0.5f) && !state.method_26164(ModBlockTags.PIGLUTTON_BREAKABLE)) continue;
                    world.method_22352(pos, true);
                }
            }
        }
    }

    protected class_3414 method_5994() {
        return ModSoundEvents.ENTITY_PIGLUTTON_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSoundEvents.ENTITY_PIGLUTTON_HURT;
    }

    protected class_3414 method_6002() {
        return ModSoundEvents.ENTITY_PIGLUTTON_DEATH;
    }

    protected class_238 method_53511() {
        return super.method_53511().method_1009(0.25, 0.0, 0.25);
    }

    protected float method_6036(class_1282 source, float amount) {
        float damage = super.method_6036(source, amount);
        this.damageTaken += damage;
        this.fleeingTicks = 0;
        if (this.damageTaken >= 20.0f) {
            this.damageTaken = 0.0f;
            this.fleeingTicks = 160;
        }
        return damage;
    }

    public boolean method_17326() {
        return true;
    }

    public float method_67125() {
        return 5.0f;
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (data == EATING) {
            this.eatingTicks = (Boolean)this.field_6011.method_12789(EATING) != false ? 65 : 0;
        }
        if (data == ATTACK_INDEX) {
            this.attackTicks = 10;
        }
    }

    public void method_36457(float pitch) {
        if (this.eatingTicks == 0) {
            super.method_36457(pitch);
        }
    }

    public void method_36456(float yaw) {
        if (this.eatingTicks == 0) {
            super.method_36456(yaw);
        }
    }

    public void method_5636(float bodyYaw) {
        if (this.eatingTicks == 0) {
            super.method_5636(bodyYaw);
        }
    }

    public void method_5847(float headYaw) {
        if (this.eatingTicks == 0) {
            super.method_5847(headYaw);
        }
    }

    public int getAttackIndex() {
        return (Integer)this.field_6011.method_12789(ATTACK_INDEX);
    }

    private void setAttackIndex(int index) {
        this.field_6011.method_12778(ATTACK_INDEX, (Object)index);
    }

    public boolean isEating() {
        return (Boolean)this.field_6011.method_12789(EATING);
    }

    public void setEating(boolean eating) {
        this.field_6011.method_12778(EATING, (Object)eating);
    }

    public void attack() {
        int index = this.getAttackIndex();
        if (++index > 2) {
            index = 0;
        }
        this.setAttackIndex(index);
    }

    public boolean isFleeing() {
        return this.fleeingTicks > 0;
    }

    public boolean isBusy() {
        return this.isFleeing() || this.eatingTicks > 0;
    }

    public static void attemptSpawn(class_1309 living, int cannibalLevel, boolean ownFlesh) {
        PigluttonEntity piglutton;
        if (living.method_73183().method_8608()) {
            return;
        }
        float chance = (float)(Math.min(90, cannibalLevel) - 40) / 800.0f;
        if (ownFlesh) {
            chance *= 3.0f;
        }
        if (living.method_59922().method_43057() < chance && (piglutton = (PigluttonEntity)ModEntityTypes.PIGLUTTON.method_5883(living.method_73183(), class_3730.field_16461)) != null) {
            int minH = 16;
            int maxH = 32;
            for (int i = 0; i < 8; ++i) {
                int dX = living.method_59922().method_39332(16, 32) * (living.method_59922().method_43056() ? 1 : -1);
                int dY = living.method_59922().method_39332(-6, 6);
                int dZ = living.method_59922().method_39332(16, 32) * (living.method_59922().method_43056() ? 1 : -1);
                if (!piglutton.method_6082(living.method_23317() + (double)dX, living.method_23318() + (double)dY, living.method_23321() + (double)dZ, false)) continue;
                living.method_73183().method_8649((class_1297)piglutton);
                piglutton.method_5980(living);
                living.method_73183().method_43129(null, (class_1297)piglutton, ModSoundEvents.ENTITY_PIGLUTTON_SPAWN, class_3419.field_15251, 3.0f, 1.0f);
                return;
            }
        }
    }
}

