/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.jamiedev.bygone.Bygone;
import com.jamiedev.bygone.JamiesModPortalsNeoForge;
import com.jamiedev.bygone.PacketHandlerNeoForge;
import com.jamiedev.bygone.client.BygoneClientNeoForge;
import com.jamiedev.bygone.common.block.entity.GumboPotBlockEntity;
import com.jamiedev.bygone.common.util.ServerTickHandler;
import com.jamiedev.bygone.common.util.VexDeathTracker;
import com.jamiedev.bygone.core.datagen.BygoneDataGenerator;
import com.jamiedev.bygone.core.registry.AttachmentTypesNeoForge;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGDataComponents;
import com.jamiedev.bygone.core.registry.BGDataComponentsNeoForge;
import com.jamiedev.bygone.core.registry.BGItems;
import com.jamiedev.bygone.core.registry.BGMobEffectsNeoForge;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="bygone")
public class BygoneNeoForge {
    IPayloadContext ctx;

    public BygoneNeoForge(IEventBus eventBus, Dist dist) {
        BGMobEffectsNeoForge.init(eventBus);
        BGDataComponentsNeoForge.DATA_COMPONENTS.register(eventBus);
        Bygone.init();
        eventBus.addListener(PacketHandlerNeoForge::register);
        if (dist.isClient()) {
            BygoneClientNeoForge.init(eventBus);
        }
        eventBus.addListener(this::registerEvent);
        eventBus.addListener(BygoneDataGenerator::onInitializeDataGenerator);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::spawnPlacements);
        eventBus.addListener(this::createAttributes);
        eventBus.addListener(this::addValidBlocks);
        eventBus.addListener(this::modifyDefaultComponents);
        NeoForge.EVENT_BUS.addListener(this::entityTick);
        NeoForge.EVENT_BUS.addListener(this::damageEvent);
        NeoForge.EVENT_BUS.addListener(this::onLivingDeath);
        NeoForge.EVENT_BUS.addListener(this::onServerTick);
    }

    public void modifyDefaultComponents(ModifyDefaultComponentsEvent event) {
        event.modify((ItemLike)Items.MOSS_BLOCK, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(2).saturationModifier(0.05f).build())));
        event.modify((ItemLike)Items.MOSS_CARPET, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(1).saturationModifier(0.05f).build())));
        event.modify((ItemLike)BGBlocks.ALPHA_MOSS_BLOCK.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(2).saturationModifier(0.05f).build())));
        event.modify((ItemLike)BGBlocks.ALPHA_MOSS_CARPET.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(1).saturationModifier(0.05f).build())));
        event.modify((ItemLike)Items.STICK, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(1).saturationModifier(0.02f).build())));
        event.modify((ItemLike)Items.BAMBOO, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).build())));
        event.modify((ItemLike)Items.BONE, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(4).saturationModifier(0.6f).build())));
        event.modify((ItemLike)Items.SLIME_BALL, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(2).saturationModifier(0.2f).effect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0), 0.3f).build())));
        event.modify((ItemLike)Items.LEATHER, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(2).saturationModifier(0.2f).build())));
        event.modify((ItemLike)Items.LEATHER_BOOTS, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(6).saturationModifier(0.2f).build())));
        event.modify((ItemLike)Items.LEATHER_CHESTPLATE, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(8).saturationModifier(0.2f).build())));
        event.modify((ItemLike)Items.LEATHER_HELMET, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(6).saturationModifier(0.2f).build())));
        event.modify((ItemLike)Items.LEATHER_LEGGINGS, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(6).saturationModifier(0.2f).build())));
        event.modify((ItemLike)BGBlocks.BLEMISH.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(2).saturationModifier(0.05f).build())));
        event.modify((ItemLike)BGBlocks.BLEMISH_VEIN.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(2).saturationModifier(0.05f).build())));
        event.modify((ItemLike)BGBlocks.ORANGE_MUSHROOM_BLOCK.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200, 0), 0.05f).build())));
        event.modify((ItemLike)BGBlocks.PINK_MUSHROOM_BLOCK.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.REGENERATION, 100, 0), 0.05f).build())));
        event.modify((ItemLike)BGBlocks.PURPLE_MUSHROOM_BLOCK.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 0), 0.05f).build())));
        event.modify((ItemLike)BGItems.ORANGE_FUNGI.get(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0), 0.05f).effect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 400, 0), 0.025f).build())));
        event.modify((ItemLike)BGItems.PINK_FUNGI.get(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.REGENERATION, 200, 0), 0.05f).effect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 400, 0), 0.025f).build())));
        event.modify((ItemLike)BGItems.PURPLE_FUNGI.get(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.WEAKNESS, 400, 0), 0.05f).effect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 400, 0), 0.025f).build())));
        event.modify((ItemLike)Items.CRIMSON_FUNGUS, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 400, 0), 0.05f).effect(new MobEffectInstance(MobEffects.WEAKNESS, 400, 0), 0.025f).build())));
        event.modify((ItemLike)Items.CRIMSON_ROOTS, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 400, 0), 0.05f).effect(new MobEffectInstance(MobEffects.WEAKNESS, 400, 0), 0.025f).build())));
        event.modify((ItemLike)Items.NETHER_SPROUTS, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0), 0.05f).build())));
        event.modify((ItemLike)Items.WARPED_FUNGUS, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.INVISIBILITY, 400, 0), 0.05f).effect(new MobEffectInstance(MobEffects.POISON, 400, 0), 0.025f).build())));
        event.modify((ItemLike)Items.WARPED_ROOTS, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 400, 0), 0.05f).effect(new MobEffectInstance(MobEffects.WEAKNESS, 400, 0), 0.025f).build())));
        event.modify((ItemLike)Items.BROWN_MUSHROOM, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.DIG_SPEED, 100, 0), 0.05f).build())));
        event.modify((ItemLike)Items.RED_MUSHROOM, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).effect(new MobEffectInstance(MobEffects.JUMP, 100, 1), 0.05f).build())));
        event.modify((ItemLike)Items.BROWN_MUSHROOM_BLOCK, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).build())));
        event.modify((ItemLike)Items.RED_MUSHROOM_BLOCK, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).build())));
        event.modify((ItemLike)Items.BROWN_MUSHROOM_BLOCK, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).build())));
        event.modify((ItemLike)Items.RED_MUSHROOM_BLOCK, builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).build())));
        event.modify((ItemLike)BGBlocks.SHELF_FUNGUS.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).build())));
        event.modify((ItemLike)BGBlocks.SHELF_MOLD.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(3).saturationModifier(0.1f).build())));
        event.modify((ItemLike)BGBlocks.SHELF_MOLD_MOSS.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(2).saturationModifier(0.1f).build())));
        event.modify((ItemLike)BGBlocks.SHELF_ROOTS.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(1).saturationModifier(0.05f).build())));
        event.modify((ItemLike)BGBlocks.SHELF_SPROUTS.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(1).saturationModifier(0.05f).build())));
        event.modify((ItemLike)BGBlocks.ORANGE_FUNGI_VINES.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(1).saturationModifier(0.05f).build())));
        event.modify((ItemLike)BGBlocks.PINK_FUNGI_VINES.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(1).saturationModifier(0.05f).build())));
        event.modify((ItemLike)BGBlocks.PURPLE_FUNGI_VINES.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(1).saturationModifier(0.05f).build())));
        event.modify((ItemLike)BGBlocks.BELLADONNA.get().asItem(), builder -> builder.set((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value(), (Object)new GumboPotBlockEntity.GumboIngredientComponent(new FoodProperties.Builder().nutrition(1).saturationModifier(0.02f).effect(new MobEffectInstance(MobEffects.WITHER, 400, 2), 1.0f).build())));
    }

    void entityTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof Cow) {
            Cow cow = (Cow)entity;
            if (!entity.level().isClientSide) {
                // empty if block
            }
        }
    }

    void damageEvent(LivingDamageEvent.Pre event) {
    }

    void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Vex) {
            Vex vex = (Vex)livingEntity;
            livingEntity = event.getEntity().level();
            if (livingEntity instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)livingEntity;
                VexDeathTracker.onVexDeath(vex, serverLevel);
            }
        }
    }

    void onServerTick(ServerTickEvent.Post event) {
        ServerTickHandler.onServerTick(event.getServer());
    }

    void createAttributes(EntityAttributeCreationEvent event) {
        Bygone.initAttributes((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1));
    }

    void spawnPlacements(RegisterSpawnPlacementsEvent event) {
        Bygone.registerSpawnPlacements((entityType, spawnPlacementType, types, spawnPredicate) -> event.register(entityType, spawnPlacementType, types, spawnPredicate, RegisterSpawnPlacementsEvent.Operation.REPLACE));
    }

    void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            HashSet validBlocks = Sets.newHashSet((Iterable)BlockEntityType.BRUSHABLE_BLOCK.validBlocks);
            validBlocks.addAll(Sets.newHashSet((Object[])new Block[]{BGBlocks.SUSPICIOUS_CLAYSTONE.get()}));
            BlockEntityType.BRUSHABLE_BLOCK.validBlocks = ImmutableSet.copyOf((Collection)validBlocks);
            BGDataComponentsNeoForge.init();
            Bygone.registerStrippables();
            Bygone.addFlammable();
            JamiesModPortalsNeoForge.init();
            GumboPotBlockEntity.GumboScooping.setFilled(Items.BOWL, BGItems.GUMBO_BOWL.get());
            GumboPotBlockEntity.GumboScooping.setFilled(Items.GLASS_BOTTLE, BGItems.GUMBO_BOTTLE.get());
        });
    }

    void addValidBlocks(BlockEntityTypeAddBlocksEvent event) {
        Bygone.addValidBlocks((x$0, xva$1) -> event.modify(x$0, new Block[]{xva$1}));
    }

    void registerEvent(RegisterEvent event) {
        Registry registry = event.getRegistry();
        if (registry == BuiltInRegistries.BLOCK) {
            AttachmentTypesNeoForge.init();
            Bygone.registerBuiltIn();
        }
    }
}

