/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.models;

import com.jamiedev.bygone.client.models.animations.LithyAnimations;
import com.jamiedev.bygone.common.entity.LithyEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class LithyModel<T extends Entity>
extends HierarchicalModel<T> {
    ZombieModel ref;
    private final ModelPart root;
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final ModelPart body;
    private final ModelPart neck;

    public LithyModel(ModelPart root) {
        this.root = root.getChild("root");
        this.right_leg = this.root.getChild("right_leg");
        this.left_leg = this.root.getChild("left_leg");
        this.body = this.root.getChild("body");
        this.neck = this.body.getChild("neck");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(30, 0).mirror().addBox(-2.0f, -1.0f, -2.0f, 4.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.0f, (float)-10.0f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(30, 0).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-10.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 23).addBox(-4.0f, -7.0f, -3.0f, 8.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -16.0f, -4.0f, 8.0f, 16.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (entity instanceof LithyEntity) {
            LithyEntity lithy = (LithyEntity)entity;
            this.animate(lithy.walkAnimationState, LithyAnimations.walk, ageInTicks, 1.0f);
            this.animate(lithy.tripBeginAnimationState, LithyAnimations.trip_begin, ageInTicks, 1.0f);
            this.animate(lithy.tripAnimationState, LithyAnimations.trip, ageInTicks, 1.0f);
            this.animate(lithy.tripEndAnimationState, LithyAnimations.trip_end, ageInTicks, 1.0f);
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.root;
    }
}

