/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.models;

import com.google.common.collect.ImmutableList;
import com.jamiedev.bygone.client.models.animations.NectaurAnimations;
import com.jamiedev.bygone.common.entity.NectaurEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class NectaurModel<T extends NectaurEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart frill3;
    private final ModelPart frill2;
    private final ModelPart frill4;
    private final ModelPart leg1;
    private final ModelPart leg2;
    private final ModelPart tail;
    private static final Vector3f ANIMATION_VECTOR_CACHE = new Vector3f();

    public NectaurModel(ModelPart root) {
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.head = this.body.getChild("head");
        this.frill3 = this.head.getChild("frill3");
        this.frill2 = this.head.getChild("frill2");
        this.frill4 = this.head.getChild("frill4");
        this.tail = this.body.getChild("tail");
        this.leg1 = this.body.getChild("leg1");
        this.leg2 = this.body.getChild("leg2");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)56.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 13).addBox(-4.0f, -4.0f, -5.0f, 7.0f, 8.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)-13.0f, (float)1.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 13).addBox(-1.5f, -9.0f, -2.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(24, 30).addBox(-1.5f, -17.0f, 2.0f, 3.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 30).addBox(-0.5f, -17.0f, -9.0f, 1.0f, 1.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)0.0f, (float)-6.0f));
        PartDefinition frill3 = head.addOrReplaceChild("frill3", CubeListBuilder.create().texOffs(40, 44).addBox(-2.0f, 0.0f, 0.0f, 3.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)-17.0f, (float)7.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition frill2 = head.addOrReplaceChild("frill2", CubeListBuilder.create(), PartPose.offset((float)-1.5f, (float)-12.0f, (float)7.0f));
        PartDefinition frill_r1 = frill2.addOrReplaceChild("frill_r1", CubeListBuilder.create().texOffs(54, 28).mirror().addBox(-1.0f, -13.0f, 0.0f, 0.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)-0.1309f, (float)0.0f));
        PartDefinition frill4 = head.addOrReplaceChild("frill4", CubeListBuilder.create(), PartPose.offset((float)1.5f, (float)-12.0f, (float)7.0f));
        PartDefinition frill_r2 = frill4.addOrReplaceChild("frill_r2", CubeListBuilder.create().texOffs(54, 28).addBox(1.0f, -13.0f, 0.0f, 0.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)8.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(22, 34).addBox(-0.5f, -9.0f, 0.0f, 1.0f, 10.0f, 20.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-4.0f, (float)4.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition leg1 = body.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 42).addBox(-1.0f, 6.0f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(38, 0).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)0.0f, (float)0.0f));
        PartDefinition leg2 = body.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(0, 42).mirror().addBox(-2.0f, 6.0f, -2.0f, 3.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(38, 0).mirror().addBox(-2.0f, -2.0f, -2.0f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.5f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(NectaurEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.animate(entity.idleAnimationState, NectaurAnimations.NECTAUR_IDLE, ageInTicks, 1.0f);
        this.frill2.xRot = this.head.xRot;
        this.frill2.yRot = this.head.yRot;
        this.frill3.xRot = this.head.xRot;
        this.frill3.yRot = this.head.yRot;
        this.frill4.xRot = this.head.xRot;
        this.frill4.yRot = this.head.yRot;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leg1.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        Entity player = Minecraft.getInstance().getCameraEntity();
        if (player != null) {
            Vec3 vec3 = player.getEyePosition(0.0f);
            Vec3 vec31 = entity.getEyePosition(0.0f);
            double d0 = vec3.y - vec31.y;
            this.head.y = d0 > 0.0 ? 0.0f : 1.0f;
            Vec3 vec32 = entity.getViewVector(0.0f);
            vec32 = new Vec3(vec32.x, 0.0, vec32.z);
            Vec3 vec33 = new Vec3(vec31.x - vec3.x, 0.0, vec31.z - vec3.z).normalize().yRot(1.5707964f);
            double d1 = vec32.dot(vec33);
            this.head.x = Mth.sqrt((float)((float)Math.abs(d1))) * 2.0f * (float)Math.signum(d1);
        }
    }

    protected Iterable<ModelPart> getHeadParts() {
        return ImmutableList.of((Object)this.head, (Object)this.frill3, (Object)this.frill2, (Object)this.frill4);
    }

    protected Iterable<ModelPart> getBodyParts() {
        return ImmutableList.of((Object)this.tail, (Object)this.leg1, (Object)this.leg2);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.root;
    }
}

