/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class PestModel<T extends Entity>
extends EntityModel<T> {
    private final ModelPart head;
    private final ModelPart tube;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart leftMiddleHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart rightMiddleHindLeg;
    private final ModelPart rightHindLeg;

    public PestModel(ModelPart root) {
        this.head = root.getChild("head");
        this.tube = this.head.getChild("tube");
        this.body = root.getChild("body");
        this.leftFrontLeg = root.getChild("leftFrontLeg");
        this.leftMiddleHindLeg = root.getChild("leftMiddleHindLeg");
        this.leftHindLeg = root.getChild("leftHindLeg");
        this.rightFrontLeg = root.getChild("rightFrontLeg");
        this.rightMiddleHindLeg = root.getChild("rightMiddleHindLeg");
        this.rightHindLeg = root.getChild("rightHindLeg");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 17).addBox(-3.0f, -3.0f, -6.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)-5.0f));
        PartDefinition tube = head.addOrReplaceChild("tube", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.0f, (float)-6.0f));
        PartDefinition tube_r1 = tube.addOrReplaceChild("tube_r1", CubeListBuilder.create().texOffs(24, 17).addBox(-1.0f, -1.2929f, -8.7782f, 2.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)1.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -5.0f, 8.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition leftFrontLeg = partdefinition.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)20.0f, (float)-3.0f));
        PartDefinition leftFrontLeg_r1 = leftFrontLeg.addOrReplaceChild("leftFrontLeg_r1", CubeListBuilder.create().texOffs(0, 28).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition leftMiddleHindLeg = partdefinition.addOrReplaceChild("leftMiddleHindLeg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)20.0f, (float)0.0f));
        PartDefinition leftMiddleHindLeg_r1 = leftMiddleHindLeg.addOrReplaceChild("leftMiddleHindLeg_r1", CubeListBuilder.create().texOffs(8, 28).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition leftHindLeg = partdefinition.addOrReplaceChild("leftHindLeg", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)20.0f, (float)3.0f));
        PartDefinition leftHindLeg_r1 = leftHindLeg.addOrReplaceChild("leftHindLeg_r1", CubeListBuilder.create().texOffs(16, 28).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f));
        PartDefinition rightFrontLeg = partdefinition.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)20.0f, (float)-3.0f));
        PartDefinition rightFrontLeg_r1 = rightFrontLeg.addOrReplaceChild("rightFrontLeg_r1", CubeListBuilder.create().texOffs(0, 36).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition rightMiddleHindLeg = partdefinition.addOrReplaceChild("rightMiddleHindLeg", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)20.0f, (float)0.0f));
        PartDefinition rightMiddleHindLeg_r1 = rightMiddleHindLeg.addOrReplaceChild("rightMiddleHindLeg_r1", CubeListBuilder.create().texOffs(32, 28).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        PartDefinition rightHindLeg = partdefinition.addOrReplaceChild("rightHindLeg", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)20.0f, (float)3.0f));
        PartDefinition rightHindLeg_r1 = rightHindLeg.addOrReplaceChild("rightHindLeg_r1", CubeListBuilder.create().texOffs(24, 28).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftFrontLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftMiddleHindLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftHindLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightFrontLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightMiddleHindLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightHindLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.tube.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.tube.xRot = headPitch * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        float f = 0.7853982f;
        this.rightHindLeg.zRot = -0.7853982f;
        this.leftHindLeg.zRot = 0.7853982f;
        this.rightMiddleHindLeg.zRot = -0.58119464f;
        this.leftMiddleHindLeg.zRot = 0.58119464f;
        this.rightFrontLeg.zRot = -0.7853982f;
        this.leftFrontLeg.zRot = 0.7853982f;
        float f1 = -0.0f;
        float f2 = 0.3926991f;
        this.rightHindLeg.yRot = 0.7853982f;
        this.leftHindLeg.yRot = -0.7853982f;
        this.rightMiddleHindLeg.yRot = 0.3926991f;
        this.leftMiddleHindLeg.yRot = -0.3926991f;
        this.rightFrontLeg.yRot = -0.7853982f;
        this.leftFrontLeg.yRot = 0.7853982f;
        float f3 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 0.0f)) * 0.4f) * limbSwingAmount;
        float f4 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float f5 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * limbSwingAmount;
        float f6 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * limbSwingAmount;
        float f7 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 0.0f)) * 0.4f) * limbSwingAmount;
        float f8 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float f9 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.4f) * limbSwingAmount;
        float f10 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 4.712389f)) * 0.4f) * limbSwingAmount;
        ModelPart var10000 = this.rightHindLeg;
        var10000.yRot += f3;
        var10000 = this.leftHindLeg;
        var10000.yRot += -f3;
        var10000 = this.rightMiddleHindLeg;
        var10000.yRot += f4;
        var10000 = this.leftMiddleHindLeg;
        var10000.yRot += -f4;
        var10000 = this.rightFrontLeg;
        var10000.yRot += f6;
        var10000 = this.leftFrontLeg;
        var10000.yRot += -f6;
        var10000 = this.rightHindLeg;
        var10000.zRot += f7;
        var10000 = this.leftHindLeg;
        var10000.zRot += -f7;
        var10000 = this.rightMiddleHindLeg;
        var10000.zRot += f8;
        var10000 = this.leftMiddleHindLeg;
        var10000.zRot += -f8;
        var10000 = this.rightFrontLeg;
        var10000.zRot += f10;
        var10000 = this.leftFrontLeg;
        var10000.zRot += -f10;
    }
}

