/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.models;

import com.jamiedev.bygone.common.entity.ScuttleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.GuardianModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class ScuttleModel
extends HierarchicalModel<ScuttleEntity> {
    GuardianModel ref;
    private final ModelPart eye;
    private final ModelPart body;
    private final ModelPart tail3;
    private final ModelPart knub1;
    private final ModelPart knub2;
    private final ModelPart knub3;
    private final ModelPart knub4;
    private final ModelPart spine1;
    private final ModelPart spine2;
    private final ModelPart spine3;
    private final ModelPart spine4;
    private final ModelPart root;
    final ModelPart[] tail;
    private static final String EYE = "eye";

    public ScuttleModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.tail3 = this.body.getChild("tail3");
        this.knub4 = this.body.getChild("knub4");
        this.knub3 = this.body.getChild("knub3");
        this.knub2 = this.body.getChild("knub2");
        this.knub1 = this.body.getChild("knub1");
        this.eye = this.body.getChild(EYE);
        this.tail = new ModelPart[2];
        this.spine1 = this.body.getChild("spine1");
        this.spine2 = this.body.getChild("spine2");
        this.spine3 = this.body.getChild("spine3");
        this.spine4 = this.body.getChild("spine4");
    }

    public ModelPart root() {
        return this.root;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition body = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -6.0f, -8.0f, 12.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        body.addOrReplaceChild(EYE, CubeListBuilder.create().texOffs(32, 21).addBox(-1.0f, 15.5f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-19.5f, (float)-8.25f));
        PartDefinition tail3 = body.addOrReplaceChild("tail3", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition tail3_r1 = tail3.addOrReplaceChild("tail3_r1", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, -2.5f, 7.0f, 1.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(24, 24).addBox(-1.0f, 0.0f, 4.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f, (float)0.0f));
        PartDefinition knub4 = body.addOrReplaceChild("knub4", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)4.0f, (float)7.0f));
        PartDefinition knub4_r1 = knub4.addOrReplaceChild("knub4_r1", CubeListBuilder.create().texOffs(32, 16).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-4.0f, (float)-5.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition knub3 = body.addOrReplaceChild("knub3", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)7.0f));
        PartDefinition knub3_r1 = knub3.addOrReplaceChild("knub3_r1", CubeListBuilder.create().texOffs(16, 32).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-4.0f, (float)-5.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition knub2 = body.addOrReplaceChild("knub2", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)4.0f, (float)0.0f));
        PartDefinition knub2_r1 = knub2.addOrReplaceChild("knub2_r1", CubeListBuilder.create().texOffs(8, 30).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-4.0f, (float)-5.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition knub1 = body.addOrReplaceChild("knub1", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition knub1_r1 = knub1.addOrReplaceChild("knub1_r1", CubeListBuilder.create().texOffs(0, 30).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-4.0f, (float)-5.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition spine1 = body.addOrReplaceChild("spine1", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition spine1_r1 = spine1.addOrReplaceChild("spine1_r1", CubeListBuilder.create().texOffs(24, 16).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-10.0f, (float)-4.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition spine2 = body.addOrReplaceChild("spine2", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)4.0f, (float)1.0f));
        PartDefinition spine1_r2 = spine2.addOrReplaceChild("spine1_r2", CubeListBuilder.create().texOffs(24, 29).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-10.0f, (float)-6.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition spine3 = body.addOrReplaceChild("spine3", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)4.0f, (float)7.0f));
        PartDefinition spine1_r3 = spine3.addOrReplaceChild("spine1_r3", CubeListBuilder.create().texOffs(16, 16).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-10.0f, (float)-6.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition spine4 = body.addOrReplaceChild("spine4", CubeListBuilder.create(), PartPose.offset((float)7.0f, (float)4.0f, (float)6.0f));
        PartDefinition spine1_r4 = spine4.addOrReplaceChild("spine1_r4", CubeListBuilder.create().texOffs(16, 25).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-10.0f, (float)-6.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void setupAnim(ScuttleEntity guardianEntity, float f, float g, float h, float i, float j) {
        float k = h - (float)guardianEntity.tickCount;
        this.body.yRot = i * ((float)Math.PI / 180);
        this.body.xRot = j * ((float)Math.PI / 180);
        Entity entity = Minecraft.getInstance().getCameraEntity();
        if (guardianEntity.hasProjTarget()) {
            entity = guardianEntity.getProjTarget();
        }
        if (entity != null) {
            Vec3 vec3d = entity.getEyePosition(0.0f);
            Vec3 vec3d2 = guardianEntity.getEyePosition(0.0f);
            double d = vec3d.y - vec3d2.y;
            this.eye.y = d > 0.0 ? -19.5f : -20.5f;
            Vec3 vec3d3 = guardianEntity.getViewVector(0.0f);
            vec3d3 = new Vec3(vec3d3.x, 0.0, vec3d3.z);
            Vec3 vec3d4 = new Vec3(vec3d2.x - vec3d.x, 0.0, vec3d2.z - vec3d.z).normalize().yRot(1.5707964f);
            double e = vec3d3.dot(vec3d4);
            this.eye.x = Mth.sqrt((float)((float)Math.abs(e))) * 2.0f * (float)Math.signum(e);
        }
        this.eye.visible = true;
        float m = guardianEntity.getTailAngle(k);
        this.tail3.yRot = Mth.sin((float)m) * (float)Math.PI * 0.15f;
    }

    private static float getAngle(int index, float animationProgress, float magnitude) {
        return 1.0f + Mth.cos((float)(animationProgress * 1.5f + (float)index)) * 0.01f - magnitude;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        this.body.render(matrices, vertexConsumer, light, overlay, color);
    }
}

