/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.models;

import com.jamiedev.bygone.client.models.animations.WraithAnimations;
import com.jamiedev.bygone.common.entity.WraithEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class WraithModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart left_arm;
    private final ModelPart left_arm2;
    private final ModelPart right_arm;
    private final ModelPart right_arm2;

    public WraithModel(ModelPart root) {
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.head = this.body.getChild("head");
        this.left_arm = this.body.getChild("left_arm");
        this.left_arm2 = this.left_arm.getChild("left_arm2");
        this.right_arm = this.body.getChild("right_arm");
        this.right_arm2 = this.right_arm.getChild("right_arm2");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)15.0f, (float)0.5f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(34, 0).addBox(-4.0f, -7.0f, -2.5f, 8.0f, 9.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 21).addBox(-4.0f, -7.0f, -2.5f, 8.0f, 16.0f, 7.0f, new CubeDeformation(0.125f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-0.5f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -7.0f, -4.5f, 8.0f, 12.0f, 9.0f, new CubeDeformation(0.25f)).texOffs(30, 21).addBox(-3.0f, -7.0f, -4.5f, 6.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition left_arm = body.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)6.0f, (float)-3.0f, (float)1.0f));
        PartDefinition left_arm2 = left_arm.addOrReplaceChild("left_arm2", CubeListBuilder.create().texOffs(30, 37).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 44).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 11.0f, 1.0f, new CubeDeformation(0.125f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = body.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-6.0f, (float)-3.0f, (float)1.0f));
        PartDefinition right_arm2 = right_arm.addOrReplaceChild("right_arm2", CubeListBuilder.create().texOffs(30, 37).mirror().addBox(-2.0f, -2.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 44).mirror().addBox(-0.5f, -1.0f, -0.5f, 1.0f, 11.0f, 1.0f, new CubeDeformation(0.125f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition camera = partdefinition.addOrReplaceChild("camera", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (entity instanceof WraithEntity) {
            WraithEntity wraith = (WraithEntity)entity;
            this.animate(wraith.idleAnimationState, WraithAnimations.idle, ageInTicks, 1.0f);
            this.animate(wraith.floatAnimationState, WraithAnimations.floating, ageInTicks, 1.0f);
            this.animate(wraith.meleeAnimationState, WraithAnimations.attack, ageInTicks, 1.0f);
            this.animate(wraith.spellAnimationState, WraithAnimations.cast, ageInTicks, 1.0f);
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.root;
    }
}

