/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;

public class WormParticle
extends TextureSheetParticle {
    WormParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.setSize(0.02f, 0.02f);
        this.pickSprite(spriteProvider);
        this.quadSize = 0.1f + this.random.nextFloat() * 0.05f;
        this.lifetime = 40 + this.random.nextInt(20);
        this.gravity = -0.04f;
        this.xd = velocityX;
        this.yd = velocityY;
        this.zd = velocityZ;
    }

    public void tick() {
        boolean isAtSurface;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
            return;
        }
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        BlockPos below = pos.below();
        boolean isInWater = this.level.getFluidState(pos).is(FluidTags.WATER);
        boolean isWaterBelow = this.level.getFluidState(below).is(FluidTags.WATER);
        boolean bl = isAtSurface = isWaterBelow && !isInWater;
        if (!isInWater && !isWaterBelow) {
            this.remove();
            return;
        }
        if (isInWater && !isAtSurface) {
            this.yd = 0.04f;
        } else if (isAtSurface) {
            this.yd = this.yd < 0.0 ? -this.yd * (double)0.6f : (this.yd *= (double)0.8f);
        }
        this.yd -= (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.zd *= (double)0.98f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteProvider;

        public Factory(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new WormParticle(world, x, y, z, velocityX, velocityY, velocityZ, this.spriteProvider);
        }
    }
}

