/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.renderer.entity;

import com.jamiedev.bygone.Bygone;
import com.jamiedev.bygone.client.JamiesModModelLayers;
import com.jamiedev.bygone.client.models.ScuttleModel;
import com.jamiedev.bygone.common.entity.ScuttleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.GuardianRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ScuttleRenderer
extends MobRenderer<ScuttleEntity, ScuttleModel> {
    GuardianRenderer ref;
    private static final RenderType LAYER;
    private static final ResourceLocation TEXTURE;

    public ScuttleRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ScuttleModel(context.bakeLayer(JamiesModModelLayers.SCUTTLE)), 0.5f);
    }

    protected void scale(ScuttleEntity slimeEntity, PoseStack matrixStack, float f) {
    }

    public ResourceLocation getTextureLocation(ScuttleEntity slimeEntity) {
        return TEXTURE;
    }

    private Vec3 fromLerpedPosition(LivingEntity entity, double yOffset, float delta) {
        double d = Mth.lerp((double)delta, (double)entity.xOld, (double)entity.getX());
        double e = Mth.lerp((double)delta, (double)entity.yOld, (double)entity.getY()) + yOffset;
        double f = Mth.lerp((double)delta, (double)entity.zOld, (double)entity.getZ());
        return new Vec3(d, e, f);
    }

    private static void vertex(VertexConsumer vertexConsumer, PoseStack.Pose matrix, float x, float y, float z, int red, int green, int blue, float u, float v) {
        vertexConsumer.addVertex(matrix, x, y, z).setColor(red, green, blue, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
    }

    public void render(ScuttleEntity guardianEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        super.render((LivingEntity)guardianEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    public boolean shouldRender(ScuttleEntity guardianEntity, Frustum frustum, double d, double e, double f) {
        LivingEntity livingEntity;
        if (super.shouldRender((Entity)guardianEntity, frustum, d, e, f)) {
            return true;
        }
        if (guardianEntity.hasProjTarget() && (livingEntity = guardianEntity.getProjTarget()) != null) {
            Vec3 vec3d = this.fromLerpedPosition(livingEntity, (double)livingEntity.getBbHeight() * 0.5, 1.0f);
            Vec3 vec3d2 = this.fromLerpedPosition((LivingEntity)guardianEntity, guardianEntity.getEyeHeight(), 1.0f);
            return frustum.isVisible(new AABB(vec3d2.x, vec3d2.y, vec3d2.z, vec3d.x, vec3d.y, vec3d.z));
        }
        return false;
    }

    static {
        TEXTURE = Bygone.id("textures/entity/scuttle.png");
        LAYER = RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE);
    }
}

