/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.common.block.AncientCaveVines;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class AncientCaveVinesHeadBlock
extends GrowingPlantHeadBlock
implements BonemealableBlock,
AncientCaveVines {
    public static final MapCodec<AncientCaveVinesHeadBlock> CODEC = AncientCaveVinesHeadBlock.simpleCodec(AncientCaveVinesHeadBlock::new);
    private static final float GROW_CHANCE = 0.11f;

    public MapCodec<AncientCaveVinesHeadBlock> codec() {
        return CODEC;
    }

    public AncientCaveVinesHeadBlock(BlockBehaviour.Properties settings) {
        super(settings, Direction.DOWN, SHAPE, false, 0.1);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource random) {
        return 1;
    }

    protected boolean canGrowInto(BlockState state) {
        return state.isAir();
    }

    protected Block getBodyBlock() {
        return BGBlocks.CAVE_VINES_PLANT.get();
    }

    protected BlockState updateBodyAfterConvertedFromHead(BlockState from, BlockState to) {
        return (BlockState)to.setValue((Property)BERRIES, (Comparable)((Boolean)from.getValue((Property)BERRIES)));
    }

    protected BlockState getGrowIntoState(BlockState state, @NotNull RandomSource random) {
        return (BlockState)super.getGrowIntoState(state, random).setValue((Property)BERRIES, (Comparable)Boolean.valueOf(random.nextFloat() < 0.11f));
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)BGBlocks.CAVE_VINES_PLANT.get());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        return AncientCaveVines.pickBerries((Entity)player, state, world, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BERRIES});
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)BERRIES) == false;
    }

    public boolean isBonemealSuccess(Level world, @NotNull RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, @NotNull RandomSource random, BlockPos pos, BlockState state) {
        world.setBlock(pos, (BlockState)state.setValue((Property)BERRIES, (Comparable)Boolean.valueOf(true)), 2);
    }
}

