/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.common.block.entity.MegalithTotemEntity;
import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGItems;
import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MegalithTotemBlock
extends BaseEntityBlock {
    public static final MapCodec<MegalithTotemBlock> CODEC = MegalithTotemBlock.simpleCodec(MegalithTotemBlock::new);
    public static final VoxelShape SHAPE;
    public static final DirectionProperty FACING;

    public MegalithTotemBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new MegalithTotemEntity(blockPos, blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Deprecated
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Deprecated
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide && stack.is(BGItems.LITHOPLASM.get())) {
            MegalithTotemEntity totem;
            SimpleContainer inv;
            ItemStack slotStack;
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof MegalithTotemEntity && ((slotStack = (inv = (totem = (MegalithTotemEntity)be).getInventory()).getItem(0)).isEmpty() || slotStack.is(BGItems.LITHOPLASM.get()))) {
                if (slotStack.isEmpty()) {
                    inv.setItem(0, stack.copyWithCount(1));
                    stack.shrink(1);
                } else if (slotStack.getCount() < slotStack.getMaxStackSize()) {
                    slotStack.grow(1);
                    stack.shrink(1);
                }
                MegalithTotemEntity.tick(level, pos, state, totem);
            }
            return ItemInteractionResult.sidedSuccess((boolean)false);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return null;
        }
        if (blockEntityType == BGBlockEntities.MEGALITH_TOTEM.get()) {
            return (lvl, pos, st, be) -> {
                if (be instanceof MegalithTotemEntity) {
                    MegalithTotemEntity totem = (MegalithTotemEntity)be;
                    MegalithTotemEntity.tick(lvl, pos, st, totem);
                }
            };
        }
        return null;
    }

    static {
        FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
        SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)24.0, (double)12.0);
    }
}

