/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.core.registry.BGBlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SablenutBlock
extends Block
implements BonemealableBlock,
Fallable {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE;
    public static final DirectionProperty FACING;
    protected static final VoxelShape HANGING_SHAPE;
    protected static final VoxelShape[] SHAPE;
    public static final MapCodec<SablenutBlock> CODEC;

    public SablenutBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i;
        if (level.random.nextInt(5) == 0 && (i = ((Integer)state.getValue((Property)AGE)).intValue()) < 3) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int i = (Integer)state.getValue((Property)AGE);
        return SHAPE[i];
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    protected void falling(FallingBlockEntity entity) {
    }

    private static void spawnFallingSablenut(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        BlockState blockstate = state;
        FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)level, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
        fallingblockentity.dropItem = false;
        blockpos$mutableblockpos.move(Direction.DOWN);
        blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
    }

    protected void tick(BlockState state, ServerLevel world, BlockPos pos, @NotNull RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            SablenutBlock.spawnFallingSablenut(state, world, pos);
        }
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)), 2);
    }

    public boolean isFullyGrown(BlockState state) {
        int i = (Integer)state.getValue((Property)AGE);
        return i == 3 | i > 3;
    }

    protected void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockpos;
        if (!level.isClientSide && projectile.mayInteract(level, blockpos = hit.getBlockPos()) && projectile.mayBreak(level) && projectile instanceof Projectile && projectile.getDeltaMovement().length() > 0.6) {
            SablenutBlock.spawnFallingSablenut(state, (ServerLevel)level, blockpos);
        }
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.above()).is(BGBlocks.SABLE_WOOD.get()) || level.getBlockState(pos.above()).is(BGBlocks.SABLE_LEAVES.get());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AGE});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected MapCodec<SablenutBlock> codec() {
        return CODEC;
    }

    static {
        SHAPE = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)0.8, (double)0.0, (double)8.0, (double)15.2, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{Block.box((double)8.0, (double)0.0, (double)0.8, (double)8.0, (double)16.0, (double)15.2), Block.box((double)6.5, (double)9.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5)}), Shapes.or((VoxelShape)Block.box((double)0.8, (double)0.0, (double)8.0, (double)15.2, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{Block.box((double)8.0, (double)0.0, (double)0.8, (double)8.0, (double)16.0, (double)15.2), Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0)}), Shapes.or((VoxelShape)Block.box((double)0.8, (double)0.0, (double)8.0, (double)15.2, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{Block.box((double)8.0, (double)0.0, (double)0.8, (double)8.0, (double)16.0, (double)15.2), Block.box((double)5.5, (double)7.0, (double)5.5, (double)10.5, (double)12.0, (double)10.5)}), Shapes.or((VoxelShape)Block.box((double)0.8, (double)0.0, (double)8.0, (double)15.2, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{Block.box((double)8.0, (double)0.0, (double)0.8, (double)8.0, (double)16.0, (double)15.2), Block.box((double)4.5, (double)5.0, (double)4.5, (double)11.5, (double)12.0, (double)11.5)})};
        CODEC = SablenutBlock.simpleCodec(SablenutBlock::new);
        AGE = BlockStateProperties.AGE_3;
        FACING = BlockStateProperties.FACING;
        HANGING_SHAPE = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), (VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
    }
}

