/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.jamiedev.bygone.common.block.AmaranthCropBlock;
import com.jamiedev.bygone.common.block.entity.SprinklerEntity;
import com.mojang.serialization.MapCodec;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SprinklerBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    public static final MapCodec<SprinklerBlock> CODEC = SprinklerBlock.simpleCodec(SprinklerBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_7;
    RandomSource random;

    public SprinklerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<SprinklerBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SprinklerEntity(pos, state);
    }

    private static boolean isCropsNearby(LevelReader world, BlockPos pos) {
        BlockPos blockPos;
        Iterator var2 = BlockPos.betweenClosed((BlockPos)pos.offset(-15, 0, -15), (BlockPos)pos.offset(15, 1, 15)).iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (world.getBlockState(blockPos = (BlockPos)var2.next()).is(BlockTags.CROPS));
        return true;
    }

    private static boolean canFertilize(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2;
    }

    private static boolean isFertilizerItem(ItemStack stack) {
        return stack.is(Items.BONE_MEAL);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (SprinklerBlock.isFertilizerItem(stack)) {
            stack.consume(1, (LivingEntity)player);
            if (SprinklerBlock.isCropsNearby((LevelReader)world, pos) && world.random.nextInt(4) == 1) {
                for (int i = 1; i <= 2; ++i) {
                    for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset(-15, 0, -15), (BlockPos)pos.offset(15, 1, 15))) {
                        BlockState blockState = world.getBlockState(blockPos);
                        Block block = blockState.getBlock();
                        if (!(block instanceof AmaranthCropBlock)) continue;
                        AmaranthCropBlock cropBlock = (AmaranthCropBlock)block;
                        if (!((double)world.random.nextFloat() <= 0.3) || cropBlock.isMaxAge(blockState) || !(world instanceof ServerLevel) || !cropBlock.isBonemealSuccess(world, world.random, blockPos, blockState)) continue;
                        cropBlock.performBonemeal((ServerLevel)world, world.random, blockPos, blockState);
                        world.levelEvent(1505, blockPos, 15);
                    }
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return hand == InteractionHand.MAIN_HAND && SprinklerBlock.canFertilize(state) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }
}

