/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.cogs;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.PoweredBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;

public class BaseVerdigrisCogBlock
extends PoweredBlock {
    public static final MapCodec<PoweredBlock> CODEC = RecordCodecBuilder.mapCodec(p_309135_ -> p_309135_.group((App)VerdigrisStage.CODEC.fieldOf("verdigris_stage").forGetter(poweredBlock -> ((BaseVerdigrisCogBlock)poweredBlock).verdigrisStage), (App)BaseVerdigrisCogBlock.propertiesCodec()).apply((Applicative)p_309135_, BaseVerdigrisCogBlock::new));
    public static final BooleanProperty UP;
    public static final BooleanProperty NORTH;
    public static final BooleanProperty EAST;
    public static final BooleanProperty SOUTH;
    public static final BooleanProperty WEST;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION;
    protected static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB;
    private static final VoxelShape WEST_AABB;
    private static final VoxelShape EAST_AABB;
    private static final VoxelShape NORTH_AABB;
    private static final VoxelShape SOUTH_AABB;
    private final ImmutableMap shapesCache;
    public static final DirectionProperty FACING;
    public final VerdigrisStage verdigrisStage;
    public static final IntegerProperty DELAY;
    public static final BooleanProperty POWERED;

    public MapCodec<PoweredBlock> codec() {
        return CODEC;
    }

    public BaseVerdigrisCogBlock(VerdigrisStage stage, BlockBehaviour.Properties properties) {
        super(properties);
        this.verdigrisStage = stage;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(true))).setValue((Property)DELAY, (Comparable)Integer.valueOf(1)));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), BaseVerdigrisCogBlock::calculateShape)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.scheduleTick(pos, (Block)this, this.verdigrisStage.degradationAmount, TickPriority.VERY_HIGH);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        BlockState newState = this.verdigrisStage.shouldPower ? (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)POWERED) == false)) : (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
        level.setBlockAndUpdate(pos, newState);
        if (random.nextFloat() < 0.001f) {
            BlockState replaceState = this.nextBLockState(state, (Level)level, pos);
            level.setBlockAndUpdate(pos, replaceState);
        }
        if (this.verdigrisStage.shouldPower) {
            level.scheduleTick(pos, (Block)this, this.verdigrisStage.degradationAmount, TickPriority.VERY_HIGH);
        }
    }

    public BlockState nextBLockState(BlockState oldState, Level level, BlockPos pos) {
        VerdigrisStage verdigrisStage = ((BaseVerdigrisCogBlock)oldState.getBlock()).verdigrisStage;
        if (verdigrisStage == verdigrisStage.last()) {
            return oldState;
        }
        Block nextBlock = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)(verdigrisStage.next().stage.toLowerCase() + "_verdigris_cog")));
        level.scheduleTick(pos, nextBlock, 1, TickPriority.VERY_HIGH);
        return nextBlock.withPropertiesOf(oldState);
    }

    protected int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue() && (side == Direction.UP || side == Direction.DOWN)) {
            return super.getSignal(blockState, blockAccess, pos, side);
        }
        return 0;
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelshape = Shapes.empty();
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.isEmpty() ? Shapes.block() : voxelshape;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.shapesCache.get((Object)state);
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return this.hasFaces(this.getUpdatedState(state, (BlockGetter)level, pos));
    }

    private boolean canAttachTo(BlockGetter blockReader, BlockPos pos, Direction direction) {
        BlockState blockstate = blockReader.getBlockState(pos);
        return blockstate.isFaceSturdy(blockReader, pos, direction);
    }

    private boolean hasFaces(BlockState state) {
        return this.countFaces(state) > 0;
    }

    private int countFaces(BlockState state) {
        int i = 0;
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)state.getValue((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean canSupportAtFace(BlockGetter level, BlockPos pos, Direction direction) {
        if (direction == Direction.DOWN) {
            return false;
        }
        BlockPos blockpos = pos.relative(direction);
        if (BaseVerdigrisCogBlock.isAcceptableNeighbour(level, blockpos, direction)) {
            return true;
        }
        if (direction.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(direction);
        BlockState blockstate = level.getBlockState(pos.above());
        return blockstate.is((Block)this) && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
    }

    public static boolean isAcceptableNeighbour(BlockGetter blockReader, BlockPos neighborPos, Direction attachedFace) {
        return MultifaceBlock.canAttachTo((BlockGetter)blockReader, (Direction)attachedFace, (BlockPos)neighborPos, (BlockState)blockReader.getBlockState(neighborPos));
    }

    private BlockState getUpdatedState(BlockState state, BlockGetter level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            state = (BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(BaseVerdigrisCogBlock.isAcceptableNeighbour(level, blockpos, Direction.DOWN)));
        }
        BlockState blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = BaseVerdigrisCogBlock.getPropertyForFace(direction);
            if (!((Boolean)state.getValue((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(level, pos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = level.getBlockState(blockpos);
                }
                flag = blockstate.is((Block)this) && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
            }
            state = (BlockState)state.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return state;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
        }
        BlockState blockstate = this.getUpdatedState(state, (BlockGetter)level, currentPos);
        return !this.hasFaces(blockstate) ? Blocks.AIR.defaultBlockState() : blockstate;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (level.isClientSide()) {
            return;
        }
        BlockState blockstate = this.getUpdatedState(state, (BlockGetter)level, pos);
        if (!this.hasFaces(blockstate)) {
            Block.dropResources((BlockState)blockstate, (Level)level, (BlockPos)pos);
            level.removeBlock(pos, movedByPiston);
        }
    }

    protected int getInputSignal(Level level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(direction);
        int i = level.getSignal(blockPos, direction);
        if (i >= 15) {
            return i;
        }
        BlockState blockState = level.getBlockState(blockPos);
        return Math.max(i, blockState.is(Blocks.REDSTONE_WIRE) ? (Integer)blockState.getValue((Property)RedStoneWireBlock.POWER) : 0);
    }

    protected boolean sideInputDiodesOnly() {
        return false;
    }

    protected int getAlternateSignal(SignalGetter level, BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        Direction direction2 = direction.getClockWise();
        Direction direction3 = direction.getCounterClockWise();
        boolean bl = this.sideInputDiodesOnly();
        return Math.max(level.getControlInputSignal(pos.relative(direction2), direction2, bl), level.getControlInputSignal(pos.relative(direction3), direction3, bl));
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    protected boolean shouldTurnOn(Level level, BlockPos pos, BlockState state) {
        return this.getInputSignal(level, pos, state) > 0;
    }

    protected int getDelay(BlockState state) {
        return (Integer)state.getValue((Property)DELAY) * 2;
    }

    private BlockState copyRandomFaces(BlockState sourceState, BlockState spreadState, RandomSource random) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty;
            if (!random.nextBoolean() || !((Boolean)sourceState.getValue((Property)(booleanproperty = BaseVerdigrisCogBlock.getPropertyForFace(direction)))).booleanValue()) continue;
            spreadState = (BlockState)spreadState.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return spreadState;
    }

    private boolean hasHorizontalConnection(BlockState state) {
        return (Boolean)state.getValue((Property)NORTH) != false || (Boolean)state.getValue((Property)EAST) != false || (Boolean)state.getValue((Property)SOUTH) != false || (Boolean)state.getValue((Property)WEST) != false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        boolean flag = blockstate.is((Block)this);
        BlockState blockstate1 = flag ? blockstate : this.defaultBlockState();
        for (Direction direction : context.getNearestLookingDirections()) {
            boolean flag1;
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanproperty = BaseVerdigrisCogBlock.getPropertyForFace(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
            if (flag1 || !this.canSupportAtFace((BlockGetter)context.getLevel(), context.getClickedPos(), direction)) continue;
            return (BlockState)blockstate1.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return flag ? blockstate1 : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, NORTH, EAST, SOUTH, WEST, POWERED, DELAY, FACING});
    }

    @Deprecated
    protected BlockState rotate(BlockState state, Rotation rotate) {
        switch (rotate) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)));
            }
        }
        return state;
    }

    @Deprecated
    protected BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            }
        }
        return super.mirror(state, mirror);
    }

    public static BooleanProperty getPropertyForFace(Direction face) {
        return PROPERTY_BY_DIRECTION.get(face);
    }

    static {
        FACING = BlockStateProperties.FACING;
        POWERED = BlockStateProperties.POWERED;
        DELAY = IntegerProperty.create((String)"delay", (int)0, (int)2);
        UP = PipeBlock.UP;
        NORTH = PipeBlock.NORTH;
        EAST = PipeBlock.EAST;
        SOUTH = PipeBlock.SOUTH;
        WEST = PipeBlock.WEST;
        PROPERTY_BY_DIRECTION = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(p_57886_ -> p_57886_.getKey() != Direction.DOWN).collect(Util.toMap());
        UP_AABB = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
        EAST_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
        SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public static enum VerdigrisStage implements StringRepresentable
    {
        PRISTINE("pristine", 10),
        TARNISHED("tarnished", 30),
        RAMSHACKLED("ramshackled", 60),
        BROKEN("broken", 0, false);

        public static final Codec<VerdigrisStage> CODEC;
        private String stage;
        private int degradationAmount;
        private boolean shouldPower;
        private static final VerdigrisStage[] vals;

        private VerdigrisStage(String stage, int degradationAmount) {
            this(stage, degradationAmount, true);
        }

        private VerdigrisStage(String stage, int degradationAmount, boolean shouldPower) {
            this.stage = stage;
            this.degradationAmount = degradationAmount;
            this.shouldPower = shouldPower;
        }

        public String getSerializedName() {
            return this.stage;
        }

        public VerdigrisStage next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        public VerdigrisStage last() {
            return vals[vals.length - 1];
        }

        static {
            CODEC = StringRepresentable.fromEnum(VerdigrisStage::values);
            vals = VerdigrisStage.values();
        }
    }
}

