/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jamiedev.bygone.common.block.BlemishVeinBlock;
import com.jamiedev.bygone.common.block.entity.BlemishSpreadable;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BlemishSpreadManager {
    public static final int field_37609 = 24;
    public static final int MAX_CHARGE = 1000;
    public static final float field_37611 = 0.5f;
    private static final int MAX_CURSORS = 32;
    public static final int field_37612 = 11;
    final boolean worldGen;
    private final TagKey<Block> replaceableTag;
    private final int extraBlockChance;
    private final int maxDistance;
    private final int spreadChance;
    private final int decayChance;
    private List<Cursor> cursors = new ArrayList<Cursor>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public BlemishSpreadManager(boolean worldGen, TagKey<Block> replaceableTag, int extraBlockChance, int maxDistance, int spreadChance, int decayChance) {
        this.worldGen = worldGen;
        this.replaceableTag = replaceableTag;
        this.extraBlockChance = extraBlockChance;
        this.maxDistance = maxDistance;
        this.spreadChance = spreadChance;
        this.decayChance = decayChance;
    }

    public static BlemishSpreadManager create() {
        return new BlemishSpreadManager(false, JamiesModTag.BLEMISH_REPLACEABLE, 10, 4, 10, 5);
    }

    public static BlemishSpreadManager createWorldGen() {
        return new BlemishSpreadManager(true, JamiesModTag.BLEMISH_REPLACEABLE_WORLD_GEN, 50, 1, 5, 10);
    }

    public TagKey<Block> getReplaceableTag() {
        return this.replaceableTag;
    }

    public int getExtraBlockChance() {
        return this.extraBlockChance;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public int getSpreadChance() {
        return this.spreadChance;
    }

    public int getDecayChance() {
        return this.decayChance;
    }

    public boolean isWorldGen() {
        return this.worldGen;
    }

    @VisibleForTesting
    public List<Cursor> getCursors() {
        return this.cursors;
    }

    public void clearCursors() {
        this.cursors.clear();
    }

    public void readNbt(CompoundTag nbt) {
        if (nbt.contains("cursors", 9)) {
            this.cursors.clear();
            DataResult var10000 = Cursor.CODEC.listOf().parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)nbt.getList("cursors", 10)));
            Logger var10001 = LOGGER;
            Objects.requireNonNull(var10001);
            List list = var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).orElseGet(ArrayList::new);
            int i = Math.min(list.size(), 32);
            for (int j = 0; j < i; ++j) {
                this.addCursor((Cursor)list.get(j));
            }
        }
    }

    public void writeNbt(CompoundTag nbt) {
        DataResult var10000 = Cursor.CODEC.listOf().encodeStart((DynamicOps)NbtOps.INSTANCE, this.cursors);
        Logger var10001 = LOGGER;
        Objects.requireNonNull(var10001);
        var10000.resultOrPartial(arg_0 -> ((Logger)var10001).error(arg_0)).ifPresent(cursorsNbt -> nbt.put("cursors", cursorsNbt));
    }

    public void spread(BlockPos pos, int charge) {
        while (charge > 0) {
            int i = Math.min(charge, 1000);
            this.addCursor(new Cursor(pos, i));
            charge -= i;
        }
    }

    private void addCursor(Cursor cursor) {
        if (this.cursors.size() < 32) {
            this.cursors.add(cursor);
        }
    }

    public void tick(LevelAccessor world, BlockPos pos, @NotNull RandomSource random, boolean shouldConvertToBlock) {
        if (!this.cursors.isEmpty()) {
            BlockPos blockPos;
            ArrayList<Cursor> list = new ArrayList<Cursor>();
            HashMap<BlockPos, Cursor> map = new HashMap<BlockPos, Cursor>();
            Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
            for (Cursor cursor : this.cursors) {
                cursor.spread(world, pos, random, this, shouldConvertToBlock);
                if (cursor.charge <= 0) {
                    world.levelEvent(6006, cursor.getPos(), 0);
                    continue;
                }
                blockPos = cursor.getPos();
                object2IntMap.computeInt((Object)blockPos, (posx, charge) -> (charge == null ? 0 : charge) + cursor.charge);
                Cursor cursor2 = (Cursor)map.get(blockPos);
                if (cursor2 == null) {
                    map.put(blockPos, cursor);
                    list.add(cursor);
                    continue;
                }
                if (!this.isWorldGen() && cursor.charge + cursor2.charge <= 1000) {
                    cursor2.merge(cursor);
                    continue;
                }
                list.add(cursor);
                if (cursor.charge >= cursor2.charge) continue;
                map.put(blockPos, cursor);
            }
            for (Object2IntMap.Entry entry : object2IntMap.object2IntEntrySet()) {
                Set<Direction> collection;
                blockPos = (BlockPos)entry.getKey();
                int i = entry.getIntValue();
                Cursor cursor3 = (Cursor)map.get(blockPos);
                Set<Direction> set = collection = cursor3 == null ? null : cursor3.getFaces();
                if (i <= 0 || collection == null) continue;
                int j = (int)(Math.log1p(i) / (double)2.3f) + 1;
                int k = (j << 6) + MultifaceBlock.pack(collection);
                world.levelEvent(6006, blockPos, k);
            }
            this.cursors = list;
            return;
        }
    }

    public static class Cursor {
        private static final ObjectArrayList OFFSETS = (ObjectArrayList)Util.make((Object)new ObjectArrayList(18), list -> {
            Stream<BlockPos> var10000 = BlockPos.betweenClosedStream((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).filter(pos -> (pos.getX() == 0 || pos.getY() == 0 || pos.getZ() == 0) && !pos.equals((Object)BlockPos.ZERO)).map(BlockPos::immutable);
            Objects.requireNonNull(list);
            var10000.forEach(arg_0 -> ((ObjectArrayList)list).add(arg_0));
        });
        public static final int field_37622 = 1;
        private BlockPos pos;
        int charge;
        private int update;
        private int decay;
        @Nullable
        private Set<Direction> faces;
        private static final Codec<Set<Direction>> DIRECTION_SET_CODEC = Direction.CODEC.listOf().xmap(directions -> Sets.newEnumSet((Iterable)directions, Direction.class), Lists::newArrayList);
        public static final Codec<Cursor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(Cursor::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(Cursor::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(Cursor::getDecay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(cursor -> cursor.update), (App)DIRECTION_SET_CODEC.lenientOptionalFieldOf("facings").forGetter(cursor -> Optional.ofNullable(cursor.getFaces()))).apply((Applicative)instance, Cursor::new));

        private Cursor(BlockPos pos, int charge, int decay, int update, Optional<Set<Direction>> faces) {
            this.pos = pos;
            this.charge = charge;
            this.decay = decay;
            this.update = update;
            this.faces = faces.orElse(null);
        }

        public Cursor(BlockPos pos, int charge) {
            this(pos, charge, 1, 0, Optional.empty());
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getCharge() {
            return this.charge;
        }

        public int getDecay() {
            return this.decay;
        }

        @Nullable
        public Set<Direction> getFaces() {
            return this.faces;
        }

        private boolean canSpread(LevelAccessor world, BlockPos pos, boolean worldGen) {
            if (this.charge <= 0) {
                return false;
            }
            if (worldGen) {
                return true;
            }
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                return serverWorld.shouldTickBlocksAt(pos);
            }
            return false;
        }

        public void spread(LevelAccessor world, BlockPos pos, @NotNull RandomSource random, BlemishSpreadManager spreadManager, boolean shouldConvertToBlock) {
            if (this.canSpread(world, pos, spreadManager.worldGen)) {
                if (this.update > 0) {
                    --this.update;
                } else {
                    BlockState blockState = world.getBlockState(this.pos);
                    BlemishSpreadable BlemishSpreadable2 = Cursor.getSpreadable(blockState);
                    if (shouldConvertToBlock && BlemishSpreadable2.spread(world, this.pos, blockState, this.faces, spreadManager.isWorldGen())) {
                        if (BlemishSpreadable2.shouldConvertToSpreadable()) {
                            blockState = world.getBlockState(this.pos);
                            BlemishSpreadable2 = Cursor.getSpreadable(blockState);
                        }
                        world.playSound(null, this.pos, SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    this.charge = BlemishSpreadable2.spread(this, world, pos, random, spreadManager, shouldConvertToBlock);
                    if (this.charge <= 0) {
                        BlemishSpreadable2.spreadAtSamePosition(world, blockState, this.pos, random);
                    } else {
                        BlockPos blockPos = Cursor.getSpreadPos(world, this.pos, random);
                        if (blockPos != null) {
                            BlemishSpreadable2.spreadAtSamePosition(world, blockState, this.pos, random);
                            this.pos = blockPos.immutable();
                            if (spreadManager.isWorldGen() && !this.pos.closerThan(new Vec3i(pos.getX(), this.pos.getY(), pos.getZ()), 15.0)) {
                                this.charge = 0;
                                return;
                            }
                            blockState = world.getBlockState(blockPos);
                        }
                        if (blockState.getBlock() instanceof BlemishSpreadable) {
                            this.faces = MultifaceBlock.availableFaces((BlockState)blockState);
                        }
                        this.decay = BlemishSpreadable2.getDecay(this.decay);
                        this.update = BlemishSpreadable2.getUpdate();
                    }
                }
            }
        }

        void merge(Cursor cursor) {
            this.charge += cursor.charge;
            cursor.charge = 0;
            this.update = Math.min(this.update, cursor.update);
        }

        private static BlemishSpreadable getSpreadable(BlockState state) {
            BlemishSpreadable BlemishSpreadable2;
            Block var2 = state.getBlock();
            BlemishSpreadable var10000 = var2 instanceof BlemishSpreadable ? (BlemishSpreadable2 = (BlemishSpreadable)var2) : BlemishSpreadable.VEIN_ONLY_SPREADER;
            return var10000;
        }

        private static List<Vec3i> shuffleOffsets(RandomSource random) {
            return Util.shuffledCopy((ObjectArrayList)OFFSETS, (RandomSource)random);
        }

        @Nullable
        private static BlockPos getSpreadPos(LevelAccessor world, BlockPos pos, @NotNull RandomSource random) {
            BlockPos.MutableBlockPos mutable = pos.mutable();
            BlockPos.MutableBlockPos mutable2 = pos.mutable();
            for (Vec3i vec3i : Cursor.shuffleOffsets(random)) {
                mutable2.setWithOffset((Vec3i)pos, vec3i);
                BlockState blockState = world.getBlockState((BlockPos)mutable2);
                if (!(blockState.getBlock() instanceof BlemishSpreadable) || !Cursor.canSpread(world, pos, (BlockPos)mutable2)) continue;
                mutable.set((Vec3i)mutable2);
                if (!BlemishVeinBlock.veinCoversBlemishReplaceable(world, blockState, (BlockPos)mutable2)) continue;
                break;
            }
            return mutable.equals((Object)pos) ? null : mutable;
        }

        private static boolean canSpread(LevelAccessor world, BlockPos sourcePos, BlockPos targetPos) {
            if (sourcePos.distManhattan((Vec3i)targetPos) == 1) {
                return true;
            }
            BlockPos blockPos = targetPos.subtract((Vec3i)sourcePos);
            Direction direction = Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)(blockPos.getX() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            Direction direction2 = Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)(blockPos.getY() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            Direction direction3 = Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)(blockPos.getZ() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            if (blockPos.getX() == 0) {
                return Cursor.canSpread(world, sourcePos, direction2) || Cursor.canSpread(world, sourcePos, direction3);
            }
            if (blockPos.getY() == 0) {
                return Cursor.canSpread(world, sourcePos, direction) || Cursor.canSpread(world, sourcePos, direction3);
            }
            return Cursor.canSpread(world, sourcePos, direction) || Cursor.canSpread(world, sourcePos, direction2);
        }

        private static boolean canSpread(LevelAccessor world, BlockPos pos, Direction direction) {
            BlockPos blockPos = pos.relative(direction);
            return !world.getBlockState(blockPos).isFaceSturdy((BlockGetter)world, blockPos, direction.getOpposite());
        }
    }
}

