/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.entity;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.jamiedev.bygone.common.block.GumboPotBlock;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GumboPotBlockEntity
extends BlockEntity {
    public static final int BASE_SERVINGS_PER_INGREDIENT = 12;
    public static final Codec<Pair<Integer, FoodProperties>> INGREDIENT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("servings").forGetter(Pair::getFirst), (App)FoodProperties.DIRECT_CODEC.fieldOf("properties").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::new));
    public static final Codec<List<Pair<Integer, FoodProperties>>> CONTENTS_CODEC = INGREDIENT_CODEC.listOf();
    public static final String NBT_KEY_CONTENTS = "contents";
    protected final List<Pair<Integer, FoodProperties>> potContents = new ArrayList<Pair<Integer, FoodProperties>>();

    public GumboPotBlockEntity(BlockPos pos, BlockState blockState) {
        super(BGBlockEntities.GUMBO_POT.get(), pos, blockState);
    }

    public ImmutableList<Pair<Integer, FoodProperties>> ingredientsView() {
        return ImmutableList.copyOf(this.potContents);
    }

    public void addIngredient(FoodProperties ingredient) {
        this.potContents.add((Pair<Integer, FoodProperties>)Pair.of((Object)12, (Object)ingredient));
    }

    public boolean canAddIngredient(ItemStack ingredient) {
        BlockState state = this.getBlockState();
        if (GumboPotBlock.canFitAdditionalIngredients(state) && !ingredient.is(JamiesModTag.CANNOT_ADD_TO_GUMBO)) {
            FoodProperties foodProperties = (FoodProperties)ingredient.get(DataComponents.FOOD);
            if (foodProperties != null) {
                return true;
            }
            GumboIngredientComponent gumboIngredientComponent = (GumboIngredientComponent)ingredient.get((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value());
            return gumboIngredientComponent != null;
        }
        return false;
    }

    public void addIngredient(ItemStack ingredient) {
        BlockState state = this.getBlockState();
        if (GumboPotBlock.canFitAdditionalIngredients(state) && !ingredient.is(JamiesModTag.CANNOT_ADD_TO_GUMBO)) {
            GumboIngredientComponent gumboIngredientComponent;
            SuspiciousStewEffects suspiciousStewEffects = (SuspiciousStewEffects)ingredient.get(DataComponents.SUSPICIOUS_STEW_EFFECTS);
            FoodProperties foodProperties = (FoodProperties)ingredient.get(DataComponents.FOOD);
            if (foodProperties == null && (gumboIngredientComponent = (GumboIngredientComponent)ingredient.get((DataComponentType)BGDataComponents.GUMBO_INGREDIENT_DATA.value())) != null) {
                foodProperties = gumboIngredientComponent.properties;
            }
            if (foodProperties != null) {
                this.addIngredient(this.removeNegativeEffectsIf(this.spliceStewEffects(foodProperties, suspiciousStewEffects), ingredient.is(JamiesModTag.GUMBO_MAKES_SAFE) || this.getBlockState().getOptionalValue(GumboPotBlock.HEATED).orElse(false) != false));
            }
        }
    }

    public boolean canScoopBowl(@Nullable ItemStack bowl) {
        if (bowl == null) {
            return false;
        }
        BlockState state = this.getBlockState();
        if (GumboPotBlock.canScoopBowl(state)) {
            return GumboScooping.getFilled(bowl.getItem()) != null;
        }
        return false;
    }

    @NotNull
    public ItemStack scoopBowl(@Nullable ItemStack bowl) {
        Item filledItem;
        BlockState state = this.getBlockState();
        if (bowl != null && GumboPotBlock.canScoopBowl(state) && (filledItem = GumboScooping.getFilled(bowl.getItem())) != null) {
            ItemStack filledStack = new ItemStack((ItemLike)filledItem);
            filledStack.set(DataComponents.FOOD, (Object)this.extractFood(Optional.ofNullable(GumboScooping.getEmptied(filledItem)).map(ItemStack::new)));
            return filledStack;
        }
        return ItemStack.EMPTY;
    }

    private FoodProperties extractFood(Optional<ItemStack> convertsTo) {
        boolean thisIsTheLastOfIt = this.getBlockState().getOptionalValue((Property)GumboPotBlock.LEVEL).orElse(0) <= 1;
        ArrayList<Pair> resultingContents = new ArrayList<Pair>();
        ArrayList<FoodProperties> toCombine = new ArrayList<FoodProperties>();
        for (Pair<Integer, FoodProperties> pair : this.potContents) {
            FoodProperties currentIngredient = (FoodProperties)pair.getSecond();
            int count = (Integer)pair.getFirst();
            if (count > 1 && !thisIsTheLastOfIt) {
                resultingContents.add(Pair.of((Object)(count - 1), (Object)currentIngredient));
            }
            toCombine.add(currentIngredient);
        }
        this.potContents.clear();
        this.potContents.addAll(resultingContents);
        return this.combineFoods(toCombine, convertsTo);
    }

    private FoodProperties combineFoods(List<FoodProperties> toCombine, Optional<ItemStack> convertsTo) {
        int count = toCombine.size();
        float scaleFactor = 1.0f / (float)count;
        int totalNutrition = 0;
        float totalSaturation = 0.0f;
        boolean canAlwaysEat = false;
        float eatSeconds = 0.0f;
        ArrayList effects = new ArrayList();
        for (FoodProperties properties : toCombine) {
            totalNutrition += properties.nutrition();
            totalSaturation += properties.saturation();
            eatSeconds += properties.eatSeconds();
            canAlwaysEat |= properties.canAlwaysEat();
            effects.addAll(properties.effects());
        }
        totalNutrition = Mth.ceil((float)(scaleFactor * (float)totalNutrition)) + 1;
        totalSaturation = (float)Mth.ceil((float)(scaleFactor * totalSaturation)) + 0.05f;
        if ((eatSeconds = (float)Mth.ceil((float)(scaleFactor * eatSeconds))) == 0.0f) {
            eatSeconds += 0.05f;
        }
        effects.replaceAll(possibleEffect -> new FoodProperties.PossibleEffect(possibleEffect.effect(), scaleFactor * possibleEffect.probability()));
        return new FoodProperties(totalNutrition, totalSaturation, canAlwaysEat, eatSeconds, convertsTo, effects);
    }

    protected FoodProperties removeNegativeEffectsIf(FoodProperties properties, boolean removeIfTrue) {
        return removeIfTrue ? this.removeNegativeEffects(properties) : properties;
    }

    protected FoodProperties removeNegativeEffects(FoodProperties properties) {
        return new FoodProperties(properties.nutrition(), properties.saturation(), properties.canAlwaysEat(), properties.eatSeconds(), properties.usingConvertsTo(), properties.effects().stream().filter(possibleEffect -> ((MobEffect)possibleEffect.effect().getEffect().value()).isBeneficial()).toList());
    }

    protected FoodProperties spliceStewEffects(FoodProperties properties, @Nullable SuspiciousStewEffects effects) {
        return effects == null ? properties : new FoodProperties(properties.nutrition(), properties.saturation(), properties.canAlwaysEat(), properties.eatSeconds(), properties.usingConvertsTo(), Streams.concat((Stream[])new Stream[]{properties.effects().stream(), effects.effects().stream().map(entry -> new FoodProperties.PossibleEffect(entry.createEffectInstance(), 1.0f))}).toList());
    }

    protected void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.potContents.clear();
        Tag contents = nbt.get(NBT_KEY_CONTENTS);
        this.potContents.addAll((Collection)((Pair)CONTENTS_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)contents).getOrThrow()).getFirst());
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        DataResult contentsResult = CONTENTS_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.potContents);
        contentsResult.ifError(tagError -> System.out.println("Warning! Gumbo pot block entity encountered an error while saving: " + tagError.message()));
        contentsResult.ifSuccess(contents -> nbt.put(NBT_KEY_CONTENTS, contents));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryLookup) {
        CompoundTag nbtCompound = super.getUpdateTag(registryLookup);
        DataResult contentsResult = CONTENTS_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.potContents);
        contentsResult.ifError(tagError -> System.out.println("Warning! Gumbo pot block entity encountered an error while constructing an update tag: " + tagError.message()));
        contentsResult.ifSuccess(contents -> nbtCompound.put(NBT_KEY_CONTENTS, contents));
        return nbtCompound;
    }

    public record GumboIngredientComponent(FoodProperties properties) {
        public static final Codec<GumboIngredientComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FoodProperties.DIRECT_CODEC.fieldOf("food_properties").forGetter(GumboIngredientComponent::properties)).apply((Applicative)instance, GumboIngredientComponent::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, GumboIngredientComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)FoodProperties.DIRECT_STREAM_CODEC, GumboIngredientComponent::properties, GumboIngredientComponent::new);
    }

    public static class GumboScooping {
        protected static final BiMap<Item, Item> SCOOPING_MAP = HashBiMap.create();

        @Nullable
        public static Item getFilled(Item in) {
            return (Item)SCOOPING_MAP.get((Object)in);
        }

        @Nullable
        public static Item getEmptied(Item out) {
            return (Item)SCOOPING_MAP.inverse().get((Object)out);
        }

        @Nullable
        public static Item setFilled(Item in, Item out) {
            return (Item)SCOOPING_MAP.put((Object)in, (Object)out);
        }
    }
}

