/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.entity;

import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGItems;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MegalithTotemEntity
extends BlockEntity
implements Clearable {
    private final SimpleContainer inventory = new SimpleContainer(1);
    private int fuel = 0;
    private static final int FUEL_PER_ITEM = 2400;
    private static final int MAX_FUEL = 24000;
    private static final int RANGE = 15;
    private static final int PLANT_ATTEMPTS_PER_TICK = 4;
    private final Map<BlockPos, Integer> bonemealedplants = new HashMap<BlockPos, Integer>();
    public static final int BOOST_COOLDOWN_TICKS = 20;

    public MegalithTotemEntity(BlockPos pos, BlockState state) {
        super(BGBlockEntities.MEGALITH_TOTEM.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MegalithTotemEntity be) {
        if (level.isClientSide) {
            return;
        }
        Iterator<Map.Entry<BlockPos, Integer>> storeplants = be.bonemealedplants.entrySet().iterator();
        while (storeplants.hasNext()) {
            Map.Entry<BlockPos, Integer> entry = storeplants.next();
            int ticksRemaining = entry.getValue();
            if (ticksRemaining <= 1) {
                storeplants.remove();
                continue;
            }
            entry.setValue(ticksRemaining - 1);
        }
        if (be.fuel > 0) {
            --be.fuel;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                RandomSource rand = serverLevel.random;
                int attemptsPerTick = Math.max(1, 4);
                int cooldownTicks = Math.max(40, 20);
                for (int i = 0; i < attemptsPerTick; ++i) {
                    int dx = rand.nextInt(31) - 15;
                    int dz = rand.nextInt(31) - 15;
                    int x = pos.getX() + dx;
                    int z = pos.getZ() + dz;
                    for (int dy = -2; dy <= 2; ++dy) {
                        BonemealableBlock bonemealable;
                        BlockState plantState;
                        Block block;
                        int y = pos.getY() + dy;
                        BlockPos plantPos = new BlockPos(x, y, z);
                        if (be.bonemealedplants.containsKey(plantPos) || !((block = (plantState = level.getBlockState(plantPos)).getBlock()) instanceof CropBlock) && !(block instanceof SaplingBlock) || !(bonemealable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, plantPos, plantState) || !bonemealable.isBonemealSuccess(level, rand, plantPos, plantState)) continue;
                        bonemealable.performBonemeal(serverLevel, rand, plantPos, plantState);
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)plantPos.getX() + 0.5, (double)plantPos.getY() + 0.5, (double)plantPos.getZ() + 0.5, 8, 0.2, 0.5, 0.2, 0.1);
                        be.bonemealedplants.put(plantPos.immutable(), cooldownTicks);
                    }
                }
            }
        } else {
            ItemStack stack = be.inventory.getItem(0);
            if (!stack.isEmpty() && MegalithTotemEntity.isLithoplasm(stack)) {
                stack.shrink(1);
                be.fuel = Math.min(be.fuel + 2400, 24000);
            }
        }
    }

    public void clearContent() {
        this.inventory.clearContent();
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    private static boolean isLithoplasm(ItemStack stack) {
        return stack.is(BGItems.LITHOPLASM.get());
    }
}

