/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block.shelf;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.jamiedev.bygone.common.block.shelf.ShelfFungiFanBlock;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShelfFungiWallFanBlock
extends ShelfFungiFanBlock {
    public static final MapCodec<ShelfFungiWallFanBlock> CODEC = ShelfFungiWallFanBlock.simpleCodec(ShelfFungiWallFanBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final Map<Direction, VoxelShape> FACING_TO_SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)ShelfFungiWallFanBlock.box((double)0.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)16.0), (Object)Direction.SOUTH, (Object)ShelfFungiWallFanBlock.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)11.0), (Object)Direction.WEST, (Object)ShelfFungiWallFanBlock.box((double)5.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (Object)Direction.EAST, (Object)ShelfFungiWallFanBlock.box((double)0.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)16.0)));

    public MapCodec<? extends ShelfFungiWallFanBlock> codec() {
        return CODEC;
    }

    public ShelfFungiWallFanBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return FACING_TO_SHAPE.get(state.getValue((Property)FACING));
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return direction.getOpposite() == state.getValue((Property)FACING) && !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : state;
    }

    protected boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockState = world.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction[] directions;
        BlockState blockState = super.getStateForPlacement(ctx);
        Level worldView = ctx.getLevel();
        BlockPos blockPos = ctx.getClickedPos();
        Direction[] var6 = directions = ctx.getNearestLookingDirections();
        int var7 = directions.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            Direction direction = var6[var8];
            if (!direction.getAxis().isHorizontal() || !(blockState = (BlockState)blockState.setValue((Property)FACING, (Comparable)direction.getOpposite())).canSurvive((LevelReader)worldView, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public static boolean shouldConnectTo(BlockGetter world, BlockPos pos, Direction direction) {
        return MultifaceBlock.canAttachTo((BlockGetter)world, (Direction)direction, (BlockPos)pos, (BlockState)world.getBlockState(pos));
    }
}

