/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.google.common.collect.ImmutableList;
import com.jamiedev.bygone.common.entity.ai.HydropusBrain;
import com.mojang.serialization.Dynamic;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class HydropusEntity
extends Animal
implements NeutralMob {
    protected static final ImmutableList<SensorType<? extends Sensor<? super HydropusEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.PATH, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.INTERACTION_TARGET, (Object[])new MemoryModuleType[]{MemoryModuleType.ANGRY_AT, MemoryModuleType.UNIVERSAL_ANGER, MemoryModuleType.NEAREST_ATTACKABLE});

    protected HydropusEntity(EntityType<? extends HydropusEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createHydropusAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, 0.1);
    }

    protected Brain.Provider<HydropusEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return HydropusBrain.create(dynamic, MEMORY_TYPES, SENSOR_TYPES, this);
    }

    public Brain<HydropusEntity> getBrain() {
        return super.getBrain();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.STRUCTURE) {
            // empty if block
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public int getRemainingPersistentAngerTime() {
        return 0;
    }

    public void setRemainingPersistentAngerTime(int i) {
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return null;
    }

    public void setPersistentAngerTarget(@Nullable UUID uuid) {
    }

    public void startPersistentAngerTimer() {
    }
}

