/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.jamiedev.bygone.common.entity.WraithEntity;
import com.jamiedev.bygone.core.init.JamiesModLootTables;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LithyEntity
extends PathfinderMob {
    Wolf test;
    IronGolem ref;
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.defineId(LithyEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    protected static final EntityDataAccessor<Boolean> DATA_TRIPPED = SynchedEntityData.defineId(LithyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> DATA_JUMP_UP = SynchedEntityData.defineId(LithyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Integer> DATA_TRIPPED_TICK = SynchedEntityData.defineId(LithyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> DATA_TRIP_COOLDOWN = SynchedEntityData.defineId(LithyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> DATA_TRIPWIRE_TRIP_COOLDOWN = SynchedEntityData.defineId(LithyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public boolean tripwireTrip = false;
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState tripBeginAnimationState = new AnimationState();
    public AnimationState tripAnimationState = new AnimationState();
    public AnimationState tripEndAnimationState = new AnimationState();

    public LithyEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_FLAGS_ID, (Object)0);
        builder.define(DATA_TRIPPED, (Object)false);
        builder.define(DATA_JUMP_UP, (Object)false);
        builder.define(DATA_TRIPPED_TICK, (Object)0);
        builder.define(DATA_TRIP_COOLDOWN, (Object)(1200 + this.random.nextInt(0, 200)));
        builder.define(DATA_TRIPWIRE_TRIP_COOLDOWN, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.entityData.set(DATA_TRIPPED, (Object)compound.getBoolean("DataTripped"));
        this.entityData.set(DATA_JUMP_UP, (Object)compound.getBoolean("DataJumpUp"));
        this.entityData.set(DATA_TRIPPED_TICK, (Object)compound.getInt("DataTrippedTick"));
        this.entityData.set(DATA_TRIP_COOLDOWN, (Object)compound.getInt("DataTripCooldown"));
        this.entityData.set(DATA_TRIPWIRE_TRIP_COOLDOWN, (Object)compound.getInt("DataTripwireTripCooldown"));
        super.readAdditionalSaveData(compound);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putBoolean("DataTripped", ((Boolean)this.entityData.get(DATA_TRIPPED)).booleanValue());
        compound.putBoolean("DataJumpUp", ((Boolean)this.entityData.get(DATA_JUMP_UP)).booleanValue());
        compound.putInt("DataTrippedTick", ((Integer)this.entityData.get(DATA_TRIPPED_TICK)).intValue());
        compound.putInt("DataTripCooldown", ((Integer)this.entityData.get(DATA_TRIP_COOLDOWN)).intValue());
        compound.putInt("DataTripwireTripCooldown", ((Integer)this.entityData.get(DATA_TRIPWIRE_TRIP_COOLDOWN)).intValue());
        super.addAdditionalSaveData(compound);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 5.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_DAMAGE, 15.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, WraithEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new LithyMeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new LithyFollowMobGoal(this, 1.4f, 3.0f, 10.0f));
        this.goalSelector.addGoal(6, (Goal)new LithyFollowPlayerGoal(this, 1.4f, 3.0f, 10.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    private void setupAnimationStates() {
        if (this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && !this.getTripped() && !((Boolean)this.entityData.get(DATA_JUMP_UP)).booleanValue()) {
            this.walkAnimationState.startIfStopped(this.tickCount);
        } else {
            this.walkAnimationState.stop();
        }
        if (this.getTripped()) {
            if (this.getTrippedTick() == 0) {
                this.tripBeginAnimationState.start(this.tickCount);
                this.tripAnimationState.stop();
                this.tripEndAnimationState.stop();
            } else if (this.getTrippedTick() >= 125 && this.getTrippedTick() < 250) {
                this.tripBeginAnimationState.stop();
                this.tripAnimationState.startIfStopped(this.tickCount);
                this.tripEndAnimationState.stop();
            }
        } else if (((Boolean)this.entityData.get(DATA_JUMP_UP)).booleanValue()) {
            this.tripBeginAnimationState.stop();
            this.tripAnimationState.stop();
            this.tripEndAnimationState.start(40);
        } else {
            this.tripBeginAnimationState.stop();
            this.tripAnimationState.stop();
            this.tripEndAnimationState.stop();
            if (this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7) {
                this.walkAnimationState.startIfStopped(this.tickCount);
            } else {
                this.walkAnimationState.stop();
            }
        }
    }

    public void tick() {
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (!this.level().isClientSide()) {
            int trippedCooldown = (Integer)this.entityData.get(DATA_TRIP_COOLDOWN);
            int tripTick = (Integer)this.entityData.get(DATA_TRIPPED_TICK);
            if (((Boolean)this.entityData.get(DATA_TRIPPED)).booleanValue() && tripTick < 5) {
                Vec3 startPos = this.position();
                Vec3 lookAng = this.getLookAngle().normalize();
                Vec3 endPos = startPos.add(lookAng.scale(2.0));
                AABB rayBox = new AABB(startPos, endPos).inflate(1.0);
                List livingEntities = this.level().getEntitiesOfClass(LivingEntity.class, rayBox, e -> e != this && e.isAlive() && e.getBoundingBox().intersects(rayBox) && !(e instanceof LithyEntity));
                for (LivingEntity living : livingEntities) {
                    living.hurt(this.damageSources().cramming(), 30.0f);
                }
            }
            if (((Boolean)this.entityData.get(DATA_JUMP_UP)).booleanValue()) {
                this.entityData.set(DATA_JUMP_UP, (Object)false);
                this.push(new Vec3(0.0, 0.4, 0.0));
            }
            if (!((Boolean)this.entityData.get(DATA_TRIPPED)).booleanValue()) {
                this.entityData.set(DATA_TRIPWIRE_TRIP_COOLDOWN, (Object)((Integer)this.entityData.get(DATA_TRIPWIRE_TRIP_COOLDOWN) - 1));
                if (this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7) {
                    this.entityData.set(DATA_TRIP_COOLDOWN, (Object)(trippedCooldown - 1));
                    BlockPos onPos = this.getOnPos().above();
                    BlockState state = this.level().getBlockState(onPos);
                    if (state.is(Blocks.TRIPWIRE) && ((Boolean)state.getValue((Property)TripWireBlock.ATTACHED)).booleanValue() && (Integer)this.entityData.get(DATA_TRIPWIRE_TRIP_COOLDOWN) <= 0) {
                        this.push(this.getDeltaMovement().add(0.0, 0.2, 0.0));
                        this.entityData.set(DATA_TRIPPED, (Object)true);
                        this.entityData.set(DATA_TRIP_COOLDOWN, (Object)(1200 + this.random.nextInt(0, 200)));
                        this.tripwireTrip = true;
                        this.playTripEffects();
                    } else if ((Integer)this.entityData.get(DATA_TRIP_COOLDOWN) <= 0 && (double)this.random.nextFloat() < 0.1) {
                        this.push(this.getDeltaMovement().add(0.0, 0.2, 0.0));
                        this.entityData.set(DATA_TRIPPED, (Object)true);
                        this.entityData.set(DATA_TRIP_COOLDOWN, (Object)(1200 + this.random.nextInt(0, 200)));
                        this.playTripEffects();
                        if (this.level().getServer() != null) {
                            LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(JamiesModLootTables.LITHY_TRIP_LOOT_TABLE);
                            ObjectArrayList list = loottable.getRandomItems(new LootParams.Builder((ServerLevel)this.level()).create(LootContextParamSets.EMPTY));
                            for (ItemStack stack : list) {
                                this.spawnAtLocation(stack);
                            }
                        }
                    }
                }
            } else {
                this.entityData.set(DATA_TRIPPED_TICK, (Object)(tripTick + 1));
                if (tripTick > 60 && (double)this.random.nextFloat() < 0.01) {
                    this.entityData.set(DATA_TRIPPED, (Object)false);
                    this.entityData.set(DATA_TRIPPED_TICK, (Object)0);
                    this.entityData.set(DATA_JUMP_UP, (Object)true);
                    if (this.tripwireTrip) {
                        this.entityData.set(DATA_TRIPWIRE_TRIP_COOLDOWN, (Object)600);
                        this.tripwireTrip = false;
                    }
                    if (this.onGround()) {
                        this.setDeltaMovement(0.0, 0.1, 0.0);
                        this.setPose(Pose.STANDING);
                    }
                }
            }
        }
        super.tick();
    }

    protected float tickHeadTurn(float yRot, float animStep) {
        if (((Boolean)this.entityData.get(DATA_TRIPPED)).booleanValue()) {
            return 0.0f;
        }
        return super.tickHeadTurn(yRot, animStep);
    }

    public void aiStep() {
        Vec3 delta = this.getDeltaMovement();
        if (((Boolean)this.entityData.get(DATA_TRIPPED)).booleanValue() && this.onGround()) {
            this.setDeltaMovement(0.0, delta.y - 0.1, 0.0);
        } else {
            super.aiStep();
        }
    }

    public void travel(Vec3 travelVector) {
        Vec3 delta = this.getDeltaMovement();
        if (((Boolean)this.entityData.get(DATA_TRIPPED)).booleanValue() && this.onGround()) {
            this.setDeltaMovement(0.0, delta.y - 0.1, 0.0);
        } else {
            super.travel(travelVector);
        }
    }

    public boolean getTripped() {
        return (Boolean)this.entityData.get(DATA_TRIPPED);
    }

    public int getTrippedTick() {
        return (Integer)this.entityData.get(DATA_TRIPPED_TICK);
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    protected SoundEvent getAmbientSound() {
        return BGSoundEvents.LITHY_AMBIENT_ADDITIONS_EVENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return BGSoundEvents.LITHY_HURT_ADDITIONS_EVENT;
    }

    protected SoundEvent getDeathSound() {
        return BGSoundEvents.LITHY_DEATH_ADDITIONS_EVENT;
    }

    protected void doPush(Entity entity) {
        if (entity instanceof Enemy && !(entity instanceof Creeper) && this.getRandom().nextInt(20) == 0) {
            this.setTarget((LivingEntity)entity);
        }
        super.doPush(entity);
    }

    public boolean canSpawnSprintParticle() {
        return this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(5) == 0;
    }

    public Crackiness.Level getCrackiness() {
        return Crackiness.GOLEM.byFraction(this.getHealth() / this.getMaxHealth());
    }

    private void playTripEffects() {
        this.playSound(BGSoundEvents.LITHY_TRIP_ADDITIONS_EVENT, 0.7f, 1.2f + this.random.nextFloat() * 0.2f);
        if (this.level().isClientSide()) {
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            for (int i = 0; i < 15; ++i) {
                double offsetX = (this.random.nextDouble() - 0.5) * 0.8;
                double offsetY = this.random.nextDouble() * 0.3;
                double offsetZ = (this.random.nextDouble() - 0.5) * 0.8;
                double velocityX = (this.random.nextDouble() - 0.5) * 0.2;
                double velocityY = this.random.nextDouble() * 0.15 + 0.05;
                double velocityZ = (this.random.nextDouble() - 0.5) * 0.2;
                this.level().addParticle((ParticleOptions)ParticleTypes.POOF, x + offsetX, y + offsetY, z + offsetZ, velocityX, velocityY, velocityZ);
            }
            BlockState groundState = this.level().getBlockState(this.getOnPos());
            if (!groundState.isAir()) {
                for (int i = 0; i < 10; ++i) {
                    double offsetX = (this.random.nextDouble() - 0.5) * 0.6;
                    double offsetZ = (this.random.nextDouble() - 0.5) * 0.6;
                    this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, x + offsetX, y + 0.1, z + offsetZ, 0.0, 0.05, 0.0);
                }
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Crackiness.Level crackiness$level = this.getCrackiness();
        boolean flag = super.hurt(source, amount);
        if (flag && this.getCrackiness() != crackiness$level) {
            this.playSound(SoundEvents.DEEPSLATE_BRICKS_BREAK, 1.0f, 1.0f);
        }
        return flag;
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter level, BlockPos pos) {
        return level.getRawBrightness(pos, 0) > 3;
    }

    public static boolean checkAnimalSpawnRules(EntityType<? extends Animal> animal, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        boolean flag = MobSpawnType.ignoresLightRequirements((MobSpawnType)spawnType) || LithyEntity.isBrightEnoughToSpawn((BlockAndTintGetter)level, pos);
        return level.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && flag;
    }

    public static boolean canSpawn(EntityType<? extends Mob> moobloomEntityType, LevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return serverWorldAccess.getBlockState(blockPos).is(BGBlocks.MEGALITH_LANTERN.get()) || serverWorldAccess.getBlockState(blockPos).is(BGBlocks.BYSLATE.get()) || serverWorldAccess.getBlockState(blockPos).is(BGBlocks.SABLE_MOSS_BLOCK.get()) || serverWorldAccess.getBlockState(blockPos).is(BGBlocks.UMBRAL_SOIL.get()) || serverWorldAccess.getBlockState(blockPos).is(BGBlocks.BYGONESLATE_COAL_ORE.get()) || serverWorldAccess.getBlockState(blockPos).is(BGBlocks.BYGONESLATE_COPPER_ORE.get()) || serverWorldAccess.getBlockState(blockPos).is(BGBlocks.BYGONESLATE_IRON_ORE.get()) || serverWorldAccess.getBlockState(blockPos.below()).is(BGBlocks.ALPHA_MOSS_BLOCK.get());
    }

    static class LithyMeleeAttackGoal
    extends Goal {
        protected final LithyEntity lithy;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private final int attackInterval = 20;
        private long lastCanUseCheck;
        private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;

        public LithyMeleeAttackGoal(LithyEntity lithy, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            this.lithy = lithy;
            this.speedModifier = speedModifier;
            this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (!((Boolean)this.lithy.entityData.get(DATA_TRIPPED)).booleanValue()) {
                long i = this.lithy.level().getGameTime();
                if (i - this.lastCanUseCheck < 20L) {
                    return false;
                }
                this.lastCanUseCheck = i;
                LivingEntity livingentity = this.lithy.getTarget();
                if (livingentity == null) {
                    return false;
                }
                if (!livingentity.isAlive()) {
                    return false;
                }
                this.path = this.lithy.getNavigation().createPath((Entity)livingentity, 0);
                return this.path != null ? true : this.lithy.isWithinMeleeAttackRange(livingentity);
            }
            return false;
        }

        public boolean canContinueToUse() {
            if (!((Boolean)this.lithy.entityData.get(DATA_TRIPPED)).booleanValue()) {
                LivingEntity livingentity = this.lithy.getTarget();
                if (livingentity == null) {
                    return false;
                }
                if (!livingentity.isAlive()) {
                    return false;
                }
                if (!this.followingTargetEvenIfNotSeen) {
                    return !this.lithy.getNavigation().isDone();
                }
                return !this.lithy.isWithinRestriction(livingentity.blockPosition()) ? false : !(livingentity instanceof Player) || !livingentity.isSpectator() && !((Player)livingentity).isCreative();
            }
            return false;
        }

        public void start() {
            this.lithy.getNavigation().moveTo(this.path, this.speedModifier);
            this.lithy.setAggressive(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void stop() {
            LivingEntity livingentity = this.lithy.getTarget();
            if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
                this.lithy.setTarget(null);
            }
            this.lithy.setAggressive(false);
            this.lithy.getNavigation().stop();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity livingentity = this.lithy.getTarget();
            if (livingentity != null) {
                this.lithy.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                if ((this.followingTargetEvenIfNotSeen || this.lithy.getSensing().hasLineOfSight((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.lithy.getRandom().nextFloat() < 0.05f)) {
                    this.pathedTargetX = livingentity.getX();
                    this.pathedTargetY = livingentity.getY();
                    this.pathedTargetZ = livingentity.getZ();
                    this.ticksUntilNextPathRecalculation = 4 + this.lithy.getRandom().nextInt(7);
                    double d0 = this.lithy.distanceToSqr((Entity)livingentity);
                    if (d0 > 1024.0) {
                        this.ticksUntilNextPathRecalculation += 10;
                    } else if (d0 > 256.0) {
                        this.ticksUntilNextPathRecalculation += 5;
                    }
                    if (!this.lithy.getNavigation().moveTo((Entity)livingentity, this.speedModifier)) {
                        this.ticksUntilNextPathRecalculation += 15;
                    }
                    this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
                }
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                this.checkAndPerformAttack(livingentity);
            }
        }

        protected void checkAndPerformAttack(LivingEntity target) {
            if (this.canPerformAttack(target)) {
                this.resetAttackCooldown();
                this.lithy.swing(InteractionHand.MAIN_HAND);
                this.lithy.doHurtTarget((Entity)target);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.adjustedTickDelay(20);
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected boolean canPerformAttack(LivingEntity entity) {
            return this.isTimeToAttack() && this.lithy.isWithinMeleeAttackRange(entity) && this.lithy.getSensing().hasLineOfSight((Entity)entity);
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return this.adjustedTickDelay(20);
        }
    }

    static class LithyFollowMobGoal
    extends Goal {
        private final LithyEntity lithy;
        private final Predicate<Mob> followPredicate;
        @Nullable
        private Mob followingMob;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private float oldWaterCost;
        private final float areaSize;

        public LithyFollowMobGoal(LithyEntity mob, double speedModifier, float stopDistance, float areaSize) {
            this.lithy = mob;
            this.followPredicate = p_25278_ -> p_25278_ != null && ((Object)((Object)mob)).getClass() != p_25278_.getClass();
            this.speedModifier = speedModifier;
            this.navigation = mob.getNavigation();
            this.stopDistance = stopDistance;
            this.areaSize = areaSize;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(mob.getNavigation() instanceof GroundPathNavigation) && !(mob.getNavigation() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
            }
        }

        public boolean canUse() {
            List list;
            if (!((Boolean)this.lithy.entityData.get(DATA_TRIPPED)).booleanValue() && !(list = this.lithy.level().getEntitiesOfClass(Mob.class, this.lithy.getBoundingBox().inflate((double)this.areaSize), this.followPredicate)).isEmpty()) {
                for (Mob mob : list) {
                    if (mob.isInvisible()) continue;
                    this.followingMob = mob;
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.followingMob != null && (Boolean)this.lithy.entityData.get(DATA_TRIPPED) == false && !this.navigation.isDone() && this.lithy.distanceToSqr((Entity)this.followingMob) > (double)(this.stopDistance * this.stopDistance);
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.lithy.getPathfindingMalus(PathType.WATER);
            this.lithy.setPathfindingMalus(PathType.WATER, 0.0f);
        }

        public void stop() {
            this.followingMob = null;
            this.navigation.stop();
            this.lithy.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        }

        public void tick() {
            if (this.followingMob != null && !this.lithy.isLeashed()) {
                this.lithy.getLookControl().setLookAt((Entity)this.followingMob, 10.0f, (float)this.lithy.getMaxHeadXRot());
                if (--this.timeToRecalcPath <= 0) {
                    double d2;
                    double d1;
                    this.timeToRecalcPath = this.adjustedTickDelay(10);
                    double d0 = this.lithy.getX() - this.followingMob.getX();
                    double d3 = d0 * d0 + (d1 = this.lithy.getY() - this.followingMob.getY()) * d1 + (d2 = this.lithy.getZ() - this.followingMob.getZ()) * d2;
                    if (!(d3 <= (double)(this.stopDistance * this.stopDistance))) {
                        this.navigation.moveTo((Entity)this.followingMob, this.speedModifier);
                    } else {
                        this.navigation.stop();
                        LookControl lookcontrol = this.followingMob.getLookControl();
                        if (d3 <= (double)this.stopDistance || lookcontrol.getWantedX() == this.lithy.getX() && lookcontrol.getWantedY() == this.lithy.getY() && lookcontrol.getWantedZ() == this.lithy.getZ()) {
                            double d4 = this.followingMob.getX() - this.lithy.getX();
                            double d5 = this.followingMob.getZ() - this.lithy.getZ();
                            this.navigation.moveTo(this.lithy.getX() - d4, this.lithy.getY(), this.lithy.getZ() - d5, this.speedModifier);
                        }
                    }
                }
            }
        }
    }

    static class LithyFollowPlayerGoal
    extends Goal {
        private final LithyEntity mob;
        private final Predicate<Player> followPredicate;
        @Nullable
        private Player followingMob;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private float oldWaterCost;
        private final float areaSize;

        public LithyFollowPlayerGoal(LithyEntity mob, double speedModifier, float stopDistance, float areaSize) {
            this.mob = mob;
            this.followPredicate = Objects::nonNull;
            this.speedModifier = speedModifier;
            this.navigation = mob.getNavigation();
            this.stopDistance = stopDistance;
            this.areaSize = areaSize;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(mob.getNavigation() instanceof GroundPathNavigation) && !(mob.getNavigation() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowPlayerGoal");
            }
        }

        public boolean canUse() {
            List list;
            if (!((Boolean)this.mob.entityData.get(DATA_TRIPPED)).booleanValue() && !(list = this.mob.level().getEntitiesOfClass(Player.class, this.mob.getBoundingBox().inflate((double)this.areaSize), this.followPredicate)).isEmpty()) {
                for (Player mob : list) {
                    if (mob.isInvisible()) continue;
                    this.followingMob = mob;
                    return true;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.followingMob != null && (Boolean)this.mob.entityData.get(DATA_TRIPPED) == false && !this.navigation.isDone() && this.mob.distanceToSqr((Entity)this.followingMob) > (double)(this.stopDistance * this.stopDistance);
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.mob.getPathfindingMalus(PathType.WATER);
            this.mob.setPathfindingMalus(PathType.WATER, 0.0f);
        }

        public void stop() {
            this.followingMob = null;
            this.navigation.stop();
            this.mob.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        }

        public void tick() {
            if (this.followingMob != null && !this.mob.isLeashed()) {
                this.mob.getLookControl().setLookAt((Entity)this.followingMob, 10.0f, (float)this.mob.getMaxHeadXRot());
                if (--this.timeToRecalcPath <= 0) {
                    double d2;
                    double d1;
                    this.timeToRecalcPath = this.adjustedTickDelay(10);
                    double d0 = this.mob.getX() - this.followingMob.getX();
                    double d3 = d0 * d0 + (d1 = this.mob.getY() - this.followingMob.getY()) * d1 + (d2 = this.mob.getZ() - this.followingMob.getZ()) * d2;
                    if (!(d3 <= (double)(this.stopDistance * this.stopDistance))) {
                        this.navigation.moveTo((Entity)this.followingMob, this.speedModifier);
                    } else {
                        this.navigation.stop();
                    }
                }
            }
        }
    }
}

