/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.google.common.collect.ImmutableList;
import com.jamiedev.bygone.common.block.AmaranthCropBlock;
import com.jamiedev.bygone.common.block.PlagaCropBlock;
import com.jamiedev.bygone.common.entity.BigBeakEntity;
import com.jamiedev.bygone.common.entity.NectaurEntity;
import com.jamiedev.bygone.common.entity.ai.AvoidBlockGoal;
import com.jamiedev.bygone.common.entity.ai.EatCropGoal;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class PestEntity
extends Animal {
    Spider ref1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super PestEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ITEMS, (Object)SensorType.HURT_BY, (Object)SensorType.PIGLIN_SPECIFIC_SENSOR);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.ATE_RECENTLY, (Object)MemoryModuleType.NEAREST_REPELLENT);
    private int moreCropTicks;
    private int eatAnimationTick;
    private EatCropGoal eatBlockGoal;
    Rabbit ref;

    public PestEntity(EntityType<? extends PestEntity> entityType, Level level) {
        super(BGEntityTypes.PEST.get(), level);
        this.setSpeedModifier(0.1f);
    }

    public void setSpeedModifier(double speedModifier) {
        this.getNavigation().setSpeedModifier(speedModifier);
        this.moveControl.setWantedPosition(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ(), speedModifier);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.STEP_HEIGHT, 3.0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("MoreCropTicks", this.moreCropTicks);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.moreCropTicks = compound.getInt("MoreCropTicks");
    }

    protected void registerGoals() {
        this.eatBlockGoal = new EatCropGoal((Mob)this);
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.level()));
        this.goalSelector.addGoal(3, (Goal)new AvoidBlockGoal((PathfinderMob)this, 16.0f, 1.4, 2.6, pos -> {
            BlockState state = this.level().getBlockState(pos);
            return state.is(JamiesModTag.PEST_REPELLENTS);
        }));
        this.goalSelector.addGoal(3, (Goal)new AvoidBlockGoal((PathfinderMob)this, 8.0f, 1.2, 2.1, pos -> {
            BlockState state = this.level().getBlockState(pos);
            if (state.is(BGBlocks.PLAGA_CROP.get())) {
                return (Integer)state.getValue((Property)PlagaCropBlock.AGE) > 5;
            }
            return false;
        }));
        this.goalSelector.addGoal(3, (Goal)new AvoidBlockGoal((PathfinderMob)this, 4.0f, 1.2, 2.1, pos -> {
            BlockState state = this.level().getBlockState(pos);
            if (state.is(BGBlocks.PLAGA_CROP.get())) {
                return (Integer)state.getValue((Property)PlagaCropBlock.AGE) < 5;
            }
            return false;
        }));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 0.8));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, p_335873_ -> p_335873_.is(ItemTags.ARMOR_ENCHANTABLE), false));
        this.goalSelector.addGoal(4, new PestAvoidEntityGoal<NectaurEntity>(this, NectaurEntity.class, 4.0f, 1.1, 1.5));
        this.goalSelector.addGoal(4, new PestAvoidEntityGoal<Player>(this, Player.class, 8.0f, 1.2, 2.3));
        this.goalSelector.addGoal(4, new PestAvoidEntityGoal<BigBeakEntity>(this, BigBeakEntity.class, 16.0f, 0.8, 1.12));
        this.goalSelector.addGoal(5, (Goal)this.eatBlockGoal);
        this.goalSelector.addGoal(5, (Goal)new RaidGardenGoal(this));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 10));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    protected void customServerAiStep() {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.customServerAiStep();
        if (this.moreCropTicks > 0) {
            this.moreCropTicks -= this.random.nextInt(3);
            if (this.moreCropTicks < 0) {
                this.moreCropTicks = 0;
            }
        }
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.aiStep();
    }

    protected Brain.Provider<PestEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected void doPush(Entity entity) {
        if (entity instanceof Enemy && !(entity instanceof Creeper) && this.getRandom().nextInt(20) == 0) {
            this.setTarget((LivingEntity)entity);
        }
        super.doPush(entity);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.VILLAGER_PLANTABLE_SEEDS);
    }

    @Nullable
    public PestEntity getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return (PestEntity)BGEntityTypes.PEST.get().create((Level)level);
    }

    boolean wantsMoreFood() {
        return true;
    }

    public void ate() {
        super.ate();
        if (this.isBaby()) {
            this.ageUp(60);
        }
    }

    static class PestAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        public PestAvoidEntityGoal(PestEntity pest, Class<T> entityClassToAvoid, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super((PathfinderMob)pest, entityClassToAvoid, maxDist, walkSpeedModifier, sprintSpeedModifier);
        }

        public boolean canUse() {
            return super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse();
        }
    }

    static class RaidGardenGoal
    extends MoveToBlockGoal {
        private final PestEntity pest;
        private boolean wantsToRaid;
        private boolean canRaid;

        public RaidGardenGoal(PestEntity pest) {
            super((PathfinderMob)pest, (double)0.7f, 64);
            this.pest = pest;
        }

        public boolean canUse() {
            if (this.nextStartTick <= 0) {
                this.canRaid = true;
                this.wantsToRaid = this.pest.wantsMoreFood();
            }
            return super.canUse();
        }

        public boolean canContinueToUse() {
            return this.canRaid && super.canContinueToUse();
        }

        public void tick() {
            super.tick();
            this.pest.getLookControl().setLookAt((double)this.blockPos.getX() + 0.5, (double)(this.blockPos.getY() + 1), (double)this.blockPos.getZ() + 0.5, 10.0f, (float)this.pest.getMaxHeadXRot());
            if (this.isReachedTarget()) {
                int i;
                Level level = this.pest.level();
                BlockPos blockpos = this.blockPos.above();
                BlockState blockstate = level.getBlockState(blockpos);
                Block block = blockstate.getBlock();
                if (this.canRaid && block instanceof CropBlock) {
                    i = (Integer)blockstate.getValue((Property)CropBlock.AGE);
                    if (i == 0) {
                        level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 2);
                        level.destroyBlock(blockpos, true, (Entity)this.pest);
                    } else {
                        level.setBlock(blockpos, (BlockState)blockstate.setValue((Property)CropBlock.AGE, (Comparable)Integer.valueOf(i - 1)), 2);
                        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)this.pest));
                        level.levelEvent(2001, blockpos, Block.getId((BlockState)blockstate));
                    }
                    this.pest.moreCropTicks = 40;
                }
                if (this.canRaid && block instanceof AmaranthCropBlock) {
                    i = (Integer)blockstate.getValue((Property)AmaranthCropBlock.AGE);
                    if (i == 0) {
                        level.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 2);
                        level.destroyBlock(blockpos, true, (Entity)this.pest);
                    } else {
                        level.setBlock(blockpos, (BlockState)blockstate.setValue((Property)AmaranthCropBlock.AGE, (Comparable)Integer.valueOf(i - 1)), 2);
                        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)this.pest));
                        level.levelEvent(2001, blockpos, Block.getId((BlockState)blockstate));
                    }
                    this.pest.moreCropTicks = 40;
                }
                this.canRaid = false;
                this.nextStartTick = 10;
            }
        }

        protected boolean isValidTarget(LevelReader level, BlockPos pos) {
            BlockState blockstate = level.getBlockState(pos);
            if (blockstate.is(Blocks.FARMLAND) && this.wantsToRaid && !this.canRaid && ((blockstate = level.getBlockState(pos.above())).getBlock() instanceof CropBlock || blockstate.getBlock() instanceof AmaranthCropBlock && ((AmaranthCropBlock)blockstate.getBlock()).isMaxAge(blockstate))) {
                this.canRaid = true;
                return true;
            }
            return false;
        }
    }
}

