/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import java.util.EnumSet;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WraithEntity
extends Monster
implements RangedAttackMob,
FlyingAnimal {
    private static final EntityDataAccessor<Byte> DATA_SPELL_CASTING_ID;
    private static final EntityDataAccessor<Boolean> DATA_PREPARE_TELEPORT;
    Stray ref;
    protected int withinRangeToTeleportTick = 0;
    protected int spellCastingTickCount;
    protected BlockPos targetSavedPos = BlockPos.ZERO;
    protected boolean updatedTargetSavedPos = false;
    private WraithSpell currentSpell;
    public static final int TICKS_PER_FLAP;
    public AnimationState floatAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState meleeAnimationState = new AnimationState();
    public AnimationState spellAnimationState = new AnimationState();

    public WraithEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 5;
        this.moveControl = new FlyingMoveControl((Mob)this, 35, false);
        this.setNoGravity(true);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
        this.currentSpell = WraithSpell.NONE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FLYING_SPEED, 0.9).add(Attributes.FOLLOW_RANGE, 18.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.8).add(Attributes.MAX_HEALTH, 32.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SpellcasterCastingSpellGoal());
        this.goalSelector.addGoal(2, (Goal)new WraithIceBouquetSquareSpellGoal());
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.goalSelector.addGoal(8, (Goal)new WraithWanderGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{WraithEntity.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation(this, (Mob)this, level){

            public boolean isStableDestination(BlockPos p_27947_) {
                return this.level.getBlockState(p_27947_).isAir();
            }

            public void tick() {
                super.tick();
            }
        };
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public boolean isFreezing() {
        return false;
    }

    public boolean canFreeze() {
        return false;
    }

    public boolean fireImmune() {
        return true;
    }

    public void performRangedAttack(LivingEntity livingEntity, float v) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_SPELL_CASTING_ID, (Object)0);
        builder.define(DATA_PREPARE_TELEPORT, (Object)false);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.spellCastingTickCount = compound.getInt("SpellTicks");
        if (compound.contains("TargetPosX") && compound.contains("TargetPosY") && compound.contains("TargetPosZ")) {
            this.targetSavedPos = new BlockPos(compound.getInt("TargetPosX"), compound.getInt("TargetPosY"), compound.getInt("TargetPosZ"));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("SpellTicks", this.spellCastingTickCount);
        if (this.targetSavedPos != BlockPos.ZERO) {
            compound.putInt("TargetPosX", this.targetSavedPos.getX());
            compound.putInt("TargetPosY", this.targetSavedPos.getY());
            compound.putInt("TargetPosZ", this.targetSavedPos.getZ());
        }
    }

    protected SoundEvent getAmbientSound() {
        return BGSoundEvents.WRAITH_AMBIENT_ADDITIONS_EVENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return BGSoundEvents.WRAITH_HURT_ADDITIONS_EVENT;
    }

    protected SoundEvent getDeathSound() {
        return BGSoundEvents.WRAITH_DEATH_ADDITIONS_EVENT;
    }

    public void playAttackSound() {
        this.playSound(BGSoundEvents.WRAITH_ATTACK_ADDITIONS_EVENT, 1.0f, 1.0f);
    }

    SoundEvent getStepSound() {
        return BGSoundEvents.WRAITH_FLY_ADDITIONS_EVENT;
    }

    public boolean isCastingSpell() {
        return this.level().isClientSide ? (Byte)this.entityData.get(DATA_SPELL_CASTING_ID) > 0 : this.spellCastingTickCount > 0;
    }

    public void setIsCastingSpell(WraithSpell currentSpell) {
        this.currentSpell = currentSpell;
        this.entityData.set(DATA_SPELL_CASTING_ID, (Object)((byte)currentSpell.id));
    }

    protected WraithSpell getCurrentSpell() {
        return !this.level().isClientSide ? this.currentSpell : WraithSpell.byId(((Byte)this.entityData.get(DATA_SPELL_CASTING_ID)).byteValue());
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.spellCastingTickCount > 0) {
            --this.spellCastingTickCount;
            if (this.spellCastingTickCount == 0) {
                this.setIsCastingSpell(WraithSpell.NONE);
            }
        }
    }

    private void setupAnimationStates() {
        this.idleAnimationState.startIfStopped(this.tickCount);
        if (this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7) {
            this.floatAnimationState.startIfStopped(this.tickCount);
        } else {
            this.floatAnimationState.stop();
        }
        if (this.isCastingSpell()) {
            this.spellAnimationState.startIfStopped(this.tickCount);
        } else if (this.attackAnim > 0.0f) {
            this.meleeAnimationState.start(this.tickCount);
        } else if (this.attackAnim == 0.0f) {
            this.meleeAnimationState.stop();
        }
    }

    public void tick() {
        this.setNoGravity(true);
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.level().isClientSide && this.isCastingSpell()) {
            WraithSpell spell = this.getCurrentSpell();
            float f = (float)spell.spellColor[0];
            float f1 = (float)spell.spellColor[1];
            float f2 = (float)spell.spellColor[2];
            float f3 = this.yBodyRot * ((float)Math.PI / 180) + Mth.cos((float)((float)this.tickCount * 0.6662f)) * 0.25f;
            float f4 = Mth.cos((float)f3);
            float f5 = Mth.sin((float)f3);
            double d0 = 0.6 * (double)this.getScale();
            double d1 = 1.8 * (double)this.getScale();
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)f, (float)f1, (float)f2), this.getX() + (double)f4 * d0, this.getY() + d1, this.getZ() + (double)f5 * d0, 0.0, 0.0, 0.0);
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)f, (float)f1, (float)f2), this.getX() - (double)f4 * d0, this.getY() + d1, this.getZ() - (double)f5 * d0, 0.0, 0.0, 0.0);
        }
        if (this.getTarget() != null) {
            if (this.distanceTo((Entity)this.getTarget()) < 6.0f && !((Boolean)this.entityData.get(DATA_PREPARE_TELEPORT)).booleanValue()) {
                this.entityData.set(DATA_PREPARE_TELEPORT, (Object)true);
                this.withinRangeToTeleportTick = 0;
            }
            if (((Boolean)this.entityData.get(DATA_PREPARE_TELEPORT)).booleanValue()) {
                ++this.withinRangeToTeleportTick;
                if (this.withinRangeToTeleportTick > 60) {
                    LivingEntity target = this.getTarget();
                    BlockPos targetOnPos = target.getOnPos();
                    RandomSource random = this.random;
                    for (int check = 0; check < 10; ++check) {
                        int x = targetOnPos.getX();
                        x = random.nextBoolean() ? (x -= random.nextInt(7, 11)) : (x += random.nextInt(7, 11));
                        int z = targetOnPos.getZ();
                        z = random.nextBoolean() ? (z -= random.nextInt(7, 11)) : (z += random.nextInt(7, 11));
                        int y = targetOnPos.getY();
                        BlockPos groundPos = new BlockPos(x, y, z);
                        if (this.level().getBlockState(groundPos).isFaceSturdy((BlockGetter)this.level(), groundPos, Direction.DOWN) && this.level().getBlockState(groundPos.above()).isAir() && this.level().getBlockState(groundPos.above().above()).isAir()) {
                            this.teleportTo(x, y + 1, z);
                            break;
                        }
                        boolean teleported = false;
                        for (int checkY = -4; checkY <= 4; ++checkY) {
                            BlockPos newGroundPos = groundPos.offset(0, checkY, 0);
                            if (!this.level().getBlockState(newGroundPos).isFaceSturdy((BlockGetter)this.level(), newGroundPos, Direction.DOWN) || !this.level().getBlockState(newGroundPos.above()).isAir() || !this.level().getBlockState(newGroundPos.above().above()).isAir()) continue;
                            target.teleportTo((double)x, (double)(y + 1), (double)z);
                            this.level().playSound(null, this.xo, this.yo, this.zo, BGSoundEvents.WRAITH_TELEPORT_ADDITIONS_EVENT, this.getSoundSource(), 1.0f, 1.0f);
                            this.playSound(BGSoundEvents.WRAITH_TELEPORT_ADDITIONS_EVENT, 1.0f, 1.0f);
                            teleported = true;
                            break;
                        }
                        if (teleported) break;
                    }
                    this.entityData.set(DATA_PREPARE_TELEPORT, (Object)false);
                }
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypeTags.IS_FREEZING)) {
            return super.hurt(source, 0.0f);
        }
        if (source.isDirect()) {
            this.withinRangeToTeleportTick = Math.max(this.withinRangeToTeleportTick - 10, 0);
        }
        if (source.is(DamageTypes.IN_FIRE)) {
            return super.hurt(source, 0.0f);
        }
        if (source.is(DamageTypes.ON_FIRE)) {
            return super.hurt(source, 0.0f);
        }
        return super.hurt(source, amount);
    }

    public void knockback(double strength, double x, double z) {
        super.knockback(strength, x, z);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public boolean isFlapping() {
        return this.isFlying() && this.tickCount % TICKS_PER_FLAP == 0;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public void travel(Vec3 travelVector) {
        if (this.isControlledByLocalInstance()) {
            super.travel(travelVector);
        }
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    protected int getSpellCastingTime() {
        return this.spellCastingTickCount;
    }

    protected SoundEvent getCastingSoundEvent() {
        return BGSoundEvents.WRAITH_ATTACK_ADDITIONS_EVENT;
    }

    static {
        TICKS_PER_FLAP = Mth.ceil((float)1.4959966f);
        DATA_SPELL_CASTING_ID = SynchedEntityData.defineId(WraithEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
        DATA_PREPARE_TELEPORT = SynchedEntityData.defineId(WraithEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    }

    protected static enum WraithSpell {
        NONE(0, 0.0, 0.0, 0.0),
        TELEPORT(1, 0.7, 0.7, 0.8),
        FIRE(2, 0.4, 0.3, 0.35),
        NOVELTY(3, 0.7, 0.5, 0.2),
        DISAPPEAR(4, 0.3, 0.3, 0.8),
        PUKE(5, 0.1, 0.1, 0.2);

        private static final IntFunction<WraithSpell> BY_ID;
        final int id;
        final double[] spellColor;

        private WraithSpell(int id, double red, double green, double blue) {
            this.id = id;
            this.spellColor = new double[]{red, green, blue};
        }

        public static WraithSpell byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = ByIdMap.continuous(p_263091_ -> p_263091_.id, (Object[])WraithSpell.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    protected class SpellcasterCastingSpellGoal
    extends Goal {
        public SpellcasterCastingSpellGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return WraithEntity.this.getSpellCastingTime() > 0;
        }

        public void start() {
            super.start();
            WraithEntity.this.navigation.stop();
        }

        public void stop() {
            super.stop();
            WraithEntity.this.setIsCastingSpell(WraithSpell.NONE);
        }

        public void tick() {
            if (WraithEntity.this.getTarget() != null) {
                WraithEntity.this.getLookControl().setLookAt((Entity)WraithEntity.this.getTarget(), (float)WraithEntity.this.getMaxHeadYRot(), (float)WraithEntity.this.getMaxHeadXRot());
            }
        }
    }

    class WraithIceBouquetSquareSpellGoal
    extends SpellcasterUseSpellGoal {
        WraithIceBouquetSquareSpellGoal() {
        }

        @Override
        protected void performSpellCasting() {
            LivingEntity living = WraithEntity.this.getTarget();
            Level level = WraithEntity.this.level();
            if (WraithEntity.this.targetSavedPos != BlockPos.ZERO) {
                BlockPos targetPos = WraithEntity.this.targetSavedPos.above();
                for (int checkZ = -1; checkZ <= 1; ++checkZ) {
                    block1: for (int checkX = -1; checkX <= 1; ++checkX) {
                        if (level.getBlockState(targetPos.offset(checkX, 0, checkZ)).isAir() && level.getBlockState(targetPos.offset(checkX, 0, checkZ).below()).isFaceSturdy((BlockGetter)level, targetPos.offset(checkX, 0, checkZ).below(), Direction.UP)) {
                            WraithEntity.this.level().setBlockAndUpdate(targetPos.offset(checkX, 0, checkZ), BGBlocks.ICE_BOUQUET.get().defaultBlockState());
                            continue;
                        }
                        for (int checkY = -2; checkY <= 2; ++checkY) {
                            BlockPos newYPos = new BlockPos(targetPos.getX() + checkX, targetPos.getY() + checkY, targetPos.getZ() + checkZ);
                            if (!level.getBlockState(newYPos).isAir() || !level.getBlockState(newYPos.below()).isFaceSturdy((BlockGetter)level, newYPos.below(), Direction.UP)) continue;
                            WraithEntity.this.level().setBlockAndUpdate(newYPos, BGBlocks.ICE_BOUQUET.get().defaultBlockState());
                            continue block1;
                        }
                    }
                }
            }
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }

        @Override
        public void start() {
            super.start();
            WraithEntity.this.targetSavedPos = WraithEntity.this.getTarget().getOnPos();
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return null;
        }

        @Override
        protected WraithSpell getSpell() {
            return WraithSpell.FIRE;
        }
    }

    static class WraithWanderGoal
    extends WaterAvoidingRandomFlyingGoal {
        public WraithWanderGoal(PathfinderMob mob, double speed) {
            super(mob, speed);
        }

        @javax.annotation.Nullable
        protected Vec3 getPosition() {
            RandomSource random = this.mob.getRandom();
            Level level = this.mob.level();
            BlockPos mobPos = this.mob.blockPosition();
            for (int i = 0; i < 10; ++i) {
                BlockState checkState;
                int dx = Mth.nextInt((RandomSource)random, (int)-10, (int)10);
                int dy = Mth.nextInt((RandomSource)random, (int)-12, (int)13);
                int dz = Mth.nextInt((RandomSource)random, (int)-10, (int)10);
                BlockPos candidate = mobPos.offset(dx, dy, dz);
                BlockPos ground = candidate.below();
                BlockState state = level.getBlockState(ground);
                for (int checkGround = 1; checkGround <= 2 && (checkState = level.getBlockState(new BlockPos(ground.getX(), ground.getY() + checkGround, ground.getZ()))).isAir(); ++checkGround) {
                }
                if (!state.isFaceSturdy((BlockGetter)level, ground, Direction.DOWN) || state.isAir() || !level.isEmptyBlock(candidate) || !level.isEmptyBlock(candidate.above())) continue;
                return Vec3.atCenterOf((Vec3i)candidate);
            }
            return null;
        }
    }

    protected abstract class SpellcasterUseSpellGoal
    extends Goal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        protected SpellcasterUseSpellGoal() {
        }

        public boolean canUse() {
            LivingEntity livingentity = WraithEntity.this.getTarget();
            if (livingentity != null && livingentity.isAlive()) {
                return !WraithEntity.this.isCastingSpell() && WraithEntity.this.tickCount >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean canContinueToUse() {
            LivingEntity livingentity = WraithEntity.this.getTarget();
            return livingentity != null && livingentity.isAlive() && this.attackWarmupDelay > 0;
        }

        public void start() {
            this.attackWarmupDelay = this.adjustedTickDelay(this.getCastWarmupTime());
            WraithEntity.this.spellCastingTickCount = this.getCastingTime();
            this.nextAttackTickCount = WraithEntity.this.tickCount + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                WraithEntity.this.playSound(soundevent, 1.0f, 1.0f);
            }
            WraithEntity.this.setIsCastingSpell(this.getSpell());
        }

        public void tick() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
                WraithEntity.this.playSound(WraithEntity.this.getCastingSoundEvent(), 1.0f, 1.0f);
            }
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();

        @javax.annotation.Nullable
        protected abstract SoundEvent getSpellPrepareSound();

        protected abstract WraithSpell getSpell();
    }
}

