/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.ai;

import com.jamiedev.bygone.common.entity.FungalParentEntity;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;

public class FollowFungalParentGoal
extends Goal {
    public static final int HORIZONTAL_CHECK_RANGE = 8;
    public static final int VERTICAL_CHECK_RANGE = 4;
    public static final int MIN_DISTANCE = 3;
    private final FungalParentEntity animal;
    @Nullable
    private FungalParentEntity parent;
    private final double speed;
    private int delay;

    public FollowFungalParentGoal(FungalParentEntity animal, double speed) {
        this.animal = animal;
        this.speed = speed;
    }

    public boolean canUse() {
        if (this.animal.getAge() >= 0) {
            return false;
        }
        List list = this.animal.level().getEntitiesOfClass(((Object)((Object)this.animal)).getClass(), this.animal.getBoundingBox().inflate(8.0, 4.0, 8.0));
        FungalParentEntity animalEntity = null;
        double d = Double.MAX_VALUE;
        for (FungalParentEntity animalEntity2 : list) {
            double e;
            if (animalEntity2.getAge() < 0 || (e = this.animal.distanceToSqr((Entity)animalEntity2)) > d) continue;
            d = e;
            animalEntity = animalEntity2;
        }
        if (animalEntity == null) {
            return false;
        }
        if (d < 9.0) {
            return false;
        }
        this.parent = animalEntity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.animal.getAge() >= 0) {
            return false;
        }
        if (!this.parent.isAlive()) {
            return false;
        }
        double d = this.animal.distanceToSqr((Entity)this.parent);
        return !(d < 9.0) && !(d > 256.0);
    }

    public void start() {
        this.delay = 0;
    }

    public void stop() {
        this.parent = null;
    }

    public void tick() {
        if (--this.delay <= 0) {
            this.delay = this.adjustedTickDelay(10);
            this.animal.getNavigation().moveTo((Entity)this.parent, this.speed);
        }
    }
}

