/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.jamiedev.bygone.common.entity.NectaurEntity;
import com.jamiedev.bygone.common.entity.ai.behavior.NectaurFollowLeader;
import com.jamiedev.bygone.common.entity.ai.behavior.NectaurJoinGroup;
import com.jamiedev.bygone.common.entity.ai.behavior.NectaurRangeAttack;
import com.jamiedev.bygone.common.entity.ai.behavior.NectaurSetWalkTargetFromAttackTargetIfTargetOutOfReach;
import com.jamiedev.bygone.common.entity.ai.behavior.NectaurStalk;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.jamiedev.bygone.core.registry.BGMemoryModuleTypes;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.schedule.Activity;

public class NectaurBrain {
    public static Brain<?> create(NectaurEntity nectaur, Brain<NectaurEntity> brain) {
        NectaurBrain.initCoreActivity(nectaur, brain);
        NectaurBrain.initFightActivity(nectaur, brain);
        NectaurBrain.initIdleActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initFightActivity(NectaurEntity nectaur, Brain<NectaurEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 0, ImmutableList.of(NectaurStalk.create(entity -> {
            if (!(entity instanceof NectaurEntity)) {
                return Float.valueOf(0.0f);
            }
            NectaurEntity nectaurEntity = (NectaurEntity)((Object)entity);
            Optional leaderMemory = nectaurEntity.getBrain().getMemory(BGMemoryModuleTypes.GROUP_LEADER);
            return Float.valueOf(leaderMemory.isPresent() && ((UUID)leaderMemory.get()).equals(nectaurEntity.getUUID()) ? 0.75f : 0.0f);
        }, 6, 16), (Object)StopAttackingIfTargetInvalid.create(target -> !NectaurBrain.isNearestValidAttackTarget(nectaur, target) && !nectaur.isBaby()), (Object)BehaviorBuilder.triggerIf(entity -> entity.getBrain().checkMemory(BGMemoryModuleTypes.IS_IN_GROUP, MemoryStatus.VALUE_ABSENT), (OneShot)BackUpIfTooClose.create((int)4, (float)1.4f)), (Object)BehaviorBuilder.triggerIf(entity -> entity.getBrain().checkMemory(BGMemoryModuleTypes.IS_IN_GROUP, MemoryStatus.VALUE_PRESENT) && (!entity.getBrain().hasMemoryValue(BGMemoryModuleTypes.GROUP_LEADER) || !entity.getUUID().equals(entity.getBrain().getMemory(BGMemoryModuleTypes.GROUP_LEADER).orElse(null))), (OneShot)BackUpIfTooClose.create((int)12, (float)1.3f)), NectaurSetWalkTargetFromAttackTargetIfTargetOutOfReach.create(1.0f, 4), new NectaurRangeAttack()), MemoryModuleType.ATTACK_TARGET);
    }

    private static boolean isNearestValidAttackTarget(NectaurEntity nectaur, LivingEntity target) {
        return NectaurBrain.findNearestValidAttackTarget(nectaur).filter(p_34887_ -> p_34887_ == target).isPresent();
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(NectaurEntity nectaur) {
        Brain<NectaurEntity> brain = nectaur.getBrain();
        Optional optional = BehaviorUtils.getLivingEntityFromUUIDMemory((LivingEntity)nectaur, (MemoryModuleType)MemoryModuleType.ANGRY_AT);
        if (optional.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight((LivingEntity)nectaur, (LivingEntity)((LivingEntity)optional.get()))) {
            return optional;
        }
        Optional optional3 = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional optional2 = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
        return optional2.isPresent() && Sensor.isEntityAttackable((LivingEntity)nectaur, (LivingEntity)((LivingEntity)optional2.get())) ? optional2 : Optional.empty();
    }

    private static void initCoreActivity(NectaurEntity nectaur, Brain<NectaurEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)StopBeingAngryIfTargetDead.create()));
    }

    private static void initIdleActivity(Brain<NectaurEntity> brain) {
        brain.addActivity(Activity.IDLE, 10, ImmutableList.of((Object)((Object)new NectaurFollowLeader()), (Object)StartAttacking.create(LivingEntity::isAlive, NectaurBrain::findNearestValidAttackTarget), (Object)((Object)new NectaurJoinGroup()), NectaurBrain.createIdleLookBehaviors(), NectaurBrain.createIdleMovementBehaviors()));
    }

    public static void updateActivity(NectaurEntity nectaur) {
        Brain<NectaurEntity> brain = nectaur.getBrain();
        Activity activity = brain.getActiveNonCoreActivity().orElse(null);
        brain.setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
        Activity activity1 = brain.getActiveNonCoreActivity().orElse(null);
        nectaur.setAggressive(brain.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
    }

    private static RunOne<NectaurEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.6f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static ImmutableList<Pair<OneShot<LivingEntity>, Integer>> createLookBehaviors() {
        return ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create(BGEntityTypes.NECTAUR.get(), (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((float)8.0f), (Object)1));
    }

    private static RunOne<LivingEntity> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.builder().addAll(NectaurBrain.createLookBehaviors()).add((Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)).build());
    }
}

