/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.ai.goal;

import com.jamiedev.bygone.common.item.MaliciousWarHornItem;
import com.jamiedev.bygone.core.registry.BGDataComponents;
import com.jamiedev.bygone.core.registry.BGItems;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WarHornVexTargetGoal
extends NearestAttackableTargetGoal<Monster> {
    private final Vex vex;
    private boolean warHornVexChecked = false;
    private boolean isWarHornVexCached = false;

    public WarHornVexTargetGoal(Vex vex) {
        super((Mob)vex, Monster.class, 10, true, false, target -> target != vex && !(target instanceof Vex));
        this.vex = vex;
    }

    public boolean canUse() {
        if (!this.isWarHornVex()) {
            return false;
        }
        if (this.vex.getTarget() instanceof Player) {
            this.vex.setTarget(null);
            return false;
        }
        return super.canUse();
    }

    public boolean isWarHornVex() {
        if (this.warHornVexChecked) {
            return this.isWarHornVexCached;
        }
        Level level = this.vex.level();
        if (!(level instanceof ServerLevel)) {
            this.warHornVexChecked = true;
            this.isWarHornVexCached = false;
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (ServerPlayer player : serverLevel.getServer().getPlayerList().getPlayers()) {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                MaliciousWarHornItem.WarHornData data;
                ItemStack stack = player.getInventory().getItem(i);
                if (stack.getItem() != BGItems.MALICIOUS_WAR_HORN.get() || !(data = (MaliciousWarHornItem.WarHornData)stack.getOrDefault((DataComponentType)BGDataComponents.WAR_HORN_DATA.value(), (Object)MaliciousWarHornItem.WarHornData.EMPTY)).activeVexes().contains(this.vex.getUUID())) continue;
                this.warHornVexChecked = true;
                this.isWarHornVexCached = true;
                return true;
            }
        }
        this.warHornVexChecked = true;
        this.isWarHornVexCached = false;
        return false;
    }
}

