/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.projectile;

import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.jamiedev.bygone.core.registry.BGItems;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HookEntity
extends AbstractArrow {
    FishingHook ref;
    @javax.annotation.Nullable
    private BlockState lastState;
    private SoundEvent soundEvent;

    public HookEntity(EntityType<? extends HookEntity> entityType, Level pLevel) {
        super(entityType, pLevel);
        this.noCulling = true;
        this.soundEvent = this.getDefaultHitGroundSoundEvent();
    }

    public HookEntity(Level level, Player player) {
        super(BGEntityTypes.HOOK.get(), level);
        this.setOwner((Entity)player);
        this.setPosRaw(player.getX(), player.getEyeY() - 0.1, player.getZ());
        this.soundEvent = this.getDefaultHitGroundSoundEvent();
    }

    protected ItemStack getDefaultPickupItem() {
        return BGItems.HOOK.get().getDefaultInstance();
    }

    public void setOwner(@Nullable Entity entity) {
        super.setOwner(entity);
        this.pickup = AbstractArrow.Pickup.DISALLOWED;
    }

    @Nullable
    public Player getPlayerOwner() {
        Entity entity = this.getOwner();
        return entity instanceof Player ? (Player)entity : null;
    }

    public void tick() {
        super.tick();
        Player player = this.getPlayerOwner();
        if (!this.level().isClientSide) {
            if (player == null || this.shouldRetract(player)) {
                this.discard();
            }
            if (!this.level().getFluidState(new BlockPos(this.getBlockX(), this.getBlockY(), this.getBlockZ())).isEmpty()) {
                this.discard();
            }
            if (player != null && player.isShiftKeyDown()) {
                this.discard();
            }
        }
    }

    private boolean shouldRetract(Player player) {
        return player.isRemoved() || !player.isAlive() || !player.isHolding(BGItems.HOOK.get()) || this.distanceTo((Entity)player) > 64.0f;
    }

    public boolean canUsePortal(boolean allowVehicles) {
        return false;
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return BGSoundEvents.HOOK_HIT_ADDITIONS_EVENT;
    }

    public boolean isInWall() {
        if (this.noPhysics) {
            return false;
        }
        float f = this.getDimensions(this.getPose()).width() * 0.8f;
        AABB box = AABB.ofSize((Vec3)this.getEyePosition(), (double)f, (double)1.0E-6, (double)f);
        return BlockPos.betweenClosedStream((AABB)box).anyMatch(pos -> {
            BlockState blockState = this.level().getBlockState(pos);
            return !blockState.isAir() && Shapes.joinIsNotEmpty((VoxelShape)blockState.getCollisionShape((BlockGetter)this.level(), pos).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (VoxelShape)Shapes.create((AABB)box), (BooleanOp)BooleanOp.AND);
        });
    }
}

