/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity.projectile;

import com.google.common.base.MoreObjects;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.jamiedev.bygone.core.registry.BGItems;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ScuttleSpikeEntity
extends AbstractArrow {
    private boolean dealtDamage;

    public ScuttleSpikeEntity(EntityType<? extends ScuttleSpikeEntity> entityType, Level world) {
        super(entityType, world);
    }

    public ScuttleSpikeEntity(Level world, LivingEntity owner, ItemStack stack) {
        super(BGEntityTypes.SCUTTLE_SPIKE.get(), owner, world, stack, null);
    }

    public ScuttleSpikeEntity(Level world, double x, double y, double z, ItemStack stack) {
        super(BGEntityTypes.SCUTTLE_SPIKE.get(), x, y, z, world, stack, stack);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        if (this.inGroundTime > 8) {
            this.kill();
        }
        super.tick();
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 currentPosition, Vec3 nextPosition) {
        return this.dealtDamage ? null : super.findHitEntity(currentPosition, nextPosition);
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        ServerLevel serverWorld;
        Entity entity = entityHitResult.getEntity();
        float f = 8.0f;
        Entity entity2 = this.getOwner();
        DamageSource damageSource = this.damageSources().trident((Entity)this, (Entity)(entity2 == null ? this : entity2));
        Level var7 = this.level();
        if (var7 instanceof ServerLevel) {
            serverWorld = (ServerLevel)var7;
            f = EnchantmentHelper.modifyDamage((ServerLevel)serverWorld, (ItemStack)Objects.requireNonNull(this.getWeaponItem()), (Entity)entity, (DamageSource)damageSource, (float)f);
        }
        this.dealtDamage = true;
        if (entity.hurt(damageSource, f)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            var7 = this.level();
            if (var7 instanceof ServerLevel) {
                serverWorld = (ServerLevel)var7;
                serverWorld = (ServerLevel)var7;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverWorld, (Entity)entity, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.doKnockback(livingEntity, damageSource);
                this.doPostHurtEffects(livingEntity);
                livingEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200), (Entity)MoreObjects.firstNonNull((Object)entity2, (Object)((Object)this)));
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(SoundEvents.GLOW_INK_SAC_USE, 1.0f, 1.0f);
    }

    protected void hitBlockEnchantmentEffects(ServerLevel world, BlockHitResult blockHitResult, ItemStack weaponStack) {
        this.kill();
    }

    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }

    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)BGItems.SCUTTLE_SPIKE.get());
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public void playerTouch(Player player) {
        if (this.ownedBy((Entity)player) || this.getOwner() == null) {
            super.playerTouch(player);
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.dealtDamage = nbt.getBoolean("DealtDamage");
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("DealtDamage", this.dealtDamage);
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double cameraX, double cameraY, double cameraZ) {
        return true;
    }
}

