/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.item;

import com.jamiedev.bygone.common.item.BaitwormWaterEffect;
import com.jamiedev.bygone.core.registry.BGBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BucketOBaitwormsItem
extends Item {
    private static final int EFFECT_RADIUS = 5;
    private static final int EFFECT_DURATION = 1200;

    public BucketOBaitwormsItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult hitResult = BucketOBaitwormsItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = hitResult;
            BlockPos pos = blockHitResult.getBlockPos().immutable();
            BlockState state = level.getBlockState(pos);
            if (level.getFluidState(pos).is(FluidTags.WATER)) {
                if (!level.isClientSide) {
                    this.applyBaitwormEffect((ServerLevel)level, pos);
                    level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.getAbilities().instabuild) {
                        return InteractionResultHolder.sidedSuccess((Object)new ItemStack((ItemLike)Items.BUCKET), (boolean)level.isClientSide);
                    }
                }
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
            }
            if (state.is(BGBlocks.UMBRAL_SOIL.get())) {
                if (!level.isClientSide) {
                    level.setBlock(pos, BGBlocks.WRIGGLING_SOIL.get().defaultBlockState(), 3);
                    level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!player.getAbilities().instabuild) {
                        return InteractionResultHolder.sidedSuccess((Object)new ItemStack((ItemLike)Items.BUCKET), (boolean)level.isClientSide);
                    }
                }
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private void applyBaitwormEffect(ServerLevel level, BlockPos centerPos) {
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    BlockPos pos = centerPos.offset(x, y, z);
                    if (!level.getFluidState(pos).is(FluidTags.WATER) || !(level.random.nextFloat() < 0.3f)) continue;
                    level.sendParticles((ParticleOptions)ParticleTypes.FISHING, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 1, level.random.nextDouble() * 0.5 - 0.25, level.random.nextDouble() * 0.5 - 0.25, level.random.nextDouble() * 0.5 - 0.25, 0.1);
                }
            }
        }
        BaitwormWaterEffect.addEffect(level, centerPos, 5, 1200);
    }
}

