/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.item;

import com.jamiedev.bygone.Bygone;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CustomAnimalArmorItem
extends ArmorItem {
    private final ResourceLocation textureLocation;
    @Nullable
    private final ResourceLocation overlayTextureLocation;
    private final BodyType bodyType;

    public CustomAnimalArmorItem(Holder<ArmorMaterial> armorMaterial, BodyType bodyType, boolean hasOverlay, Item.Properties properties) {
        super(armorMaterial, ArmorItem.Type.BODY, properties);
        this.bodyType = bodyType;
        ResourceLocation resourcelocation = bodyType.textureLocator.apply(((ResourceKey)armorMaterial.unwrapKey().orElseThrow()).location());
        this.textureLocation = resourcelocation.withSuffix(".png");
        this.overlayTextureLocation = hasOverlay ? resourcelocation.withSuffix("_overlay.png") : null;
    }

    public ResourceLocation getTexture() {
        return this.textureLocation;
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        return this.overlayTextureLocation;
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public SoundEvent getBreakingSound() {
        return this.bodyType.breakingSound;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public static enum BodyType {
        BIG_BEAK(id -> Bygone.id("textures/entity/big_beak/beak_" + id.getPath()), SoundEvents.ITEM_BREAK);

        final Function<ResourceLocation, ResourceLocation> textureLocator;
        final SoundEvent breakingSound;

        private BodyType(Function<ResourceLocation, ResourceLocation> textureLocator, SoundEvent breakingSound) {
            this.textureLocator = textureLocator;
            this.breakingSound = breakingSound;
        }
    }
}

