/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.item;

import com.jamiedev.bygone.common.util.ShockwaveHandler;
import com.jamiedev.bygone.core.registry.BGDataComponentTypes;
import com.jamiedev.bygone.core.registry.BGDataComponents;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EchoGongItem
extends Item {
    private static final int MAX_CHARGE = 100;
    private static final int CHARGE_PER_TICK = 1;
    private static final int COOLDOWN_TICKS = 100;
    private static final float SHOCKWAVE_RADIUS = 8.0f;
    private static final int WEAKNESS_DURATION = 200;
    private static final SimpleParticleType SHOCKWAVE_PARTICLE = ParticleTypes.ELECTRIC_SPARK;

    public EchoGongItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            BGDataComponentTypes.EchoGongData data = (BGDataComponentTypes.EchoGongData)stack.getOrDefault((DataComponentType)BGDataComponents.ECHO_GONG_DATA.value(), (Object)BGDataComponentTypes.EchoGongData.EMPTY);
            int charge = data.charge();
            if (charge < 100 && !player.getCooldowns().isOnCooldown((Item)this)) {
                charge = Math.min(charge + 1, 100);
                stack.set((DataComponentType)BGDataComponents.ECHO_GONG_DATA.value(), (Object)new BGDataComponentTypes.EchoGongData(charge));
                if (charge % 20 == 0) {
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), BGSoundEvents.ECHO_GONG_CHARGE.get(), SoundSource.PLAYERS, 0.3f, 1.0f + (float)charge / 100.0f * 0.5f);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        double particleY = player.getY() + 0.5;
                        for (int i = 0; i < 3; ++i) {
                            double angle = level.random.nextDouble() * Math.PI * 2.0;
                            double distance = level.random.nextDouble() * 0.5;
                            double particleX = player.getX() + Math.cos(angle) * distance;
                            double particleZ = player.getZ() + Math.sin(angle) * distance;
                            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, particleX, particleY, particleZ, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        BGDataComponentTypes.EchoGongData data = (BGDataComponentTypes.EchoGongData)itemStack.getOrDefault((DataComponentType)BGDataComponents.ECHO_GONG_DATA.value(), (Object)BGDataComponentTypes.EchoGongData.EMPTY);
        int charge = data.charge();
        if (charge >= 100) {
            if (!level.isClientSide) {
                player.startUsingItem(hand);
                return InteractionResultHolder.consume((Object)itemStack);
            }
            return InteractionResultHolder.consume((Object)itemStack);
        }
        if (!level.isClientSide) {
            player.displayClientMessage((Component)Component.translatable((String)"item.bygone.echo_gong.not_charged", (Object[])new Object[]{charge, 100}).withStyle(ChatFormatting.GRAY), true);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        if (!level.isClientSide && user instanceof Player) {
            Player player = (Player)user;
            this.releaseShockwave(level, player, stack);
            stack.set((DataComponentType)BGDataComponents.ECHO_GONG_DATA.value(), (Object)new BGDataComponentTypes.EchoGongData(0));
            player.getCooldowns().addCooldown((Item)this, 100);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return stack;
    }

    private void releaseShockwave(Level level, Player player, ItemStack stack) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), BGSoundEvents.ECHO_GONG_USE.get(), SoundSource.RECORDS, 2.0f, 1.0f);
        level.gameEvent((Holder)GameEvent.INSTRUMENT_PLAY, player.position(), GameEvent.Context.of((Entity)player));
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ShockwaveHandler.createShockwave(serverLevel, player, SHOCKWAVE_PARTICLE, 3.0f, 20, 24);
            ShockwaveHandler.createShockwave(serverLevel, player, SHOCKWAVE_PARTICLE, 5.0f, 30, 32);
            ShockwaveHandler.createShockwave(serverLevel, player, SHOCKWAVE_PARTICLE, 8.0f, 40, 40);
            this.applyAreaEffects(serverLevel, player);
            this.breakFragileBlocks(serverLevel, player);
            serverLevel.sendParticles((ParticleOptions)SHOCKWAVE_PARTICLE, player.getX(), player.getY() + 1.0, player.getZ(), 8, 0.3, 0.3, 0.3, 0.2);
        }
    }

    private void applyAreaEffects(ServerLevel level, Player player) {
        AABB area = new AABB(player.position().add(-8.0, -2.0, -8.0), player.position().add(8.0, 3.0, 8.0));
        List entities = level.getEntitiesOfClass(LivingEntity.class, area);
        for (LivingEntity entity : entities) {
            if (entity == player || entity.isAlliedTo((Entity)player)) continue;
            entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 1));
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 0));
            Vec3 direction = entity.position().subtract(player.position());
            double distance = direction.length();
            if (!(distance > 0.0)) continue;
            Vec3 knockbackVec = direction.normalize();
            double knockbackStrength = Math.max(0.5, (8.0 - distance) / 8.0 * 1.5);
            double horizontalKnockback = knockbackStrength * 0.8;
            double verticalKnockback = Math.min(0.8, knockbackStrength * 0.6);
            entity.push(knockbackVec.x * horizontalKnockback, verticalKnockback, knockbackVec.z * horizontalKnockback);
        }
    }

    private void breakFragileBlocks(ServerLevel level, Player player) {
        BlockPos playerPos = player.blockPosition();
        int radius = 8;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos;
                    BlockState state;
                    if (x * x + z * z > radius * radius || !this.isFragileBlock(state = level.getBlockState(pos = playerPos.offset(x, y, z)))) continue;
                    level.destroyBlock(pos, true, (Entity)player);
                }
            }
        }
    }

    private boolean isFragileBlock(BlockState state) {
        return state.canBeReplaced();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        BGDataComponentTypes.EchoGongData data = (BGDataComponentTypes.EchoGongData)stack.getOrDefault((DataComponentType)BGDataComponents.ECHO_GONG_DATA.value(), (Object)BGDataComponentTypes.EchoGongData.EMPTY);
        int charge = data.charge();
        tooltipComponents.add((Component)Component.translatable((String)"item.bygone.echo_gong.desc1").withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"item.bygone.echo_gong.desc2").withStyle(ChatFormatting.GRAY));
        if (charge >= 100) {
            tooltipComponents.add((Component)Component.translatable((String)"item.bygone.echo_gong.ready").withStyle(ChatFormatting.GREEN));
        } else {
            int percent = charge * 100 / 100;
            tooltipComponents.add((Component)Component.translatable((String)"item.bygone.echo_gong.charge", (Object[])new Object[]{percent}).withStyle(ChatFormatting.YELLOW));
        }
    }

    public boolean isFoil(ItemStack stack) {
        BGDataComponentTypes.EchoGongData data = (BGDataComponentTypes.EchoGongData)stack.getOrDefault((DataComponentType)BGDataComponents.ECHO_GONG_DATA.value(), (Object)BGDataComponentTypes.EchoGongData.EMPTY);
        return data.charge() >= 100;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.TOOT_HORN;
    }
}

