/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ShockwaveHandler {
    private static final ConcurrentHashMap<UUID, List<ActiveShockwave>> ACTIVE_SHOCKWAVES = new ConcurrentHashMap();

    public static void createShockwave(ServerLevel level, Player player, SimpleParticleType particleType, float maxRadius, int durationTicks, int particleCount) {
        UUID playerId = player.getUUID();
        ActiveShockwave shockwave = new ActiveShockwave(level, player.position(), particleType, maxRadius, durationTicks, particleCount);
        ACTIVE_SHOCKWAVES.computeIfAbsent(playerId, k -> new ArrayList()).add(shockwave);
    }

    public static void tickAll() {
        ACTIVE_SHOCKWAVES.entrySet().removeIf(entry -> {
            List shockwaves = (List)entry.getValue();
            shockwaves.removeIf(shockwave -> !shockwave.tick());
            return shockwaves.isEmpty();
        });
    }

    public static void clearPlayer(UUID playerId) {
        ACTIVE_SHOCKWAVES.remove(playerId);
    }

    public static class ActiveShockwave {
        private final ServerLevel level;
        private final Vec3 center;
        private final SimpleParticleType particleType;
        private final float maxRadius;
        private final int duration;
        private final int particleCount;
        private float currentRadius;
        private int ticksAlive;

        public ActiveShockwave(ServerLevel level, Vec3 center, SimpleParticleType particleType, float maxRadius, int duration, int particleCount) {
            this.level = level;
            this.center = center;
            this.particleType = particleType;
            this.maxRadius = maxRadius;
            this.duration = duration;
            this.particleCount = particleCount;
            this.currentRadius = 0.5f;
            this.ticksAlive = 0;
        }

        public boolean tick() {
            ++this.ticksAlive;
            float progress = (float)this.ticksAlive / (float)this.duration;
            if (progress > 1.0f) {
                return false;
            }
            float easedProgress = 1.0f - (1.0f - progress) * (1.0f - progress);
            this.currentRadius = 0.5f + easedProgress * (this.maxRadius - 0.5f);
            for (int i = 0; i < this.particleCount; ++i) {
                float angle = (float)((double)(i * 2) * Math.PI / (double)this.particleCount);
                double x = this.center.x + (double)(Mth.cos((float)angle) * this.currentRadius);
                double z = this.center.z + (double)(Mth.sin((float)angle) * this.currentRadius);
                double y = this.center.y + 0.5;
                this.level.sendParticles((ParticleOptions)this.particleType, x += (this.level.random.nextDouble() - 0.5) * 0.1, y += (this.level.random.nextDouble() - 0.5) * 0.2, z += (this.level.random.nextDouble() - 0.5) * 0.1, 1, 0.0, 0.0, 0.0, 0.0);
            }
            return true;
        }
    }
}

