/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.feature;

import com.jamiedev.bygone.common.block.PointedAmberBlock;
import com.jamiedev.bygone.core.registry.BGBlocks;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;

public class AmberHelper {
    public static double scaleHeightFromRadius(double radius, double scale, double heightScale, double bluntness) {
        if (radius < bluntness) {
            radius = bluntness;
        }
        double d = 0.384;
        double e = radius / scale * 0.384;
        double f = 0.75 * Math.pow(e, 1.3333333333333333);
        double g = Math.pow(e, 0.6666666666666666);
        double h = 0.3333333333333333 * Math.log(e);
        double i = heightScale * (f - g - h);
        i = Math.max(i, 0.0);
        return i / 0.384 * scale;
    }

    public static boolean canGenerateBase(WorldGenLevel world, BlockPos pos, int height) {
        if (AmberHelper.canGenerateOrLava((LevelAccessor)world, pos)) {
            return false;
        }
        float f = 6.0f;
        float g = 6.0f / (float)height;
        for (float h = 0.0f; h < (float)Math.PI * 2; h += g) {
            int j;
            int i = (int)(Mth.cos((float)h) * (float)height);
            if (!AmberHelper.canGenerateOrLava((LevelAccessor)world, pos.offset(i, 0, j = (int)(Mth.sin((float)h) * (float)height)))) continue;
            return false;
        }
        return true;
    }

    public static boolean canGenerate(LevelAccessor world, BlockPos pos) {
        return world.isStateAtPosition(pos, AmberHelper::canGenerate);
    }

    public static boolean canGenerateOrLava(LevelAccessor world, BlockPos pos) {
        return world.isStateAtPosition(pos, AmberHelper::canGenerateOrLava);
    }

    protected static void getAmberThickness(Direction direction, int height, boolean merge, Consumer<BlockState> callback) {
        if (height >= 3) {
            callback.accept(AmberHelper.getState(direction, DripstoneThickness.BASE));
            for (int i = 0; i < height - 3; ++i) {
                callback.accept(AmberHelper.getState(direction, DripstoneThickness.MIDDLE));
            }
        }
        if (height >= 2) {
            callback.accept(AmberHelper.getState(direction, DripstoneThickness.FRUSTUM));
        }
        if (height >= 1) {
            callback.accept(AmberHelper.getState(direction, merge ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    protected static void generatePointedAmber(LevelAccessor world, BlockPos pos, Direction direction, int height, boolean merge) {
        if (AmberHelper.canReplace(world.getBlockState(pos.relative(direction.getOpposite())))) {
            BlockPos.MutableBlockPos mutable = pos.mutable();
            AmberHelper.getAmberThickness(direction, height, merge, state -> {
                if (state.is(BGBlocks.POINTED_AMBER.get())) {
                    state = (BlockState)state.setValue((Property)PointedAmberBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.isWaterAt((BlockPos)mutable)));
                }
                world.setBlock((BlockPos)mutable, state, 2);
                mutable.move(direction);
            });
        }
    }

    protected static boolean generateAmberBlock(LevelAccessor world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        if (blockState.is(BlockTags.DRIPSTONE_REPLACEABLE)) {
            world.setBlock(pos, BGBlocks.AMBER_SAND.get().defaultBlockState(), 2);
            return true;
        }
        return false;
    }

    private static BlockState getState(Direction direction, DripstoneThickness thickness) {
        return (BlockState)((BlockState)BGBlocks.POINTED_AMBER.get().defaultBlockState().setValue((Property)PointedAmberBlock.VERTICAL_DIRECTION, (Comparable)direction)).setValue(PointedAmberBlock.THICKNESS, (Comparable)thickness);
    }

    public static boolean canReplaceOrLava(BlockState state) {
        return AmberHelper.canReplace(state) || state.is(Blocks.LAVA);
    }

    public static boolean canReplace(BlockState state) {
        return state.is(BGBlocks.AMBER_SANDSTONE.get()) || state.is(BGBlocks.AMBER_SAND.get()) || state.is(BlockTags.DRIPSTONE_REPLACEABLE);
    }

    public static boolean canGenerate(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER);
    }

    public static boolean cannotGenerate(BlockState state) {
        return !state.isAir() && !state.is(Blocks.WATER);
    }

    public static boolean canGenerateOrLava(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER) || state.is(Blocks.LAVA);
    }
}

