/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class CessLakeFeature
extends Feature<Config> {
    private static final BlockState CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();

    public CessLakeFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        boolean v;
        int u;
        int s;
        BlockPos blockPos = context.origin();
        WorldGenLevel structureWorldAccess = context.level();
        RandomSource random = context.random();
        Config config = (Config)context.config();
        if (blockPos.getY() <= structureWorldAccess.getMinBuildHeight() + 4) {
            return false;
        }
        blockPos = blockPos.below(4);
        boolean[] bls = new boolean[2048];
        int i = random.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d = random.nextDouble() * 6.0 + 3.0;
            double e = random.nextDouble() * 4.0 + 2.0;
            double f = random.nextDouble() * 6.0 + 3.0;
            double g = random.nextDouble() * (32.0 - d - 2.0) + 1.0 + d / 2.0;
            double h = random.nextDouble() * (8.0 - e - 4.0) + 2.0 + e / 2.0;
            double k = random.nextDouble() * (32.0 - f - 2.0) + 1.0 + f / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int m = 1; m < 15; ++m) {
                    for (int n = 1; n < 7; ++n) {
                        double o = ((double)l - g) / (d / 2.0);
                        double p = ((double)n - h) / (e / 2.0);
                        double q = ((double)m - k) / (f / 2.0);
                        double r = o * o + p * p + q * q;
                        if (!(r < 1.0)) continue;
                        bls[(l * 16 + m) * 8 + n] = true;
                    }
                }
            }
        }
        BlockState blockState = config.fluid().getState(random, blockPos);
        for (s = 0; s < 16; ++s) {
            for (int t = 0; t < 16; ++t) {
                for (u = 0; u < 8; ++u) {
                    boolean bl = v = !bls[(s * 16 + t) * 8 + u] && (s < 15 && bls[((s + 1) * 16 + t) * 8 + u] || s > 0 && bls[((s - 1) * 16 + t) * 8 + u] || t < 15 && bls[(s * 16 + t + 1) * 8 + u] || t > 0 && bls[(s * 16 + (t - 1)) * 8 + u] || u < 7 && bls[(s * 16 + t) * 8 + u + 1] || u > 0 && bls[(s * 16 + t) * 8 + (u - 1)]);
                    if (!v) continue;
                    BlockState blockState2 = structureWorldAccess.getBlockState(blockPos.offset(s, u, t));
                    if (u >= 4 && blockState2.liquid()) {
                        return false;
                    }
                    if (u >= 4 || blockState2.isSolid() || structureWorldAccess.getBlockState(blockPos.offset(s, u, t)) == blockState) continue;
                    return false;
                }
            }
        }
        for (s = 0; s < 16; ++s) {
            for (int t = 0; t < 16; ++t) {
                for (u = 0; u < 8; ++u) {
                    BlockPos blockPos2;
                    if (!bls[(s * 16 + t) * 8 + u] || !this.canReplace(structureWorldAccess.getBlockState(blockPos2 = blockPos.offset(s, u, t)))) continue;
                    boolean bl2 = u >= 4;
                    structureWorldAccess.setBlock(blockPos2, bl2 ? CAVE_AIR : blockState, 2);
                    if (!bl2) continue;
                    structureWorldAccess.scheduleTick(blockPos2, CAVE_AIR.getBlock(), 0);
                    this.markAboveForPostProcessing(structureWorldAccess, blockPos2);
                }
            }
        }
        BlockState blockState3 = config.barrier().getState(random, blockPos);
        if (!blockState3.isAir()) {
            for (int t = 0; t < 16; ++t) {
                for (u = 0; u < 16; ++u) {
                    for (int v1 = 0; v1 < 8; ++v1) {
                        BlockState blockState4;
                        boolean bl2;
                        boolean bl = bl2 = !bls[(t * 16 + u) * 8 + v1] && (t < 15 && bls[((t + 1) * 16 + u) * 8 + v1] || t > 0 && bls[((t - 1) * 16 + u) * 8 + v1] || u < 15 && bls[(t * 16 + u + 1) * 8 + v1] || u > 0 && bls[(t * 16 + (u - 1)) * 8 + v1] || v1 < 7 && bls[(t * 16 + u) * 8 + v1 + 1] || v1 > 0 && bls[(t * 16 + u) * 8 + (v1 - 1)]);
                        if (!bl2 || v1 >= 4 && random.nextInt(2) == 0 || !(blockState4 = structureWorldAccess.getBlockState(blockPos.offset(t, v1, u))).isSolid() || blockState4.is(BlockTags.LAVA_POOL_STONE_CANNOT_REPLACE)) continue;
                        BlockPos blockPos3 = blockPos.offset(t, v1, u);
                        structureWorldAccess.setBlock(blockPos3, blockState3, 2);
                        this.markAboveForPostProcessing(structureWorldAccess, blockPos3);
                    }
                }
            }
        }
        if (blockState.getFluidState().is(FluidTags.WATER)) {
            for (int t = 0; t < 16; ++t) {
                for (u = 0; u < 16; ++u) {
                    v = true;
                    BlockPos blockPos4 = blockPos.offset(t, 4, u);
                    if (!((Biome)structureWorldAccess.getBiome(blockPos4).value()).shouldFreeze((LevelReader)structureWorldAccess, blockPos4, false) || !this.canReplace(structureWorldAccess.getBlockState(blockPos4))) continue;
                    structureWorldAccess.setBlock(blockPos4, Blocks.ICE.defaultBlockState(), 2);
                }
            }
        }
        return true;
    }

    private boolean canReplace(BlockState state) {
        return !state.is(BlockTags.FEATURES_CANNOT_REPLACE);
    }

    public record Config(BlockStateProvider fluid, BlockStateProvider barrier) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("fluid").forGetter(Config::fluid), (App)BlockStateProvider.CODEC.fieldOf("barrier").forGetter(Config::barrier)).apply((Applicative)instance, Config::new));
    }
}

