/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.feature;

import com.jamiedev.bygone.common.worldgen.feature.config.MegalithConfig;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class MegalithFeature
extends Feature<MegalithConfig> {
    public MegalithFeature(Codec<MegalithConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<MegalithConfig> context) {
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        MegalithConfig megalithConfig = (MegalithConfig)context.config();
        BlockPos blockPos = context.origin();
        int lengthX = megalithConfig.sizeX().sample(random);
        int lengthY = megalithConfig.sizeY().sample(random);
        int lengthZ = megalithConfig.sizeZ().sample(random);
        int fallenBlockCount = megalithConfig.fallenBlockCount().sample(random);
        int floatingBlockCount = megalithConfig.floatingBlockCount().sample(random);
        ArrayList<BlockPos> validFallenBlockCoords = new ArrayList<BlockPos>();
        ArrayList<BlockPos> validFloatingBlockCoords = new ArrayList<BlockPos>();
        float[][] erosionMask = MegalithFeature.createErosionMask(lengthX, lengthZ);
        for (int x = 0; x < lengthX; ++x) {
            for (int z = 0; z < lengthZ; ++z) {
                boolean canErodeLayer = true;
                boolean lastBlockAir = true;
                for (int y = -megalithConfig.fallenBlockSearchRange(); y < lengthY; ++y) {
                    BlockPos currPos = blockPos.offset(x, y, z);
                    if (y < 0) {
                        boolean currBlockAir = level.isEmptyBlock(currPos);
                        if (currBlockAir) {
                            if (lastBlockAir) {
                                validFloatingBlockCoords.add(currPos);
                                continue;
                            }
                            validFallenBlockCoords.add(currPos);
                            continue;
                        }
                        lastBlockAir = false;
                        continue;
                    }
                    if (!megalithConfig.canReplaceBlocks() && !level.isEmptyBlock(currPos)) continue;
                    BlockState blockState = Blocks.AIR.defaultBlockState();
                    if (y < megalithConfig.maxErosionDepth()) {
                        float erosionDepthMask = 1.0f - (float)y / (float)megalithConfig.maxErosionDepth();
                        float combinedErosionChance = (float)megalithConfig.erosionChance() * erosionMask[x][z] * erosionDepthMask;
                        if (canErodeLayer && random.nextFloat() < combinedErosionChance) {
                            this.setBlock((LevelWriter)level, currPos, blockState);
                            continue;
                        }
                        canErodeLayer = false;
                    }
                    blockState = megalithConfig.megalithBlocks().getState(random, currPos);
                    this.setBlock((LevelWriter)level, currPos, blockState);
                }
            }
        }
        this.placeFallenBlocks(validFallenBlockCoords, fallenBlockCount, megalithConfig.megalithBlocks(), random, level);
        this.placeFallenBlocks(validFloatingBlockCoords, floatingBlockCount, megalithConfig.megalithBlocks(), random, level);
        return true;
    }

    private void placeFallenBlocks(List<BlockPos> coords, int count, BlockStateProvider blockStateProvider, RandomSource random, WorldGenLevel level) {
        int i;
        for (i = coords.size() - 1; i > 0; --i) {
            int j = random.nextInt(i + 1);
            Collections.swap(coords, i, j);
        }
        for (i = 0; i < Math.min(count, coords.size()); ++i) {
            BlockPos pos = coords.get(i);
            BlockState blockState = blockStateProvider.getState(random, pos);
            this.setBlock((LevelWriter)level, pos, blockState);
        }
    }

    private static float[][] createErosionMask(int x, int z) {
        float[][] mask = new float[x][z];
        float centerX = (float)x / 2.0f;
        float centerZ = (float)z / 2.0f;
        float maxDistSquared = centerX * centerX + centerZ * centerZ;
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < z; ++j) {
                float dXSquared = ((float)j - centerX) * ((float)j - centerX);
                float dZSquared = ((float)i - centerZ) * ((float)i - centerZ);
                float distSquared = dXSquared + dZSquared;
                mask[i][j] = (float)StrictMath.sqrt(StrictMath.sqrt(distSquared / maxDistSquared));
            }
        }
        return mask;
    }
}

