/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.feature;

import com.jamiedev.bygone.common.worldgen.feature.AmberHelper;
import com.jamiedev.bygone.common.worldgen.feature.PointedAmberFeatureConfig;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.jetbrains.annotations.NotNull;

public class PointedAmberFeature
extends Feature<PointedAmberFeatureConfig> {
    public PointedAmberFeature(Codec<PointedAmberFeatureConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<PointedAmberFeatureConfig> context) {
        WorldGenLevel worldAccess = context.level();
        BlockPos blockPos = context.origin();
        RandomSource random = context.random();
        PointedAmberFeatureConfig smallAmberFeatureConfig = (PointedAmberFeatureConfig)context.config();
        Optional<Direction> optional = PointedAmberFeature.getDirection((LevelAccessor)worldAccess, blockPos, random);
        if (optional.isEmpty()) {
            return false;
        }
        BlockPos blockPos2 = blockPos.relative(optional.get().getOpposite());
        PointedAmberFeature.generateAmberBlocks((LevelAccessor)worldAccess, random, blockPos2, smallAmberFeatureConfig);
        int i = random.nextFloat() < smallAmberFeatureConfig.chanceOfTallerAmber && AmberHelper.canGenerate(worldAccess.getBlockState(blockPos.relative(optional.get()))) ? 2 : 1;
        AmberHelper.generatePointedAmber((LevelAccessor)worldAccess, blockPos, optional.get(), i, false);
        return true;
    }

    private static Optional<Direction> getDirection(LevelAccessor world, BlockPos pos, @NotNull RandomSource random) {
        boolean bl = AmberHelper.canReplace(world.getBlockState(pos.above()));
        boolean bl2 = AmberHelper.canReplace(world.getBlockState(pos.below()));
        if (bl && bl2) {
            return Optional.of(random.nextBoolean() ? Direction.DOWN : Direction.UP);
        }
        if (bl) {
            return Optional.of(Direction.DOWN);
        }
        return bl2 ? Optional.of(Direction.UP) : Optional.empty();
    }

    private static void generateAmberBlocks(LevelAccessor world, @NotNull RandomSource random, BlockPos pos, PointedAmberFeatureConfig config) {
        AmberHelper.generateAmberBlock(world, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (random.nextFloat() > config.chanceOfDirectionalSpread) continue;
            BlockPos blockPos = pos.relative(direction);
            AmberHelper.generateAmberBlock(world, blockPos);
            if (random.nextFloat() > config.chanceOfSpreadRadius2) continue;
            BlockPos blockPos2 = blockPos.relative(Direction.getRandom((RandomSource)random));
            AmberHelper.generateAmberBlock(world, blockPos2);
            if (random.nextFloat() > config.chanceOfSpreadRadius3) continue;
            BlockPos blockPos3 = blockPos2.relative(Direction.getRandom((RandomSource)random));
            AmberHelper.generateAmberBlock(world, blockPos3);
        }
    }
}

