/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.feature;

import com.jamiedev.bygone.common.worldgen.feature.config.ThornySableBranchConfig;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class ThornySableBranchFeature
extends Feature<ThornySableBranchConfig> {
    public ThornySableBranchFeature(Codec<ThornySableBranchConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ThornySableBranchConfig> context) {
        BlockPos blockpos;
        WorldGenLevel worldgenlevel = context.level();
        if (ThornySableBranchFeature.isInvalidPlacementLocation((LevelAccessor)worldgenlevel, blockpos = context.origin())) {
            return false;
        }
        RandomSource randomsource = context.random();
        ThornySableBranchConfig SableBranchconfig = (ThornySableBranchConfig)context.config();
        int i = SableBranchconfig.spreadWidth();
        int j = SableBranchconfig.spreadHeight();
        int k = SableBranchconfig.maxHeight();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = 0; l < i * i; ++l) {
            blockpos$mutableblockpos.set((Vec3i)blockpos).move(Mth.nextInt((RandomSource)randomsource, (int)(-i), (int)i), Mth.nextInt((RandomSource)randomsource, (int)(-j), (int)j), Mth.nextInt((RandomSource)randomsource, (int)(-i), (int)i));
            if (!ThornySableBranchFeature.findFirstAirBlockAboveGround((LevelAccessor)worldgenlevel, blockpos$mutableblockpos) || ThornySableBranchFeature.isInvalidPlacementLocation((LevelAccessor)worldgenlevel, (BlockPos)blockpos$mutableblockpos)) continue;
            int i1 = Mth.nextInt((RandomSource)randomsource, (int)1, (int)k);
            if (randomsource.nextInt(6) == 0) {
                i1 *= 2;
            }
            if (randomsource.nextInt(5) == 0) {
                i1 = 1;
            }
            int j1 = 17;
            int k1 = 25;
            ThornySableBranchFeature.placeWeepingVinesColumn((LevelAccessor)worldgenlevel, randomsource, blockpos$mutableblockpos, i1, 17, 25);
        }
        return true;
    }

    private static boolean findFirstAirBlockAboveGround(LevelAccessor level, BlockPos.MutableBlockPos pos) {
        do {
            pos.move(0, -1, 0);
            if (!level.isOutsideBuildHeight((BlockPos)pos)) continue;
            return false;
        } while (level.getBlockState((BlockPos)pos).isAir());
        pos.move(0, 1, 0);
        return true;
    }

    public static void placeWeepingVinesColumn(LevelAccessor level, RandomSource random, BlockPos.MutableBlockPos pos, int length, int minAge, int maxAge) {
        for (int i = 1; i <= length; ++i) {
            if (level.isEmptyBlock((BlockPos)pos)) {
                if (i == length || !level.isEmptyBlock(pos.above())) {
                    level.setBlock((BlockPos)pos, (BlockState)BGBlocks.THORNY_SABLE_BRANCH.get().defaultBlockState().setValue((Property)GrowingPlantHeadBlock.AGE, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)random, (int)minAge, (int)maxAge))), 2);
                    break;
                }
                level.setBlock((BlockPos)pos, BGBlocks.THORNY_SABLE_BRANCH_PLANT.get().defaultBlockState(), 2);
            }
            pos.move(Direction.UP);
        }
    }

    private static boolean isInvalidPlacementLocation(LevelAccessor level, BlockPos pos) {
        if (!level.isEmptyBlock(pos)) {
            return true;
        }
        BlockState blockstate = level.getBlockState(pos.below());
        return !blockstate.is(BGBlocks.SABLE_LEAVES.get()) && !blockstate.is(BGBlocks.SABLE_WOOD.get()) && !blockstate.is(BGBlocks.SABLE_LOG.get());
    }
}

