/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.core.init;

import com.jamiedev.bygone.Bygone;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public class JamiesModLootTables {
    private static final Set<ResourceKey<LootTable>> LOOT_TABLES = new HashSet<ResourceKey<LootTable>>();
    private static final Set<ResourceKey<LootTable>> LOOT_TABLES_READ_ONLY = Collections.unmodifiableSet(LOOT_TABLES);
    public static final ResourceKey<LootTable> EMPTY = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"empty"));
    public static final ResourceKey<LootTable> ABANDONED_MINESHAFT_CHEST = JamiesModLootTables.register("chests/abandoned_mineshaft");
    public static final ResourceKey<LootTable> LITHY_TRIP_LOOT_TABLE = JamiesModLootTables.register("gameplay/lithy_trip");

    private static ResourceKey<LootTable> register(String id) {
        return JamiesModLootTables.registerLootTable((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Bygone.id(id)));
    }

    private static ResourceKey<LootTable> registerLootTable(ResourceKey<LootTable> key) {
        if (LOOT_TABLES.add(key)) {
            return key;
        }
        throw new IllegalArgumentException(String.valueOf(key.location()) + " is already a registered built-in loot table");
    }

    public static Set<ResourceKey<LootTable>> getAll() {
        return LOOT_TABLES_READ_ONLY;
    }
}

