/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.core.mixin;

import com.jamiedev.bygone.common.item.MaliciousWarHornItem;
import com.jamiedev.bygone.core.registry.BGDataComponents;
import com.jamiedev.bygone.core.registry.BGItems;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixinVex {
    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventWarHornVexHurtingPlayer(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Player) {
            Vex vex;
            Player player = (Player)entity;
            Entity entity2 = damageSource.getEntity();
            if (entity2 instanceof Vex && this.isWarHornVex(vex = (Vex)entity2, player)) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"doHurtTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventWarHornVexTargeting(Entity target, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Vex) {
            Player player;
            Vex vex = (Vex)entity;
            if (target instanceof Player && this.isWarHornVex(vex, player = (Player)target)) {
                cir.setReturnValue((Object)false);
            }
        }
    }

    private boolean isWarHornVex(Vex vex, Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            MaliciousWarHornItem.WarHornData data;
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.getItem() != BGItems.MALICIOUS_WAR_HORN.get() || !(data = (MaliciousWarHornItem.WarHornData)stack.getOrDefault((DataComponentType)BGDataComponents.WAR_HORN_DATA.value(), (Object)MaliciousWarHornItem.WarHornData.EMPTY)).activeVexes().contains(vex.getUUID())) continue;
            return true;
        }
        return false;
    }
}

