/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.core.mixin;

import com.jamiedev.bygone.common.entity.projectile.HookEntity;
import com.jamiedev.bygone.common.util.PlayerWithHook;
import com.jamiedev.bygone.core.network.SyncPlayerHookS2C;
import com.jamiedev.bygone.core.platform.Services;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerWithHook {
    @Unique
    @Nullable
    private UUID hookUUID;
    @Unique
    private int hookId;
    @Unique
    @Nullable
    private HookEntity hook;

    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    @Nullable
    public HookEntity bygone$getHook() {
        if (this.hookUUID == null) {
            return null;
        }
        if (this.hook != null && !this.hook.isRemoved() && this.hookId == this.hook.getId()) {
            return this.hook;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            HookEntity foundHook;
            ServerLevel serverWorld = (ServerLevel)level;
            Entity entityByUuid = serverWorld.getEntity(this.hookUUID);
            this.bygone$setHook(entityByUuid instanceof HookEntity ? (foundHook = (HookEntity)entityByUuid) : null);
            return this.hook;
        }
        if (this.hookId > 0) {
            HookEntity foundHook;
            Entity entityById = this.level().getEntity(this.hookId);
            this.bygone$setHook(entityById instanceof HookEntity ? (foundHook = (HookEntity)entityById) : null);
            return this.hook;
        }
        return null;
    }

    @Override
    public void bygone$setHook(@Nullable HookEntity pHook) {
        boolean changed = this.hook != pHook;
        this.hook = pHook;
        this.hookUUID = pHook == null ? null : pHook.getUUID();
        int n = this.hookId = pHook == null ? 0 : pHook.getId();
        if (changed && !this.level().isClientSide) {
            Services.PLATFORM.sendToTracking(new SyncPlayerHookS2C(pHook == null ? 0 : pHook.getId(), this.getUUID()), (Entity)this, true);
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void post_writeCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        if (this.hookUUID != null) {
            nbt.putUUID("HookUUID", this.hookUUID);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void post_readCustomDataFromNbt(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.hasUUID("HookUUID")) {
            this.hookUUID = nbt.getUUID("HookUUID");
        }
    }
}

