/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.core.registry;

import com.jamiedev.bygone.Bygone;
import com.jamiedev.bygone.common.worldgen.structure.AbandonedFarmGenerator;
import com.jamiedev.bygone.common.worldgen.structure.AmberPyramidStructure;
import com.jamiedev.bygone.common.worldgen.structure.AmberRuinsGenerator;
import com.jamiedev.bygone.common.worldgen.structure.AmberRuinsStructure;
import com.jamiedev.bygone.common.worldgen.structure.AncientRootGenerator;
import com.jamiedev.bygone.common.worldgen.structure.AncientRootStructure;
import com.jamiedev.bygone.common.worldgen.structure.BygoneFossilGenerator;
import com.jamiedev.bygone.common.worldgen.structure.BygoneFossilStructure;
import com.jamiedev.bygone.common.worldgen.structure.BygoneMineshaftGenerator;
import com.jamiedev.bygone.common.worldgen.structure.BygoneMineshaftStructure;
import com.jamiedev.bygone.common.worldgen.structure.BygonePortalGenerator;
import com.jamiedev.bygone.common.worldgen.structure.BygonePortalStructure;
import com.jamiedev.bygone.common.worldgen.structure.MegalithRuinsStructure;
import com.jamiedev.bygone.common.worldgen.structure.MinilithGenerator;
import com.jamiedev.bygone.common.worldgen.structure.MinilithStructure;
import com.jamiedev.bygone.common.worldgen.structure.RuinGenerator;
import com.jamiedev.bygone.common.worldgen.structure.RuinStructure;
import com.jamiedev.bygone.common.worldgen.structure.TestRootStructure;
import java.util.Locale;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class BGStructures {
    public static StructureType<AncientRootStructure> ANCIENT_ROOTS;
    public static StructurePieceType ANCIENT_ROOTS_PIECES;
    public static StructureType<AncientRootStructure> ABANDONED_FARM;
    public static StructurePieceType ABANDONED_FARM_PIECES;
    public static StructureType<RuinStructure> BLEMISH_RUINS;
    public static StructureType<AmberRuinsStructure> AMBER_RUINS;
    public static StructureType<AmberPyramidStructure> AMBER_PYRAMID;
    public static StructureType<MegalithRuinsStructure> MEGALITH_RUINS;
    public static StructureType<MinilithStructure> MINILITHS;
    public static StructureType<BygoneMineshaftStructure> BYGONE_MINESHAFT;
    public static StructurePieceType BYGONE_MINESHAFT_CORRIDOR;
    public static StructurePieceType BYGONE_MINESHAFT_CROSSING;
    public static StructurePieceType BYGONE_MINESHAFT_ROOM;
    public static StructurePieceType BYGONE_MINESHAFT_STAIRS;
    public static StructureType<BygoneFossilStructure> BYGONE_FOSSIL;
    public static StructurePieceType FOSSIL_PIECES;
    public static StructurePieceType AMBER_RUIN_PIECES;
    public static StructurePieceType RUIN_PIECES;
    public static StructurePieceType PYRAMID_PIECES;
    public static StructurePieceType MEGALITH_RUINS_PIECES;
    public static StructurePieceType MINILITH_PIECES;
    public static StructureType<TestRootStructure> TEST_ROOTS;
    public static StructureType<BygonePortalStructure> BYGONE_PORTAL;
    public static StructurePieceType PORTAL_PIECE;

    private static StructurePieceType register(StructurePieceType type, String id) {
        return (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (String)id.toLowerCase(Locale.ROOT), (Object)type);
    }

    private static StructurePieceType register(StructurePieceType.ContextlessType type, String id) {
        return BGStructures.register((StructurePieceType)type, id);
    }

    private static StructurePieceType register(StructurePieceType.StructureTemplateType type, String id) {
        return BGStructures.register((StructurePieceType)type, id);
    }

    public static void init() {
        ABANDONED_FARM = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"abandoned_farm"), () -> AncientRootStructure.CODEC);
        ANCIENT_ROOTS = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"ancient_roots"), () -> AncientRootStructure.CODEC);
        BYGONE_FOSSIL = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"bygone_fossil"), () -> BygoneFossilStructure.CODEC);
        BYGONE_PORTAL = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"bygone_portal"), () -> BygonePortalStructure.CODEC);
        TEST_ROOTS = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"test_roots"), () -> TestRootStructure.CODEC);
        BLEMISH_RUINS = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"ruin"), () -> RuinStructure.CODEC);
        AMBER_RUINS = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"amber_ruins"), () -> AmberRuinsStructure.CODEC);
        AMBER_PYRAMID = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"amber_pyramid"), () -> AmberPyramidStructure.CODEC);
        BYGONE_MINESHAFT = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"bygone_mineshaft"), () -> BygoneMineshaftStructure.CODEC);
        MEGALITH_RUINS = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"megalith_ruins"), () -> MegalithRuinsStructure.CODEC);
        MINILITHS = (StructureType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"bygone", (String)"miniliths"), () -> MinilithStructure.CODEC);
    }

    static {
        ANCIENT_ROOTS_PIECES = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("ancient_roots"), AncientRootGenerator.Piece::new);
        ABANDONED_FARM_PIECES = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("abandoned_farm"), AbandonedFarmGenerator.Piece::new);
        BYGONE_MINESHAFT_CORRIDOR = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("corr"), BygoneMineshaftGenerator.BygoneMineshaftCorridor::new);
        BYGONE_MINESHAFT_CROSSING = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("cros"), BygoneMineshaftGenerator.BygoneMineshaftCrossing::new);
        BYGONE_MINESHAFT_ROOM = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("room"), BygoneMineshaftGenerator.BygoneMineshaftRoom::new);
        BYGONE_MINESHAFT_STAIRS = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("star"), BygoneMineshaftGenerator.BygoneMineshaftStairs::new);
        FOSSIL_PIECES = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("bygone_fossil"), BygoneFossilGenerator.Piece::new);
        AMBER_RUIN_PIECES = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("ruin"), RuinGenerator.Piece::new);
        RUIN_PIECES = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("amber_ruins"), AmberRuinsGenerator.Piece::new);
        PYRAMID_PIECES = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("amber_pyramid"), AmberRuinsGenerator.Piece::new);
        MEGALITH_RUINS_PIECES = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("megalith_ruins"), AmberRuinsGenerator.Piece::new);
        MINILITH_PIECES = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("miniliths"), MinilithGenerator.Piece::new);
        PORTAL_PIECE = (StructurePieceType)Registry.register((Registry)BuiltInRegistries.STRUCTURE_PIECE, (ResourceLocation)Bygone.id("bygone_portal"), BygonePortalGenerator.Piece::new);
    }
}

