/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.block;

import com.google.common.collect.ImmutableMap;
import com.jamiedev.bygone.common.entity.WraithEntity;
import com.jamiedev.bygone.core.registry.BGBlocks;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2429;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4770;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6908;
import org.jetbrains.annotations.NotNull;

public class IceBouquetBlock
extends class_2248 {
    class_2358 ref;
    public static final int MAX_AGE = 15;
    public static final class_2758 AGE = class_2741.field_12498;
    public static final class_2746 NORTH = class_2429.field_11332;
    public static final class_2746 EAST = class_2429.field_11335;
    public static final class_2746 SOUTH = class_2429.field_11331;
    public static final class_2746 WEST = class_2429.field_11328;
    public static final class_2746 UP = class_2429.field_11327;
    private static final Map<class_2350, class_2746> PROPERTY_BY_DIRECTION = (Map)class_2429.field_11329.entrySet().stream().filter(p_53467_ -> p_53467_.getKey() != class_2350.field_11033).collect(class_156.method_664());
    private static final int SECONDS_ON_FIRE = 8;
    private final float fireDamage;
    protected static final float AABB_OFFSET = 1.0f;
    protected static final class_265 DOWN_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final class_265 UP_AABB = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 WEST_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final class_265 EAST_AABB = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 NORTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final class_265 SOUTH_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<class_2680, class_265> shapesCache;
    class_4770 ref1;

    public IceBouquetBlock(class_4970.class_2251 properties, float fireDamage) {
        super(properties);
        this.fireDamage = fireDamage;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.field_10647.method_11662().stream().filter(p_53497_ -> (Integer)p_53497_.method_11654((class_2769)AGE) == 0).collect(Collectors.toMap(Function.identity(), IceBouquetBlock::calculateShape)));
    }

    private static class_265 calculateShape(class_2680 state) {
        class_265 voxelshape = class_259.method_1073();
        if (((Boolean)state.method_11654((class_2769)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)state.method_11654((class_2769)NORTH)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)NORTH_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)SOUTH)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)SOUTH_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)EAST)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)EAST_AABB);
        }
        if (((Boolean)state.method_11654((class_2769)WEST)).booleanValue()) {
            voxelshape = class_259.method_1084((class_265)voxelshape, (class_265)WEST_AABB);
        }
        return voxelshape.method_1110() ? DOWN_AABB : voxelshape;
    }

    protected boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        return level.method_8320(blockpos).method_26206((class_1922)level, blockpos, class_2350.field_11036) || this.isValidFireLocation((class_1922)level, pos);
    }

    public static boolean canBePlacedAt(class_1937 level, class_2338 pos, class_2350 direction) {
        class_2680 blockstate = level.method_8320(pos);
        return blockstate.method_26215() && IceBouquetBlock.getState((class_1922)level, pos).method_26184((class_4538)level, pos);
    }

    public class_2680 method_9605(class_1750 context) {
        return this.getStateForPlacement((class_1922)context.method_8045(), context.method_8037());
    }

    protected class_2680 getStateForPlacement(class_1922 level, class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        class_2680 blockstate = level.method_8320(blockpos);
        if (!blockstate.method_26206(level, blockpos, class_2350.field_11036)) {
            class_2680 blockstate1 = this.method_9564();
            for (class_2350 direction : class_2350.values()) {
                class_2746 class_27462 = PROPERTY_BY_DIRECTION.get(direction);
            }
            return blockstate1;
        }
        return this.method_9564();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AGE, NORTH, EAST, SOUTH, WEST, UP});
    }

    public static class_2680 getState(class_1922 reader, class_2338 pos) {
        class_2338 blockpos = pos.method_10074();
        class_2680 blockstate = reader.method_8320(blockpos);
        return BGBlocks.ICE_BOUQUET.get().method_9564();
    }

    protected class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shapesCache.get(state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)));
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (random.method_43048(24) == 0) {
            level.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14993, class_3419.field_15245, 1.0f + random.method_43057(), random.method_43057() * 0.7f + 0.3f, false);
        }
    }

    protected void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        int j;
        level.method_39279(pos, (class_2248)this, IceBouquetBlock.getFireTickDelay(level.field_9229));
        if ((double)level.field_9229.method_43057() < 0.1) {
            level.method_8650(pos, false);
        }
        if (!state.method_26184((class_4538)level, pos)) {
            level.method_8650(pos, false);
        }
        class_2680 blockstate = level.method_8320(pos.method_10074());
        boolean flag = blockstate.method_26164(level.method_8597().comp_654());
        int i = (Integer)state.method_11654((class_2769)AGE);
        if (i != (j = Math.min(15, i + random.method_43048(3) / 2))) {
            state = (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(j));
            level.method_8652(pos, state, 4);
        }
        if (!flag && !this.isValidFireLocation((class_1922)level, pos)) {
            class_2338 blockpos = pos.method_10074();
            if (!level.method_8320(blockpos).method_26206((class_1922)level, blockpos, class_2350.field_11036) || i > 3) {
                level.method_8650(pos, false);
            }
            return;
        }
        boolean flag1 = level.method_23753(pos).method_40220(class_6908.field_41752);
        int k = flag1 ? -50 : 0;
        this.checkBurnOut((class_1937)level, pos.method_10078(), 300 + k, random, i);
        this.checkBurnOut((class_1937)level, pos.method_10067(), 300 + k, random, i);
        this.checkBurnOut((class_1937)level, pos.method_10074(), 250 + k, random, i);
        this.checkBurnOut((class_1937)level, pos.method_10084(), 250 + k, random, i);
        this.checkBurnOut((class_1937)level, pos.method_10095(), 300 + k, random, i);
        this.checkBurnOut((class_1937)level, pos.method_10072(), 300 + k, random, i);
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
    }

    private static int getFireTickDelay(class_5819 random) {
        return 30 + random.method_43048(10);
    }

    private void checkBurnOut(class_1937 level, class_2338 pos, int chance, class_5819 random, int age) {
        int i = this.getBurnOdds(level.method_8320(pos));
        if (random.method_43048(chance) < i) {
            class_2680 blockstate = level.method_8320(pos);
            if (random.method_43048(age + 10) < 5 && !level.method_8520(pos)) {
                int j = Math.min(age + random.method_43048(5) / 4, 15);
                level.method_8652(pos, this.getStateWithAge((class_1936)level, pos, j), 3);
            } else {
                level.method_8650(pos, false);
            }
        }
    }

    private class_2680 getStateWithAge(class_1936 level, class_2338 pos, int age) {
        class_2680 blockstate = IceBouquetBlock.getState((class_1922)level, pos);
        return blockstate.method_27852(class_2246.field_10036) ? (class_2680)blockstate.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age)) : blockstate;
    }

    private boolean isValidFireLocation(class_1922 level, class_2338 pos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2680 blockstate1 = level.method_8320(pos.method_10074());
            if (!blockstate1.method_51367() && blockstate1.method_26215()) continue;
            return true;
        }
        return false;
    }

    private int getBurnOdds(class_2680 state) {
        return 0;
    }

    protected void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        if (entity instanceof class_1657) {
            entity.method_5643(level.method_48963().method_48836(), this.fireDamage);
        }
        if (entity instanceof WraithEntity) {
            ((WraithEntity)entity).method_6025(0.05f);
        }
        super.method_9548(state, level, pos, entity);
    }

    protected void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean isMoving) {
        if (!oldState.method_27852(state.method_26204()) && !state.method_26184((class_4538)level, pos)) {
            level.method_8650(pos, false);
        }
    }

    protected void method_33614(class_1937 level, class_1657 player, class_2338 pos, class_2680 state) {
    }

    @NotNull
    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (!level.method_8608()) {
            level.method_8444(null, 1009, pos, 0);
        }
        return super.method_9576(level, pos, state, player);
    }
}

