/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.entity;

import com.google.common.collect.Lists;
import com.jamiedev.bygone.common.block.entity.CopperbugNestBlockEntity;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_11;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1355;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2513;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3830;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5531;
import net.minecraft.class_5712;
import net.minecraft.class_5812;
import net.minecraft.class_5819;
import net.minecraft.class_5955;
import net.minecraft.class_5996;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperbugEntity
extends class_1429
implements class_5354 {
    private static final class_2940<Byte> COPPERBUG_FLAGS = class_2945.method_12791(CopperbugEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> WARNING = class_2945.method_12791(CopperbugEntity.class, (class_2941)class_2943.field_13323);
    private static final float field_30352 = 6.0f;
    private float lastWarningAnimationProgress;
    private float warningAnimationProgress;
    private int warningSoundCooldown;
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    private int angerTime;
    @Nullable
    private UUID angryAt;
    CopperbugEntity ref;
    int ticksSinceScraping;
    private int cannotEnterNestTicks;
    private int copperUpdatedSinceScraping;
    private static final int field_30274 = 200;
    int ticksLeftToFindNest;
    private static final int field_30275 = 200;
    int ticksUntilCanScraping;
    @Nullable
    class_2338 copperPos;
    @Nullable
    class_2338 nestPos;
    ScrapeGoal scrapeGoal;
    MoveToNestGoal moveToNestGoal;
    MoveToCopperGoal moveToCopperGoal;

    public CopperbugEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_18, 0.0f);
        this.ticksUntilCanScraping = class_3532.method_15395((class_5819)this.field_5974, (int)20, (int)60);
    }

    public static class_5132.class_5133 createCopperbugAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 3.0);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new EnterNestGoal());
        this.field_6201.method_6277(1, (class_1352)new AttackGoal());
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 2.0, polarBear -> polarBear.method_6109() ? class_8103.field_51990 : class_8103.field_51991));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.25));
        this.scrapeGoal = new ScrapeGoal(this);
        this.field_6201.method_6277(4, (class_1352)this.scrapeGoal);
        this.field_6201.method_6277(5, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[]{CopperbugEntity.class}));
        this.field_6185.method_6277(1, (class_1352)new CopperbugRevengeGoal());
        this.field_6185.method_6277(2, (class_1352)new IsCopperOrVerdigrisGoal());
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, arg_0 -> ((CopperbugEntity)this).method_29515(arg_0)));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1621.class, 10, true, true, null));
        this.field_6185.method_6277(5, (class_1352)new class_5398((class_1308)this, false));
    }

    @class_5996
    public class_1355 getGoalSelector() {
        return this.field_6201;
    }

    public void method_5749(class_2487 nbt) {
        this.nestPos = class_2512.method_10691((class_2487)nbt, (String)"nest_pos").orElse(null);
        this.copperPos = class_2512.method_10691((class_2487)nbt, (String)"copper_pos").orElse(null);
        super.method_5749(nbt);
        this.setHasOxidization(nbt.method_10577("HasOxidization"));
        this.ticksSinceScraping = nbt.method_10550("TicksSinceScraping");
        this.cannotEnterNestTicks = nbt.method_10550("CannotEnterNestTicks");
        this.copperUpdatedSinceScraping = nbt.method_10550("CopperUpdatedSinceScraping");
        this.method_29512(this.method_37908(), nbt);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.hasNest()) {
            nbt.method_10566("nest_pos", class_2512.method_10692((class_2338)this.getNestPos()));
        }
        if (this.hasCopperBlock()) {
            nbt.method_10566("copper_pos", class_2512.method_10692((class_2338)this.getCopperBlockPos()));
        }
        nbt.method_10556("HasOxidization", this.hasOxidization());
        nbt.method_10569("TicksSinceScraping", this.ticksSinceScraping);
        nbt.method_10569("CannotEnterNestTicks", this.cannotEnterNestTicks);
        nbt.method_10569("CopperUpdatedSinceScraping", this.copperUpdatedSinceScraping);
        this.method_29517(nbt);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COPPERBUG_FLAGS, (Object)0);
        builder.method_56912(WARNING, (Object)false);
    }

    public void method_5773() {
        super.method_5773();
        if (this.hasOxidization() && this.getCopperOxidizedSinceScraping() < 10 && this.field_5974.method_43057() < 0.05f) {
            for (int i = 0; i < this.field_5974.method_43048(2) + 1; ++i) {
                this.addParticle(this.method_37908(), this.method_23317() - (double)0.3f, this.method_23317() + (double)0.3f, this.method_23321() - (double)0.3f, this.method_23321() + (double)0.3f, this.method_23323(0.5), (class_2394)class_2398.field_20537);
            }
        }
        if (this.method_37908().field_9236) {
            if (this.warningAnimationProgress != this.lastWarningAnimationProgress) {
                this.method_18382();
            }
            this.lastWarningAnimationProgress = this.warningAnimationProgress;
            this.warningAnimationProgress = this.isWarning() ? class_3532.method_15363((float)(this.warningAnimationProgress + 1.0f), (float)0.0f, (float)6.0f) : class_3532.method_15363((float)(this.warningAnimationProgress - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundCooldown > 0) {
            --this.warningSoundCooldown;
        }
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), true);
        }
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            if (this.cannotEnterNestTicks > 0) {
                --this.cannotEnterNestTicks;
            }
            if (this.ticksLeftToFindNest > 0) {
                --this.ticksLeftToFindNest;
            }
            if (this.ticksUntilCanScraping > 0) {
                --this.ticksUntilCanScraping;
            }
            if (this.field_6012 % 20 == 0 && !this.isNestValid()) {
                this.nestPos = null;
            }
        }
    }

    private void addParticle(class_1937 world, double lastX, double x, double lastZ, double z, double y, class_2394 effect) {
        world.method_8406(effect, class_3532.method_16436((double)world.field_9229.method_43058(), (double)lastX, (double)x), y, class_3532.method_16436((double)world.field_9229.method_43058(), (double)lastZ, (double)z), 0.0, 0.0, 0.0);
    }

    public class_4048 method_55694(class_4050 pose) {
        if (this.warningAnimationProgress > 0.0f) {
            float f = this.warningAnimationProgress / 6.0f;
            float g = 1.0f + f;
            return super.method_55694(pose).method_19539(1.0f, g);
        }
        return super.method_55694(pose);
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    public void method_29514(int angerTime) {
        this.angerTime = angerTime;
    }

    public int method_29507() {
        return this.angerTime;
    }

    public void method_29513(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Nullable
    public UUID method_29508() {
        return this.angryAt;
    }

    public boolean isWarning() {
        return (Boolean)this.field_6011.method_12789(WARNING);
    }

    public void setWarning(boolean warning) {
        this.field_6011.method_12778(WARNING, (Object)warning);
    }

    public float getWarningAnimationProgress(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastWarningAnimationProgress, (float)this.warningAnimationProgress) / 6.0f;
    }

    protected float method_6120() {
        return 0.98f;
    }

    protected class_3414 method_5994() {
        return BGSoundEvents.COPPERBUG_AMBIENT_ADDITIONS_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return BGSoundEvents.COPPERBUG_HURT_ADDITIONS_EVENT;
    }

    protected class_3414 method_6002() {
        return BGSoundEvents.COPPERBUG_DEATH_ADDITIONS_EVENT;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_15084, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundCooldown <= 0) {
            this.method_56078(BGSoundEvents.COPPERBUG_HURT_ADDITIONS_EVENT);
            this.warningSoundCooldown = 40;
        }
    }

    protected void tickWaterBreathingAir(int air) {
        this.method_5855(300);
    }

    public void method_5670() {
        int i = this.method_5669();
        super.method_5670();
        this.tickWaterBreathingAir(i);
    }

    protected void method_5958() {
        if (!this.hasOxidization()) {
            ++this.ticksSinceScraping;
        }
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), false);
        }
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_5931() {
        return false;
    }

    public boolean isTriggerItem() {
        if (this.method_7325()) {
            return false;
        }
        boolean bl = this.method_6118(class_1304.field_6173).method_31573(JamiesModTag.COPPER_BLOCKS) && this.method_6118(class_1304.field_6173).method_31573(JamiesModTag.VERDAGRIS_ITEMS) && this.method_6118(class_1304.field_6171).method_31573(JamiesModTag.COPPER_BLOCKS) && this.method_6118(class_1304.field_6171).method_31573(JamiesModTag.VERDAGRIS_ITEMS);
        return bl;
    }

    public static boolean canSpawn(class_1299<CopperbugEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, @NotNull class_5819 random) {
        return world.method_8320(pos.method_10074()).method_27852(class_2246.field_10382) || world.method_8320(pos.method_10074()).method_27852(class_2246.field_28681) || world.method_8320(pos.method_10074()).method_27852(class_2246.field_33409);
    }

    boolean isCopperBlock(class_2338 pos) {
        return this.method_37908().method_8477(pos) && this.method_37908().method_8320(pos).method_26164(JamiesModTag.COPPER_BLOCKS_1);
    }

    public boolean hasCopperBlock() {
        return this.copperPos != null;
    }

    public class_2338 getCopperBlockPos() {
        return this.copperPos;
    }

    public void setCopperBlockPos(class_2338 copperPos) {
        this.copperPos = copperPos;
    }

    public List<class_2338> getPossibleNests() {
        return this.moveToNestGoal.possibleNests;
    }

    private boolean failedScrapingTooLong() {
        return this.ticksSinceScraping > 3600;
    }

    public void resetScrapingTicks() {
        this.ticksSinceScraping = 0;
    }

    public void setNestPos(class_2338 pos) {
        this.nestPos = pos;
    }

    @Nullable
    private class_2338 getNestPos() {
        return this.nestPos;
    }

    private boolean hasNest() {
        return this.nestPos != null;
    }

    boolean isWithinDistance(class_2338 pos, int distance) {
        return pos.method_19771((class_2382)this.method_24515(), (double)distance);
    }

    boolean isTooFar(class_2338 pos) {
        return !this.isWithinDistance(pos, 32);
    }

    public boolean hasOxidization() {
        return this.getCopperbugFlag(8);
    }

    void setHasOxidization(boolean hasNectar) {
        if (hasNectar) {
            this.resetScrapingTicks();
        }
        this.setCopperbugFlag(8, hasNectar);
    }

    boolean isNestValid() {
        if (!this.hasNest()) {
            return false;
        }
        if (this.isTooFar(this.nestPos)) {
            return false;
        }
        class_2586 blockEntity = this.method_37908().method_8321(this.nestPos);
        return blockEntity != null && blockEntity.method_11017() == BGBlockEntities.COPPERBUGNEST;
    }

    private boolean doesNestHaveSpace(class_2338 pos) {
        class_2586 blockEntity = this.method_37908().method_8321(pos);
        if (blockEntity instanceof CopperbugNestBlockEntity) {
            return !((CopperbugNestBlockEntity)blockEntity).isFullOfCopperbugs();
        }
        return false;
    }

    boolean canEnterNest() {
        if (this.cannotEnterNestTicks <= 0 && !this.scrapeGoal.isRunning() && !this.method_29511() && this.method_5968() == null) {
            boolean bl = this.failedScrapingTooLong() || this.method_37908().method_8419() || this.method_37908().method_23886() || this.hasOxidization();
            return bl && !this.isNestNearFire();
        }
        return false;
    }

    private boolean isNestNearFire() {
        if (this.nestPos == null) {
            return false;
        }
        class_2586 blockEntity = this.method_37908().method_8321(this.nestPos);
        return blockEntity instanceof CopperbugNestBlockEntity && ((CopperbugNestBlockEntity)blockEntity).isNearFire();
    }

    public void setCannotEnterNestTicks(int cannotEnterNestTicks) {
        this.cannotEnterNestTicks = cannotEnterNestTicks;
    }

    private void resetCopperCounter() {
        this.copperUpdatedSinceScraping = 0;
    }

    void addCopperCounter() {
        ++this.copperUpdatedSinceScraping;
    }

    private int getCopperOxidizedSinceScraping() {
        return this.copperUpdatedSinceScraping;
    }

    public void onOxidizationDelivered() {
        this.setHasOxidization(false);
        this.resetCopperCounter();
    }

    private void setCopperbugFlag(int bit, boolean value) {
        if (value) {
            this.field_6011.method_12778(COPPERBUG_FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(COPPERBUG_FLAGS) | bit)));
        } else {
            this.field_6011.method_12778(COPPERBUG_FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(COPPERBUG_FLAGS) & ~bit)));
        }
    }

    private boolean getCopperbugFlag(int location) {
        return ((Byte)this.field_6011.method_12789(COPPERBUG_FLAGS) & location) != 0;
    }

    private static void cleanOxidationAround(class_1937 world, class_2338 pos, class_2338.class_2339 mutablePos, int count) {
        Optional<class_2338> optional;
        mutablePos.method_10101((class_2382)pos);
        for (int i = 0; i < count && !(optional = CopperbugEntity.cleanOxidationAround(world, (class_2338)mutablePos)).isEmpty(); ++i) {
            mutablePos.method_10101((class_2382)optional.get());
        }
    }

    private static Optional<class_2338> cleanOxidationAround(class_1937 world, class_2338 pos) {
        class_2338 blockPos;
        class_2680 blockState;
        Iterator var2 = class_2338.method_34848((class_5819)world.field_9229, (int)10, (class_2338)pos, (int)1).iterator();
        do {
            if (var2.hasNext()) continue;
            return Optional.empty();
        } while (!((blockState = world.method_8320(blockPos = (class_2338)var2.next())).method_26204() instanceof class_5955));
        class_2338 finalBlockPos = blockPos;
        class_5955.method_34735((class_2680)blockState).ifPresent(state -> world.method_8501(finalBlockPos, state));
        world.method_20290(3002, blockPos, -1);
        return Optional.of(blockPos);
    }

    private void startMovingTo(class_2338 pos) {
        class_243 vec3d2;
        class_243 vec3d = class_243.method_24955((class_2382)pos);
        int i = 0;
        class_2338 blockPos = this.method_24515();
        int j = (int)vec3d.field_1351 - blockPos.method_10264();
        if (j > 2) {
            i = 4;
        } else if (j < -2) {
            i = -4;
        }
        int k = 6;
        int l = 8;
        int m = blockPos.method_19455((class_2382)pos);
        if (m < 15) {
            k = m / 2;
            l = m / 2;
        }
        if ((vec3d2 = class_5531.method_31508((class_1314)this, (int)k, (int)l, (int)i, (class_243)vec3d, (double)0.3141592741012573)) != null) {
            this.field_6189.method_23964(0.5f);
            this.field_6189.method_6337(vec3d2.field_1352, vec3d2.field_1351, vec3d2.field_1350, 1.0);
        }
    }

    class EnterNestGoal
    extends class_1352 {
        EnterNestGoal() {
        }

        public boolean method_6264() {
            if (CopperbugEntity.this.hasNest() && CopperbugEntity.this.canEnterNest()) {
                class_2586 blockEntity;
                assert (CopperbugEntity.this.nestPos != null);
                if (CopperbugEntity.this.nestPos.method_19769((class_2374)CopperbugEntity.this.method_19538(), 2.0) && (blockEntity = CopperbugEntity.this.method_37908().method_8321(CopperbugEntity.this.nestPos)) instanceof CopperbugNestBlockEntity) {
                    CopperbugNestBlockEntity beenestBlockEntity = (CopperbugNestBlockEntity)blockEntity;
                    if (!beenestBlockEntity.isFullOfCopperbugs()) {
                        return true;
                    }
                    CopperbugEntity.this.nestPos = null;
                }
            }
            return false;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            class_2586 blockEntity = CopperbugEntity.this.method_37908().method_8321(CopperbugEntity.this.nestPos);
            if (blockEntity instanceof CopperbugNestBlockEntity) {
                CopperbugNestBlockEntity beenestBlockEntity = (CopperbugNestBlockEntity)blockEntity;
                beenestBlockEntity.tryEnterNest((class_1297)CopperbugEntity.this);
            }
        }
    }

    private class AttackGoal
    extends class_1366 {
        public AttackGoal() {
            super((class_1314)CopperbugEntity.this, 1.25, true);
        }

        protected void method_6288(class_1309 target) {
            if (this.method_53715(target)) {
                this.method_28346();
                this.field_6503.method_6121((class_1297)target);
                CopperbugEntity.this.setWarning(false);
            } else if (this.field_6503.method_5858((class_1297)target) < (double)((target.method_17681() + 3.0f) * (target.method_17681() + 3.0f))) {
                if (this.method_28347()) {
                    CopperbugEntity.this.setWarning(false);
                    this.method_28346();
                }
                if (this.method_28348() <= 10) {
                    CopperbugEntity.this.setWarning(true);
                    CopperbugEntity.this.playWarningSound();
                }
            } else {
                this.method_28346();
                CopperbugEntity.this.setWarning(false);
            }
        }

        public void method_6270() {
            CopperbugEntity.this.setWarning(false);
            super.method_6270();
        }
    }

    class ScrapeGoal
    extends class_1352 {
        private final Predicate<class_2680> copperPredicate = state -> {
            if (state.method_28498((class_2769)class_2741.field_12508) && ((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                return false;
            }
            return state.method_26164(JamiesModTag.COPPER_BLOCKS_1);
        };
        private int pollinationTicks;
        private int lastPollinationTick;
        private boolean running;
        @Nullable
        private class_243 nextTarget;
        private int ticks;
        private final CopperbugEntity bug;
        private final class_1937 level;

        public ScrapeGoal(CopperbugEntity bug) {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
            this.bug = bug;
            this.level = bug.method_37908();
        }

        public boolean method_6264() {
            if (CopperbugEntity.this.ticksUntilCanScraping > 0) {
                return false;
            }
            if (CopperbugEntity.this.hasOxidization()) {
                return false;
            }
            Optional<class_2338> optional = this.getFlower();
            if (optional.isPresent()) {
                CopperbugEntity.this.copperPos = optional.get();
                CopperbugEntity.this.field_6189.method_6337((double)CopperbugEntity.this.copperPos.method_10263() + 0.5, (double)CopperbugEntity.this.copperPos.method_10264() + 0.5, (double)CopperbugEntity.this.copperPos.method_10260() + 0.5, (double)1.2f);
                return true;
            }
            CopperbugEntity.this.ticksUntilCanScraping = class_3532.method_15395((class_5819)CopperbugEntity.this.field_5974, (int)20, (int)60);
            return false;
        }

        public boolean method_6266() {
            if (!this.running) {
                return false;
            }
            if (!CopperbugEntity.this.hasCopperBlock()) {
                return false;
            }
            if (CopperbugEntity.this.method_37908().method_8419()) {
                return false;
            }
            if (this.completedPollination()) {
                return CopperbugEntity.this.field_5974.method_43057() < 0.2f;
            }
            if (CopperbugEntity.this.field_6012 % 20 == 0 && !CopperbugEntity.this.isCopperBlock(CopperbugEntity.this.copperPos)) {
                CopperbugEntity.this.copperPos = null;
                return false;
            }
            return true;
        }

        private boolean completedPollination() {
            return this.pollinationTicks > 400;
        }

        boolean isRunning() {
            return this.running;
        }

        void cancel() {
            this.running = false;
        }

        public void method_6269() {
            this.pollinationTicks = 0;
            this.ticks = 0;
            this.lastPollinationTick = 0;
            this.running = true;
            CopperbugEntity.this.resetScrapingTicks();
        }

        public void method_6270() {
            if (this.completedPollination()) {
                CopperbugEntity.this.setHasOxidization(true);
            }
            this.running = false;
            CopperbugEntity.this.field_6189.method_6340();
            CopperbugEntity.this.ticksUntilCanScraping = 200;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            ++this.ticks;
            if (this.ticks > 600) {
                CopperbugEntity.this.copperPos = null;
            } else {
                assert (CopperbugEntity.this.copperPos != null);
                class_243 vec3d = class_243.method_24955((class_2382)CopperbugEntity.this.copperPos).method_1031(0.0, (double)0.6f, 0.0);
                if (vec3d.method_1022(CopperbugEntity.this.method_19538()) > 1.0) {
                    this.nextTarget = vec3d;
                    this.moveToNextTarget();
                } else {
                    if (this.nextTarget == null) {
                        this.nextTarget = vec3d;
                    }
                    boolean bl = CopperbugEntity.this.method_19538().method_1022(this.nextTarget) <= 0.1;
                    boolean bl2 = true;
                    if (!bl && this.ticks > 600) {
                        CopperbugEntity.this.copperPos = null;
                    } else {
                        if (bl) {
                            boolean bl3;
                            boolean bl4 = bl3 = CopperbugEntity.this.field_5974.method_43048(25) == 0;
                            if (bl3) {
                                this.nextTarget = new class_243(vec3d.method_10216() + (double)this.getRandomOffset(), vec3d.method_10214(), vec3d.method_10215() + (double)this.getRandomOffset());
                                CopperbugEntity.this.field_6189.method_6340();
                            } else {
                                bl2 = false;
                            }
                            CopperbugEntity.this.method_5988().method_20248(vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215());
                        }
                        if (bl2) {
                            this.moveToNextTarget();
                        }
                        ++this.pollinationTicks;
                        if (!this.level.field_9236 && CopperbugEntity.this.field_5974.method_43057() < 0.05f && this.pollinationTicks > this.lastPollinationTick + 60) {
                            this.lastPollinationTick = this.pollinationTicks;
                            Optional optional1 = class_5955.method_34735((class_2680)this.level.method_8320(CopperbugEntity.this.copperPos));
                            if (optional1.isPresent()) {
                                CopperbugEntity.this.method_5783(BGSoundEvents.COPPERBUG_EAT_ADDITIONS_EVENT, 1.0f, 1.0f);
                                this.level.method_20290(3005, CopperbugEntity.this.copperPos, 0);
                                this.level.method_8652(CopperbugEntity.this.copperPos, (class_2680)optional1.get(), 11);
                                this.level.method_43276((class_6880)class_5712.field_28733, CopperbugEntity.this.copperPos, class_5712.class_7397.method_43286((class_1297)CopperbugEntity.this, (class_2680)((class_2680)optional1.get())));
                            }
                        }
                    }
                }
            }
        }

        private void moveToNextTarget() {
            CopperbugEntity.this.method_5962().method_6239(this.nextTarget.method_10216(), this.nextTarget.method_10214(), this.nextTarget.method_10215(), (double)0.35f);
        }

        private float getRandomOffset() {
            return (CopperbugEntity.this.field_5974.method_43057() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<class_2338> getFlower() {
            return this.findFlower(this.copperPredicate, 5.0);
        }

        private Optional<class_2338> findFlower(Predicate<class_2680> predicate, double searchDistance) {
            class_2338 blockPos = CopperbugEntity.this.method_24515();
            class_2338.class_2339 mutable = new class_2338.class_2339();
            int i = 0;
            while ((double)i <= searchDistance) {
                int j = 0;
                while ((double)j < searchDistance) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            mutable.method_25504((class_2382)blockPos, k, i - 1, l);
                            if (blockPos.method_19771((class_2382)mutable, searchDistance) && predicate.test(CopperbugEntity.this.method_37908().method_8320((class_2338)mutable))) {
                                return Optional.of(mutable);
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }
    }

    class CopperbugRevengeGoal
    extends class_1399 {
        public CopperbugRevengeGoal() {
            super((class_1314)CopperbugEntity.this, new Class[0]);
        }

        public void method_6269() {
            super.method_6269();
            if (CopperbugEntity.this.isTriggerItem()) {
                this.method_6317();
                this.method_6270();
            }
        }

        protected void method_6319(class_1308 mob, class_1309 target) {
            if (mob instanceof CopperbugEntity || !((CopperbugEntity)mob).isTriggerItem()) {
                super.method_6319(mob, target);
            }
        }
    }

    class IsCopperOrVerdigrisGoal
    extends class_1400<class_1657> {
        public IsCopperOrVerdigrisGoal() {
            super((class_1308)CopperbugEntity.this, class_1657.class, 20, true, true, null);
        }

        public boolean method_6264() {
            if (!CopperbugEntity.this.method_6109() && super.method_6264()) {
                List list = CopperbugEntity.this.method_37908().method_18467(CopperbugEntity.class, CopperbugEntity.this.method_5829().method_1009(8.0, 4.0, 8.0));
                for (CopperbugEntity CopperbugEntity2 : list) {
                    if (!CopperbugEntity2.isTriggerItem()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double method_6326() {
            return super.method_6326() * 0.5;
        }
    }

    class MoveToNestGoal
    extends class_1352 {
        public static final int field_30295 = 600;
        int ticks;
        private static final int field_30296 = 3;
        final List<class_2338> possibleNests;
        @Nullable
        private class_11 path;
        private static final int field_30297 = 60;
        private int ticksUntilLost;

        MoveToNestGoal() {
            this.ticks = CopperbugEntity.this.method_37908().field_9229.method_43048(10);
            this.possibleNests = Lists.newArrayList();
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return CopperbugEntity.this.nestPos != null && !CopperbugEntity.this.method_18410() && CopperbugEntity.this.canEnterNest() && !this.isCloseEnough(CopperbugEntity.this.nestPos) && CopperbugEntity.this.method_37908().method_8320(CopperbugEntity.this.nestPos).method_26164(JamiesModTag.COPPERBUGNESTS);
        }

        public boolean method_6266() {
            return this.method_6264();
        }

        public void method_6269() {
            this.ticks = 0;
            this.ticksUntilLost = 0;
            super.method_6269();
        }

        public void method_6270() {
            this.ticks = 0;
            this.ticksUntilLost = 0;
            CopperbugEntity.this.field_6189.method_6340();
            CopperbugEntity.this.field_6189.method_23965();
        }

        public void method_6268() {
            if (CopperbugEntity.this.nestPos != null) {
                ++this.ticks;
                if (this.ticks > this.method_38847(600)) {
                    this.makeChosenNestPossibleNest();
                } else if (!CopperbugEntity.this.field_6189.method_23966()) {
                    if (!CopperbugEntity.this.isWithinDistance(CopperbugEntity.this.nestPos, 16)) {
                        if (CopperbugEntity.this.isTooFar(CopperbugEntity.this.nestPos)) {
                            this.setLost();
                        } else {
                            CopperbugEntity.this.startMovingTo(CopperbugEntity.this.nestPos);
                        }
                    } else {
                        boolean bl = this.startMovingToFar(CopperbugEntity.this.nestPos);
                        if (!bl) {
                            this.makeChosenNestPossibleNest();
                        } else if (this.path != null && CopperbugEntity.this.field_6189.method_6345().method_41(this.path)) {
                            ++this.ticksUntilLost;
                            if (this.ticksUntilLost > 60) {
                                this.setLost();
                                this.ticksUntilLost = 0;
                            }
                        } else {
                            this.path = CopperbugEntity.this.field_6189.method_6345();
                        }
                    }
                }
            }
        }

        private boolean startMovingToFar(class_2338 pos) {
            CopperbugEntity.this.field_6189.method_23964(10.0f);
            CopperbugEntity.this.field_6189.method_58160((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 2, 1.0);
            return CopperbugEntity.this.field_6189.method_6345() != null && CopperbugEntity.this.field_6189.method_6345().method_21655();
        }

        boolean isPossibleNest(class_2338 pos) {
            return this.possibleNests.contains(pos);
        }

        private void addPossibleNest(class_2338 pos) {
            this.possibleNests.add(pos);
            while (this.possibleNests.size() > 3) {
                this.possibleNests.remove(0);
            }
        }

        void clearPossibleNests() {
            this.possibleNests.clear();
        }

        private void makeChosenNestPossibleNest() {
            if (CopperbugEntity.this.nestPos != null) {
                this.addPossibleNest(CopperbugEntity.this.nestPos);
            }
            this.setLost();
        }

        private void setLost() {
            CopperbugEntity.this.nestPos = null;
            CopperbugEntity.this.ticksLeftToFindNest = 200;
        }

        private boolean isCloseEnough(class_2338 pos) {
            if (CopperbugEntity.this.isWithinDistance(pos, 2)) {
                return true;
            }
            class_11 path = CopperbugEntity.this.field_6189.method_6345();
            return path != null && path.method_48().equals((Object)pos) && path.method_21655() && path.method_46();
        }
    }

    class OxidizeCopperGoal
    extends class_1352 {
        static final int field_30299 = 30;

        OxidizeCopperGoal() {
        }

        public boolean method_6264() {
            if (CopperbugEntity.this.getCopperOxidizedSinceScraping() >= 10) {
                return false;
            }
            if (CopperbugEntity.this.field_5974.method_43057() < 0.3f) {
                return false;
            }
            return CopperbugEntity.this.hasOxidization() && CopperbugEntity.this.isNestValid();
        }

        public boolean method_6266() {
            return this.method_6264();
        }

        public void method_6268() {
            if (CopperbugEntity.this.field_5974.method_43048(this.method_38847(30)) == 0) {
                for (int i = 1; i <= 2; ++i) {
                    class_2338 blockPos = CopperbugEntity.this.method_24515().method_10087(i);
                    class_2680 blockState = CopperbugEntity.this.method_37908().method_8320(blockPos);
                    class_2248 block = blockState.method_26204();
                    class_2680 blockState2 = null;
                    if (!blockState.method_26164(JamiesModTag.COPPER_BLOCKS_1)) continue;
                    Optional optional2 = class_5955.method_34735((class_2680)blockState);
                    if (block instanceof class_5812) {
                        class_5812 copperBlock = (class_5812)block;
                        if (optional2.isPresent()) {
                            CopperbugEntity.this.method_37908().method_8396(null, blockPos, BGSoundEvents.COPPERBUG_EAT_ADDITIONS_EVENT, class_3419.field_15245, 1.0f, 1.0f);
                            CopperbugEntity.this.method_37908().method_8444(null, 3005, blockPos, 0);
                        }
                        if (copperBlock.method_33632() != class_5955.class_5811.field_28707) {
                            copperBlock.method_33632();
                        }
                    }
                    if (block instanceof class_2302) {
                        class_2302 cropBlock = (class_2302)block;
                        if (!cropBlock.method_9825(blockState)) {
                            blockState2 = cropBlock.method_9828(cropBlock.method_9829(blockState) + 1);
                        }
                    } else if (block instanceof class_2513) {
                        j = (Integer)blockState.method_11654((class_2769)class_2513.field_11584);
                        if (j < 7) {
                            blockState2 = (class_2680)blockState.method_11657((class_2769)class_2513.field_11584, (Comparable)Integer.valueOf(j + 1));
                        }
                    } else if (blockState.method_27852(class_2246.field_16999)) {
                        j = (Integer)blockState.method_11654((class_2769)class_3830.field_17000);
                        if (j < 3) {
                            blockState2 = (class_2680)blockState.method_11657((class_2769)class_3830.field_17000, (Comparable)Integer.valueOf(j + 1));
                        }
                    } else if (blockState.method_27852(class_2246.field_28675) || blockState.method_27852(class_2246.field_28676)) {
                        ((class_2256)blockState.method_26204()).method_9652((class_3218)CopperbugEntity.this.method_37908(), CopperbugEntity.this.field_5974, blockPos, blockState);
                    }
                    if (blockState2 == null) continue;
                    CopperbugEntity.this.method_37908().method_20290(5011, blockPos, 15);
                    CopperbugEntity.this.method_37908().method_8501(blockPos, blockState2);
                    CopperbugEntity.this.addCopperCounter();
                }
            }
        }
    }

    class MoveToCopperGoal
    extends class_1352 {
        private static final int MAX_FLOWER_NAVIGATION_TICKS = 600;
        int ticks;

        MoveToCopperGoal() {
            this.ticks = CopperbugEntity.this.method_37908().field_9229.method_43048(10);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return CopperbugEntity.this.copperPos != null && !CopperbugEntity.this.method_18410() && this.shouldMoveToFlower() && CopperbugEntity.this.isCopperBlock(CopperbugEntity.this.copperPos) && !CopperbugEntity.this.isWithinDistance(CopperbugEntity.this.copperPos, 2);
        }

        public boolean method_6266() {
            return this.method_6264();
        }

        public void method_6269() {
            this.ticks = 0;
            super.method_6269();
        }

        public void method_6270() {
            this.ticks = 0;
            CopperbugEntity.this.field_6189.method_6340();
            CopperbugEntity.this.field_6189.method_23965();
        }

        public void method_6268() {
            if (CopperbugEntity.this.copperPos != null) {
                ++this.ticks;
                if (this.ticks > this.method_38847(600)) {
                    CopperbugEntity.this.copperPos = null;
                } else if (!CopperbugEntity.this.field_6189.method_23966()) {
                    if (CopperbugEntity.this.isTooFar(CopperbugEntity.this.copperPos)) {
                        CopperbugEntity.this.copperPos = null;
                    } else {
                        CopperbugEntity.this.startMovingTo(CopperbugEntity.this.copperPos);
                    }
                }
            }
        }

        private boolean shouldMoveToFlower() {
            return CopperbugEntity.this.ticksSinceScraping > 2400;
        }
    }

    class FindNestGoal
    extends class_1352 {
        FindNestGoal() {
        }

        public boolean method_6264() {
            return CopperbugEntity.this.ticksLeftToFindNest == 0 && !CopperbugEntity.this.hasNest() && CopperbugEntity.this.canEnterNest();
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6269() {
            CopperbugEntity.this.ticksLeftToFindNest = 200;
            List list = this.getNearbyFreeNests();
            if (!list.isEmpty()) {
                class_2338 blockPos;
                Iterator var2 = list.iterator();
                do {
                    if (var2.hasNext()) continue;
                    CopperbugEntity.this.moveToNestGoal.clearPossibleNests();
                    CopperbugEntity.this.nestPos = (class_2338)list.get(0);
                    return;
                } while (CopperbugEntity.this.moveToNestGoal.isPossibleNest(blockPos = (class_2338)var2.next()));
                CopperbugEntity.this.nestPos = blockPos;
            }
        }

        private List getNearbyFreeNests() {
            class_2338 blockPos = CopperbugEntity.this.method_24515();
            class_4153 pointOfInterestStorage = ((class_3218)CopperbugEntity.this.method_37908()).method_19494();
            Stream stream = pointOfInterestStorage.method_19125(poiType -> poiType.method_40220(JamiesModTag.PointOfInterests.COPPERBUG_HOME), blockPos, 20, class_4153.class_4155.field_18489);
            return stream.map(class_4156::method_19141).filter(CopperbugEntity.this::doesNestHaveSpace).sorted(Comparator.comparingDouble(blockPos2 -> blockPos2.method_10262((class_2382)blockPos))).collect(Collectors.toList());
        }
    }
}

