/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.common.worldgen.feature;

import com.jamiedev.bygone.common.block.PointedAmberBlock;
import com.jamiedev.bygone.core.registry.BGBlocks;
import java.util.function.Consumer;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5691;

public class AmberHelper {
    public static double scaleHeightFromRadius(double radius, double scale, double heightScale, double bluntness) {
        if (radius < bluntness) {
            radius = bluntness;
        }
        double d = 0.384;
        double e = radius / scale * 0.384;
        double f = 0.75 * Math.pow(e, 1.3333333333333333);
        double g = Math.pow(e, 0.6666666666666666);
        double h = 0.3333333333333333 * Math.log(e);
        double i = heightScale * (f - g - h);
        i = Math.max(i, 0.0);
        return i / 0.384 * scale;
    }

    public static boolean canGenerateBase(class_5281 world, class_2338 pos, int height) {
        if (AmberHelper.canGenerateOrLava((class_1936)world, pos)) {
            return false;
        }
        float f = 6.0f;
        float g = 6.0f / (float)height;
        for (float h = 0.0f; h < (float)Math.PI * 2; h += g) {
            int j;
            int i = (int)(class_3532.method_15362((float)h) * (float)height);
            if (!AmberHelper.canGenerateOrLava((class_1936)world, pos.method_10069(i, 0, j = (int)(class_3532.method_15374((float)h) * (float)height)))) continue;
            return false;
        }
        return true;
    }

    public static boolean canGenerate(class_1936 world, class_2338 pos) {
        return world.method_16358(pos, AmberHelper::canGenerate);
    }

    public static boolean canGenerateOrLava(class_1936 world, class_2338 pos) {
        return world.method_16358(pos, AmberHelper::canGenerateOrLava);
    }

    protected static void getAmberThickness(class_2350 direction, int height, boolean merge, Consumer<class_2680> callback) {
        if (height >= 3) {
            callback.accept(AmberHelper.getState(direction, class_5691.field_28068));
            for (int i = 0; i < height - 3; ++i) {
                callback.accept(AmberHelper.getState(direction, class_5691.field_28067));
            }
        }
        if (height >= 2) {
            callback.accept(AmberHelper.getState(direction, class_5691.field_28066));
        }
        if (height >= 1) {
            callback.accept(AmberHelper.getState(direction, merge ? class_5691.field_28064 : class_5691.field_28065));
        }
    }

    protected static void generatePointedAmber(class_1936 world, class_2338 pos, class_2350 direction, int height, boolean merge) {
        if (AmberHelper.canReplace(world.method_8320(pos.method_10093(direction.method_10153())))) {
            class_2338.class_2339 mutable = pos.method_25503();
            AmberHelper.getAmberThickness(direction, height, merge, state -> {
                if (state.method_27852(BGBlocks.POINTED_AMBER.get())) {
                    state = (class_2680)state.method_11657((class_2769)PointedAmberBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.method_22351((class_2338)mutable)));
                }
                world.method_8652((class_2338)mutable, state, 2);
                mutable.method_10098(direction);
            });
        }
    }

    protected static boolean generateAmberBlock(class_1936 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        if (blockState.method_26164(class_3481.field_28089)) {
            world.method_8652(pos, BGBlocks.AMBER_SAND.get().method_9564(), 2);
            return true;
        }
        return false;
    }

    private static class_2680 getState(class_2350 direction, class_5691 thickness) {
        return (class_2680)((class_2680)BGBlocks.POINTED_AMBER.get().method_9564().method_11657((class_2769)PointedAmberBlock.VERTICAL_DIRECTION, (Comparable)direction)).method_11657(PointedAmberBlock.THICKNESS, (Comparable)thickness);
    }

    public static boolean canReplaceOrLava(class_2680 state) {
        return AmberHelper.canReplace(state) || state.method_27852(class_2246.field_10164);
    }

    public static boolean canReplace(class_2680 state) {
        return state.method_27852(BGBlocks.AMBER_SANDSTONE.get()) || state.method_27852(BGBlocks.AMBER_SAND.get()) || state.method_26164(class_3481.field_28089);
    }

    public static boolean canGenerate(class_2680 state) {
        return state.method_26215() || state.method_27852(class_2246.field_10382);
    }

    public static boolean cannotGenerate(class_2680 state) {
        return !state.method_26215() && !state.method_27852(class_2246.field_10382);
    }

    public static boolean canGenerateOrLava(class_2680 state) {
        return state.method_26215() || state.method_27852(class_2246.field_10382) || state.method_27852(class_2246.field_10164);
    }
}

