/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.core.platform;

import com.jamiedev.bygone.core.network.C2SModPacket;
import com.jamiedev.bygone.core.network.S2CModPacket;
import com.jamiedev.bygone.core.platform.services.IPlatformHelper;
import com.jamiedev.bygone.core.registry.AttachmentTypesFabric;
import java.util.Collection;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class FabricPlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Fabric";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    @Override
    public <MSG extends S2CModPacket<?>> void registerClientPlayPacket(class_8710.class_9154<MSG> type, class_9139<class_9129, MSG> streamCodec) {
        PayloadTypeRegistry.playS2C().register(type, streamCodec);
        if (MixinEnvironment.getCurrentEnvironment().getSide() == MixinEnvironment.Side.CLIENT) {
            ClientPlayNetworking.registerGlobalReceiver(type, (payload, context) -> context.client().execute(payload::handleClient));
        }
    }

    @Override
    public <MSG extends C2SModPacket<?>> void registerServerPlayPacket(class_8710.class_9154<MSG> type, class_9139<class_9129, MSG> streamCodec) {
        PayloadTypeRegistry.playC2S().register(type, streamCodec);
        ServerPlayNetworking.registerGlobalReceiver(type, (payload, context) -> context.player().field_13995.execute(() -> payload.handleServer(context.player())));
    }

    @Override
    public void sendToClient(S2CModPacket<?> msg, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, msg);
    }

    @Override
    public void sendToServer(C2SModPacket<?> msg) {
        ClientPlayNetworking.send(msg);
    }

    @Override
    public void sendToTracking(S2CModPacket<?> msg, class_1297 entity, boolean includeSelf) {
        Collection trackingPlayers = PlayerLookup.tracking((class_1297)entity);
        for (class_3222 tracking : trackingPlayers) {
            this.sendToClient(msg, tracking);
        }
        if (includeSelf && entity instanceof class_3222) {
            class_3222 self = (class_3222)entity;
            this.sendToClient(msg, self);
        }
    }

    @Override
    @Nullable
    public int getTimeInBygone(class_1297 entity) {
        return (Integer)entity.getAttached(AttachmentTypesFabric.TIME_IN_BYGONE);
    }

    @Override
    public void setTimeInBygone(class_1297 entity, int time) {
        entity.setAttached(AttachmentTypesFabric.TIME_IN_BYGONE, (Object)time);
    }
}

