/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone;

import com.jamiedev.bygone.common.entity.BigBeakEntity;
import com.jamiedev.bygone.common.entity.CoelacanthEntity;
import com.jamiedev.bygone.common.entity.CopperbugEntity;
import com.jamiedev.bygone.common.entity.DuckEntity;
import com.jamiedev.bygone.common.entity.FungalParentEntity;
import com.jamiedev.bygone.common.entity.GlareEntity;
import com.jamiedev.bygone.common.entity.LithyEntity;
import com.jamiedev.bygone.common.entity.MoobooEntity;
import com.jamiedev.bygone.common.entity.NectaurEntity;
import com.jamiedev.bygone.common.entity.PeskyEntity;
import com.jamiedev.bygone.common.entity.PestEntity;
import com.jamiedev.bygone.common.entity.SabeastEntity;
import com.jamiedev.bygone.common.entity.ScuttleEntity;
import com.jamiedev.bygone.common.entity.TrilobiteEntity;
import com.jamiedev.bygone.common.entity.WhiskbillEntity;
import com.jamiedev.bygone.common.entity.WispEntity;
import com.jamiedev.bygone.common.entity.WraithEntity;
import com.jamiedev.bygone.common.util.Consumer4;
import com.jamiedev.bygone.core.init.JamiesModTag;
import com.jamiedev.bygone.core.mixin.AxeItemAccess;
import com.jamiedev.bygone.core.registry.BGBiomes;
import com.jamiedev.bygone.core.registry.BGBlockEntities;
import com.jamiedev.bygone.core.registry.BGBlockProperties;
import com.jamiedev.bygone.core.registry.BGBlocks;
import com.jamiedev.bygone.core.registry.BGDimensions;
import com.jamiedev.bygone.core.registry.BGEntityTypes;
import com.jamiedev.bygone.core.registry.BGFeatures;
import com.jamiedev.bygone.core.registry.BGFishingTables;
import com.jamiedev.bygone.core.registry.BGItemGroups;
import com.jamiedev.bygone.core.registry.BGItems;
import com.jamiedev.bygone.core.registry.BGParticleTypes;
import com.jamiedev.bygone.core.registry.BGSoundEvents;
import com.jamiedev.bygone.core.registry.BGStructures;
import com.jamiedev.bygone.core.util.HeightGetter;
import com.kekecreations.jinxedlib.core.util.JinxedRegistryHelper;
import java.util.IdentityHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Bygone {
    public static final Supplier<DataComponentType<Integer>> MAP_HEIGHT = JinxedRegistryHelper.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"bygone", (String)"map_height", () -> HeightGetter.MAP_HEIGHT);
    public static final String MOD_ID = "bygone";
    public static final Logger LOGGER = LogManager.getLogger((String)"bygone");
    private static int timeInBygone;
    private static Level level;

    public static void init() {
        BGBlocks.init();
        BGBlockEntities.init();
        BGItems.init();
        BGEntityTypes.postInit();
        BGBiomes.init();
        BGBlockProperties.init();
        BGItemGroups.register();
        BGFishingTables.init();
    }

    public static void registerStrippables() {
        IdentityHashMap<Block, Block> stripables = new IdentityHashMap<Block, Block>(AxeItemAccess.getStripables());
        stripables.put(BGBlocks.ANCIENT_LOG.get(), BGBlocks.STRIPPED_ANCIENT_LOG.get());
        stripables.put(BGBlocks.ANCIENT_WOOD.get(), BGBlocks.STRIPPED_ANCIENT_WOOD.get());
        stripables.put(BGBlocks.SABLE_LOG.get(), BGBlocks.STRIPPED_SABLE_LOG.get());
        stripables.put(BGBlocks.SABLE_WOOD.get(), BGBlocks.STRIPPED_SABLE_WOOD.get());
        AxeItemAccess.setStripables(stripables);
    }

    public static ResourceLocation id(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id);
    }

    public static void registerBuiltIn() {
        BGFeatures.init();
        BGStructures.init();
        BGParticleTypes.init();
        BGSoundEvents.init();
    }

    public static void initAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> consumer) {
        consumer.accept(BGEntityTypes.DUCK.get(), DuckEntity.createDuckAttributes().build());
        consumer.accept(BGEntityTypes.BIG_BEAK.get(), BigBeakEntity.createBigBeakAttributes().build());
        consumer.accept(BGEntityTypes.GLARE.get(), GlareEntity.createGlareAttributes().build());
        consumer.accept(BGEntityTypes.SCUTTLE.get(), ScuttleEntity.createAttributes().build());
        consumer.accept(BGEntityTypes.COELACANTH.get(), CoelacanthEntity.createAttributes().build());
        consumer.accept(BGEntityTypes.TRILOBITE.get(), TrilobiteEntity.createAttributes().build());
        consumer.accept(BGEntityTypes.MOOBOO.get(), MoobooEntity.createAttributes().build());
        consumer.accept(BGEntityTypes.COPPERBUG.get(), CopperbugEntity.createCopperbugAttributes().build());
        consumer.accept(BGEntityTypes.FUNGAL_PARENT.get(), FungalParentEntity.createFungieAttributes().build());
        consumer.accept(BGEntityTypes.PESKY.get(), PeskyEntity.createAttributes().build());
        consumer.accept(BGEntityTypes.PEST.get(), PestEntity.createAttributes().build());
        consumer.accept(BGEntityTypes.WHISKBILL.get(), WhiskbillEntity.createAttributes().build());
        consumer.accept(BGEntityTypes.NECTAUR.get(), NectaurEntity.createAttributes().build());
        consumer.accept(BGEntityTypes.LITHY.get(), LithyEntity.createAttributes().build());
        consumer.accept(BGEntityTypes.WISP.get(), WispEntity.createAttributes().build());
        consumer.accept(BGEntityTypes.WRAITH.get(), WraithEntity.createAttributes().build());
        consumer.accept(BGEntityTypes.SABEAST.get(), SabeastEntity.createAttributes().build());
    }

    public static <T extends Mob> void registerSpawnPlacements(Consumer4<EntityType<T>, SpawnPlacementType, Heightmap.Types, SpawnPlacements.SpawnPredicate<T>> consumer) {
        consumer.accept(BGEntityTypes.SCUTTLE.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, iServerWorld, reason1, pos1, random1) -> ScuttleEntity.checkSurfaceWaterAnimalSpawnRule((EntityType<? extends WaterAnimal>)entityType, (LevelAccessor)iServerWorld, reason1, pos1, random1));
        consumer.accept(BGEntityTypes.GLARE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, GlareEntity::canSpawn);
        consumer.accept(BGEntityTypes.BIG_BEAK.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, BigBeakEntity::canSpawn);
        consumer.accept(BGEntityTypes.TRILOBITE.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type1, world1, reason1, pos1, random1) -> TrilobiteEntity.checkSurfaceWaterAnimalSpawnRule((EntityType<? extends WaterAnimal>)type1, (LevelAccessor)world1, reason1, pos1, random1));
        consumer.accept(BGEntityTypes.COPPERBUG.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, (type1, world1, spawnReason, pos1, random1) -> CopperbugEntity.canSpawn((EntityType<CopperbugEntity>)type1, (LevelAccessor)world1, spawnReason, pos1, random1));
        consumer.accept(BGEntityTypes.COELACANTH.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (type, world, reason, pos, random) -> CoelacanthEntity.checkSurfaceWaterAnimalSpawnRule((EntityType<CoelacanthEntity>)type, (LevelAccessor)world, reason, pos, random));
        consumer.accept(BGEntityTypes.PESKY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, GlareEntity::canSpawn);
        consumer.accept(BGEntityTypes.PEST.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, GlareEntity::canSpawn);
        consumer.accept(BGEntityTypes.NECTAUR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, BigBeakEntity::canSpawn);
        consumer.accept(BGEntityTypes.WHISKBILL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, BigBeakEntity::canSpawn);
        consumer.accept(BGEntityTypes.LITHY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, LithyEntity::canSpawn);
        consumer.accept(BGEntityTypes.WISP.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, LithyEntity::canSpawn);
        consumer.accept(BGEntityTypes.WRAITH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, LithyEntity::canSpawn);
        consumer.accept(BGEntityTypes.SABEAST.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, LithyEntity::canSpawn);
        consumer.accept(BGEntityTypes.MOOBOO.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LithyEntity::canSpawn);
        consumer.accept(BGEntityTypes.FUNGAL_PARENT.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, FungalParentEntity::canSpawn);
    }

    public static void addValidBlocks(BiConsumer<BlockEntityType<?>, Block> consumer) {
        consumer.accept(BlockEntityType.SIGN, BGBlocks.ANCIENT_SIGN.get());
        consumer.accept(BlockEntityType.SIGN, BGBlocks.ANCIENT_WALL_SIGN.get());
        consumer.accept(BlockEntityType.HANGING_SIGN, BGBlocks.ANCIENT_HANGING_SIGN.get());
        consumer.accept(BlockEntityType.HANGING_SIGN, BGBlocks.ANCIENT_WALL_HANGING_SIGN.get());
        consumer.accept(BlockEntityType.SIGN, BGBlocks.SABLE_SIGN.get());
        consumer.accept(BlockEntityType.SIGN, BGBlocks.SABLE_WALL_SIGN.get());
        consumer.accept(BlockEntityType.HANGING_SIGN, BGBlocks.SABLE_HANGING_SIGN.get());
        consumer.accept(BlockEntityType.HANGING_SIGN, BGBlocks.SABLE_WALL_HANGING_SIGN.get());
    }

    public static void addFlammable() {
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.ANCIENT_WOOD.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.ANCIENT_LOG.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.ANCIENT_PLANKS.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.ANCIENT_SLAB.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.ANCIENT_STAIRS.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.ANCIENT_PRESSURE_PLATE.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.ANCIENT_BUTTON.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.ANCIENT_TRAPDOOR.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.ANCIENT_FENCE_GATE.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.ANCIENT_FENCE.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.ANCIENT_DOOR.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.SABLE_WOOD.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.SABLE_LOG.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.SABLE_PLANKS.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.SABLE_SLAB.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.SABLE_STAIRS.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.SABLE_PRESSURE_PLATE.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.SABLE_BUTTON.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.SABLE_TRAPDOOR.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.SABLE_FENCE_GATE.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.SABLE_FENCE.get(), 5, 20);
        ((FireBlock)Blocks.FIRE).setFlammable(BGBlocks.SABLE_DOOR.get(), 5, 20);
    }

    public static boolean isSprinklerNearby(LevelReader world, BlockPos pos) {
        Iterable var2 = BlockPos.betweenClosed((BlockPos)pos.offset(-15, 0, -15), (BlockPos)pos.offset(15, 1, 15));
        for (BlockPos pos1 : var2) {
            if (!world.getBlockState(pos1).is(JamiesModTag.SPRINKLERS)) continue;
            return true;
        }
        return false;
    }

    public static Level level() {
        return level;
    }

    public static void tickCow(Cow cow) {
        if (Bygone.canCowZombify(cow)) {
            if (++timeInBygone > 300) {
                Bygone.zombify(cow);
            }
        } else {
            timeInBygone = 0;
        }
    }

    public static boolean canCowZombify(Cow cow) {
        return cow.level().dimension() == BGDimensions.BYGONE_LEVEL_KEY && !cow.isNoAi();
    }

    protected static void zombify(Cow cow) {
        MoobooEntity moobooEntity = (MoobooEntity)cow.convertTo(BGEntityTypes.MOOBOO.get(), true);
        if (moobooEntity != null) {
            moobooEntity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
        }
    }

    public static Stream<Block> getKnownBlocks() {
        return Bygone.getKnown(BuiltInRegistries.BLOCK);
    }

    public static Stream<Item> getKnownItems() {
        return Bygone.getKnown(BuiltInRegistries.ITEM);
    }

    public static <V> Stream<V> getKnown(Registry<V> registry) {
        return registry.stream().filter(o -> registry.getKey(o).getNamespace().equals(MOD_ID));
    }
}

