/*
 * Decompiled with CFR 0.152.
 */
package com.jamiedev.bygone.client.models;

import com.google.common.collect.ImmutableList;
import com.jamiedev.bygone.client.models.animations.BigBeakAnimations;
import com.jamiedev.bygone.common.entity.BigBeakEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BigBeakModel<T extends BigBeakEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart head;
    private final ModelPart body;

    public BigBeakModel(ModelPart root) {
        this.root = root;
        this.rightLeg = root.getChild("rightLeg");
        this.leftLeg = root.getChild("leftLeg");
        this.rightWing = root.getChild("rightWing");
        this.leftWing = root.getChild("leftWing");
        this.head = root.getChild("head");
        this.body = root.getChild("body");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(64, 20).mirror().addBox(-1.5f, 0.0f, -2.0f, 3.0f, 17.0f, 4.0f, new CubeDeformation(-0.01f)).mirror(false), PartPose.offset((float)-3.5f, (float)7.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(64, 20).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 17.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.offset((float)3.5f, (float)7.0f, (float)0.0f));
        PartDefinition rightWing = partdefinition.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(43, 37).mirror().addBox(-2.0f, -8.0f, 0.0f, 2.0f, 13.0f, 16.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-5.0f, (float)2.0f, (float)-13.0f));
        PartDefinition leftWing = partdefinition.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(43, 37).addBox(0.0f, -8.0f, 0.0f, 2.0f, 13.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)2.0f, (float)-13.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 64).addBox(-3.0f, -19.25f, -3.5f, 6.0f, 24.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 37).addBox(-2.0f, -21.25f, -16.5f, 4.0f, 9.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.75f, (float)-12.5f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -7.5f, -10.5f, 10.0f, 15.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)-2.5f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(78, 1).addBox(-5.0f, 0.0f, -2.0f, 10.0f, 6.0f, 15.0f, new CubeDeformation(-0.25f)), PartPose.offset((float)0.0f, (float)-7.5f, (float)10.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.root;
    }

    protected Iterable<ModelPart> getHeadParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> getBodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightWing, (Object)this.leftWing, (Object)this.leftLeg, (Object)this.rightLeg);
    }

    private void setHeadAngles(float headYaw, float headPitch) {
        headYaw = Mth.clamp((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.setHeadAngles(headYaw, headPitch);
        this.animate(((BigBeakEntity)((Object)entity)).idleAnimationState, BigBeakAnimations.BIGBEAK_IDLE, animationProgress, 1.0f);
        this.animate(((BigBeakEntity)((Object)entity)).flappingAnimationState, BigBeakAnimations.BIGBEAK_FLAP, animationProgress, 0.5f);
        this.animateWalk(BigBeakAnimations.BIGBEAK_FLAP, limbAngle, limbDistance, 2.0f, 2.5f);
        this.animateWalk(BigBeakAnimations.BIGBEAK_WALKING_BEFUZZY_STYLED, limbAngle, limbDistance, 2.0f, 2.5f);
    }
}

